set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2223103',
      NULL,
      0,
      5,
      3,
      '2134',
      0,
      1.420291,
      NULL,
      NULL,
      ' 5-21-1980',
      34.038376,
      NULL,
      0,
      3,
      1.102930,
      ' 9- 5-1994',
      38.276631,
      2.259502,
      51,
      37,
      2,
      ' 6-25-1983',
      NULL,
      NULL,
      1.624147,
      1,
      1,
      NULL,
      0,
      2.343576,
      NULL,
      0,
      NULL,
      14,
      NULL,
      4.777456,
      5.413130,
      3.325857,
      25.249716,
      3.638386,
      16,
      0,
      0,
      2.266514,
      NULL,
      1,
      1.322257,
      1,
      0.575394,
      NULL,
      1.410428,
      1.795971,
      0.482107,
      NULL,
      0,
      0.843219,
      NULL,
      2.414462,
      1.858657,
      5.323332,
      0,
      1,
      NULL,
      4,
      NULL,
      1.437574,
      2.657182,
      0.258557,
      0.654913,
      NULL,
      0.450674,
      NULL,
      1,
      5.892087,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.922474,
      1,
      0.453313,
      3,
      1,
      2.473214,
      NULL,
      0.959702,
      3,
      1,
      0,
      0.611006,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      5.645635,
      1.498358,
      0,
      3,
      1.023541,
      1,
      1.111644,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      4.139400,
      NULL,
      7.540852,
      1,
      1.845721,
      0,
      7.681103,
      1.509506,
      NULL,
      NULL,
      9.459939,
      0.770869,
      0.025365,
      NULL,
      NULL,
      1.801261,
      NULL,
      0,
      NULL,
      0.945077,
      1.372141,
      0,
      3.114668,
      1.543123,
      3.646427,
      5.585086,
      7,
      4.387934,
      1.598111,
      NULL,
      7.867891,
      1.081374,
      0.773029,
      7.520749,
      5,
      6.063641,
      NULL,
      3.450420,
      0.112566,
      3,
      6.036283,
      3.600309,
      NULL,
      NULL,
      0.024419,
      ' 7-12-1974',
      459.609928,
      ' 2-17-2002',
      NULL,
      0.252921,
      NULL,
      1,
      1.174784,
      2.294999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.644776,
      1.529410,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.088490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265674,
      3,
      2,
      NULL,
      2.168705,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.312990,
      0,
      NULL,
      1.787366,
      1.879964,
      0,
      NULL,
      NULL,
      31,
      2.046839,
      0.490735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      0.523082,
      NULL,
      1.095928,
      1,
      3,
      1,
      1,
      3,
      NULL,
      0.420500,
      3,
      1.728835,
      2,
      0.277415,
      NULL,
      0.019815,
      0.847563,
      1,
      1.557262,
      0.977883,
      0.380681,
      1.527258,
      0,
      NULL,
      4,
      0.265991,
      3,
      NULL,
      NULL,
      9,
      9.619236,
      1,
      4,
      NULL,
      5.576469,
      0.236335,
      NULL,
      0.766972,
      NULL,
      NULL,
      0.371879,
      NULL,
      31.137878,
      56,
      27,
      NULL,
      0.816115,
      0.943217,
      '41022',
      '',
      NULL,
      1.889460,
      '',
      NULL,
      NULL,
      0.990353,
      '',
      '',
      NULL,
      3.153282,
      10.560054,
      8.839920,
      19.186810,
      0.974223,
      27.664560,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531140,
      NULL,
      NULL,
      0,
      2.769340,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.062706,
      NULL,
      1.413614,
      2.931062,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.001360,
      NULL,
      1.971290,
      NULL,
      NULL,
      0.037336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.741364,
      8,
      2.857395,
      1.373024,
      1,
      NULL,
      NULL,
      NULL,
      0.268353,
      NULL,
      NULL,
      NULL,
      NULL,
      3.375516,
      0,
      0.209546,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.354262,
      0,
      3,
      1.246353,
      2.345406,
      NULL,
      0,
      2.906189,
      NULL,
      NULL,
      2.060489,
      2,
      1.197098,
      1.141946,
      1,
      0,
      3.320388,
      0.329025,
      0.495656,
      3.443776,
      1,
      0,
      NULL,
      NULL,
      0.679701,
      NULL,
      4,
      1.083071,
      1,
      NULL,
      NULL,
      NULL,
      1.539042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.330535,
      0,
      0,
      NULL,
      2.651859,
      NULL,
      NULL,
      3,
      2,
      4.416391,
      5.463003,
      3,
      3,
      1.276846,
      1,
      NULL,
      NULL,
      NULL,
      0.146135,
      5.508180,
      1.912645,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.042901,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.752493,
      3,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.719439,
      3.269117,
      4,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      2.783226,
      3,
      1.808182,
      NULL,
      0,
      2.567258,
      1,
      2.618405,
      6,
      1,
      0.930180,
      1,
      NULL,
      2,
      2.080043,
      0.315772,
      1,
      1.482931,
      2,
      2.515186,
      1.646434,
      3,
      NULL,
      7,
      5,
      3.599800,
      NULL,
      2,
      3.022335,
      NULL,
      3.191791,
      1.650908,
      NULL,
      0.044525,
      NULL,
      1.522353,
      0,
      NULL,
      NULL,
      1.583887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.559139,
      NULL,
      NULL,
      NULL,
      1.134164,
      0,
      1.933162,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.062840,
      NULL,
      NULL,
      NULL,
      4.502244,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.658384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.717427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609837,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.690495,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236406,
      NULL,
      NULL,
      NULL,
      17.408709,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      2.776288,
      35.959967,
      34.811374,
      0,
      13,
      2.973167,
      0.471656,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.464555,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      1,
      1.855484,
      0.829722,
      0,
      0,
      NULL,
      0.091378,
      NULL,
      1.292163,
      0.667790,
      0.479213,
      0.933497,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.831819,
      5,
      4.944211,
      0,
      0,
      5,
      4.794306,
      2,
      1,
      NULL,
      0,
      1.219856,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.676620,
      1,
      NULL,
      2.105010,
      2.138588,
      NULL,
      0.521044,
      NULL,
      NULL,
      3.589383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770446,
      1,
      NULL,
      1,
      2.889265,
      NULL,
      3.372273,
      3.043978,
      NULL,
      1,
      NULL,
      1.597780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.872547,
      NULL,
      0,
      NULL,
      0.805790,
      NULL,
      1,
      NULL,
      0.480822,
      NULL,
      0,
      NULL,
      1.362136,
      NULL,
      1.817293,
      NULL,
      0.824862,
      NULL,
      0,
      NULL,
      0.743615,
      NULL,
      3,
      NULL,
      16.421649,
      NULL,
      2,
      NULL,
      NULL,
      0.217977,
      NULL,
      1.701854,
      NULL,
      7.369965,
      4,
      10.772384,
      3,
      1,
      1.118535,
      NULL,
      25.268250,
      3.720524,
      1,
      3,
      NULL,
      '',
      '',
      1.840604,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


