set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      NULL,
      8,
      NULL,
      3,
      1,
      1,
      0,
      '1140',
      1,
      1,
      NULL,
      NULL,
      NULL,
      11,
      23,
      NULL,
      2.280238,
      2.137015,
      ' 5-29-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-23-2002',
      NULL,
      ' 6-15-2000',
      0,
      0.982403,
      0.221598,
      NULL,
      0.645799,
      NULL,
      NULL,
      1.217648,
      0,
      5,
      0,
      12.618138,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      2.642230,
      1,
      NULL,
      1,
      2.516488,
      1.281320,
      0,
      1,
      1,
      NULL,
      3.176576,
      1,
      0,
      0,
      3.318095,
      3,
      NULL,
      0.262736,
      9,
      0.411178,
      0.695718,
      NULL,
      7.823299,
      1.263922,
      1,
      NULL,
      0,
      0.908690,
      1.290375,
      NULL,
      NULL,
      NULL,
      3,
      1.620921,
      1,
      0.251107,
      NULL,
      NULL,
      1.442643,
      NULL,
      NULL,
      6,
      2,
      1,
      NULL,
      1.394730,
      1,
      3,
      2,
      1.644642,
      1.403816,
      3.387256,
      1.257962,
      3.047029,
      0.678315,
      0.727011,
      NULL,
      1.750510,
      NULL,
      NULL,
      0.844236,
      1.064096,
      3,
      6.661136,
      0,
      2,
      0.401658,
      1.027348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.822222,
      3,
      0.669604,
      NULL,
      0.101582,
      0.208067,
      0.848258,
      NULL,
      1.922305,
      5.177097,
      2,
      0,
      1,
      0.304531,
      0,
      NULL,
      0.452665,
      1.229989,
      NULL,
      0.326199,
      1.765877,
      0,
      4.533605,
      2,
      0,
      5,
      0.293195,
      6,
      3.980585,
      NULL,
      3.640128,
      7,
      7.009014,
      1.552492,
      6,
      8,
      NULL,
      NULL,
      6.318985,
      5.607014,
      NULL,
      1.288718,
      2,
      NULL,
      ' 0-29-1982',
      115,
      ' 4-18-1992',
      11,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192328,
      5.417482,
      3.273539,
      NULL,
      1.846979,
      0,
      0.320677,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.498074,
      NULL,
      0,
      3.506611,
      NULL,
      1.167918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.608843,
      2,
      0.069037,
      0,
      2.860808,
      NULL,
      4.665123,
      NULL,
      3,
      4.130613,
      7,
      1.301236,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991931,
      NULL,
      1,
      3.781031,
      0.238082,
      0,
      1,
      0.280479,
      17.095172,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.115891,
      NULL,
      1.918879,
      NULL,
      2.616529,
      1,
      NULL,
      0,
      3,
      1.661939,
      2,
      0,
      0.623724,
      0,
      0,
      0.653183,
      0,
      5,
      1.285060,
      NULL,
      0,
      NULL,
      0.889637,
      NULL,
      1.817177,
      1.951288,
      0.939510,
      1.180735,
      0.187925,
      NULL,
      8.997921,
      11.430269,
      7,
      8.168960,
      NULL,
      1,
      2.113508,
      0,
      4.074521,
      3,
      2.400923,
      NULL,
      67.751984,
      3.170670,
      0,
      17.988557,
      NULL,
      60,
      7.059421,
      1,
      NULL,
      0,
      '44440',
      '02143',
      '34044',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      33,
      NULL,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.651066,
      2,
      0,
      0.047274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792530,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.939091,
      NULL,
      NULL,
      0.671837,
      NULL,
      NULL,
      0.739824,
      NULL,
      NULL,
      1,
      2.058631,
      1,
      0.058983,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.419315,
      1.673912,
      0.059214,
      1,
      NULL,
      NULL,
      1.681559,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.321772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522762,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791197,
      0.219669,
      1,
      0.578780,
      1.611495,
      NULL,
      NULL,
      4,
      2,
      3.350373,
      1.980059,
      NULL,
      3,
      0.139105,
      1,
      0,
      2.933269,
      2,
      2,
      1.787363,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.707350,
      NULL,
      NULL,
      0.488977,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.108150,
      NULL,
      NULL,
      0.704243,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.816616,
      0,
      NULL,
      1.617272,
      NULL,
      NULL,
      2,
      0,
      3,
      3.796721,
      NULL,
      1,
      NULL,
      1.439683,
      2.617479,
      0,
      NULL,
      6,
      3.214677,
      3.834150,
      NULL,
      NULL,
      1,
      3.510528,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.259653,
      NULL,
      3.268197,
      0,
      1,
      5.694173,
      NULL,
      0,
      NULL,
      NULL,
      0.495039,
      1.261807,
      0.804280,
      1,
      1.716300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679376,
      NULL,
      0.364819,
      NULL,
      0,
      0.907366,
      1,
      5.129733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.125350,
      0,
      NULL,
      NULL,
      0.395040,
      0.218559,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.456047,
      NULL,
      NULL,
      0.721252,
      0.591883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960249,
      NULL,
      NULL,
      1.880511,
      NULL,
      NULL,
      NULL,
      1.441244,
      0.798713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.738609,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1.388125,
      NULL,
      NULL,
      NULL,
      9.452022,
      NULL,
      NULL,
      2.454772,
      0,
      1.419389,
      NULL,
      NULL,
      NULL,
      3,
      3.458152,
      2.430677,
      NULL,
      3,
      4,
      0.688960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832531,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.175909,
      93.622195,
      1,
      NULL,
      NULL,
      1,
      1.384688,
      NULL,
      1,
      1.215020,
      0,
      0,
      0,
      1.272528,
      1.572896,
      1,
      1.941956,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.325096,
      NULL,
      2,
      NULL,
      1.958585,
      NULL,
      1,
      NULL,
      0,
      NULL,
      42.054862,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422676,
      NULL,
      NULL,
      NULL,
      3.762790,
      NULL,
      1.325367,
      NULL,
      NULL,
      NULL,
      0.253710,
      NULL,
      1.686366,
      NULL,
      1.296983,
      NULL,
      0.553481,
      NULL,
      1.753001,
      NULL,
      0.618331,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.538068,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540653,
      0.784109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.711658,
      NULL,
      2.591467,
      NULL,
      0.563108,
      NULL,
      188,
      NULL,
      3.263560,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3.869182,
      0.469250,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.238584,
      NULL,
      NULL,
      NULL,
      517,
      NULL,
      0.706030,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      644,
      NULL,
      NULL,
      NULL,
      0.323199,
      NULL,
      1,
      1.364231,
      0.334269,
      3,
      41,
      1,
      NULL,
      NULL,
      NULL,
      3.431851,
      3,
      3.662882,
      2.190777,
      5,
      NULL,
      0.876938,
      5.431706,
      11,
      3,
      2,
      NULL,
      NULL,
      1.362826,
      0.326375,
      0,
      0.717916,
      1,
      3.592234,
      2.120297,
      0,
      0,
      1.090252,
      0,
      1,
      NULL,
      NULL,
      3,
      3,
      0.253586,
      1,
      1,
      0,
      NULL,
      1,
      0.557522,
      1,
      NULL,
      NULL,
      0.377973,
      2.278034,
      3.974267,
      0,
      3.351935,
      2.339797,
      2,
      2,
      0.614416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.583706,
      0.796530,
      0.962364,
      1.903308,
      2.786572,
      1,
      0,
      1.727952,
      3,
      3.193944,
      3.674629,
      3,
      2,
      NULL,
      3.872048,
      NULL,
      0.164813,
      2.515342,
      0.191629,
      0.161729,
      2.269355,
      0.403049,
      1,
      3.870999,
      3,
      8,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0.614257,
      NULL,
      0,
      0.410146,
      6.802877,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      37,
      3.511166,
      3,
      NULL,
      '20113',
      '21040',
      '04121',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


