set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5513125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '4314210',
      1.571913,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.080330,
      NULL,
      NULL,
      2.813392,
      10.062552,
      NULL,
      34,
      3,
      36,
      34,
      NULL,
      ' 9-20-1994',
      ' 3-16-2002',
      ' 9-13-1974',
      NULL,
      NULL,
      1.532964,
      0,
      0,
      NULL,
      8.928962,
      0,
      NULL,
      NULL,
      NULL,
      4.502559,
      4.001687,
      NULL,
      NULL,
      2,
      0.238787,
      2.075845,
      NULL,
      6.112926,
      0.032082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1,
      1,
      1,
      2.485371,
      1.723576,
      NULL,
      3.049795,
      1,
      0,
      1.228747,
      3.652236,
      11.308344,
      0.294960,
      NULL,
      NULL,
      2.872159,
      1.343045,
      2,
      1.203746,
      NULL,
      1.579923,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.723414,
      NULL,
      0.512684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866081,
      1,
      1.367997,
      0.959983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956821,
      2,
      5.906034,
      1,
      6.674147,
      6.387826,
      3,
      0.524974,
      6,
      5.029847,
      1.815269,
      0.562249,
      NULL,
      1,
      0.976206,
      1.830229,
      NULL,
      1,
      1,
      NULL,
      1,
      1.546194,
      NULL,
      0.613381,
      1.007010,
      2.909215,
      1.018417,
      1.539512,
      0,
      1.106809,
      0.409548,
      0.858914,
      0,
      0,
      1.257354,
      1,
      2.946027,
      0,
      2,
      2,
      3.602319,
      6.016780,
      6,
      5,
      NULL,
      1.536016,
      0,
      NULL,
      ' 6-22-1997',
      263.862250,
      ' 5-27-1976',
      368,
      3,
      NULL,
      0.617744,
      1,
      1.800664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584629,
      4,
      1.150891,
      2,
      1,
      0.426698,
      NULL,
      1.457730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742265,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.840192,
      1.327371,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046804,
      3.351668,
      0,
      0.117418,
      0.057445,
      NULL,
      NULL,
      NULL,
      NULL,
      0.926132,
      3,
      1.536344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.633000,
      1,
      NULL,
      0.040973,
      0.275070,
      0.872304,
      NULL,
      NULL,
      1.942059,
      NULL,
      NULL,
      NULL,
      0,
      0.952571,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      2,
      1.303130,
      0,
      2.855722,
      NULL,
      NULL,
      3.488797,
      0,
      3.659761,
      1,
      1,
      4.698542,
      1.207276,
      1,
      1.048540,
      0.541987,
      0,
      0.248849,
      1,
      0.699521,
      2,
      NULL,
      3.819262,
      0,
      2,
      3,
      7,
      NULL,
      0.754304,
      4,
      3,
      NULL,
      2.754111,
      0.254462,
      2,
      0.355154,
      6,
      0.639745,
      NULL,
      NULL,
      NULL,
      63.980121,
      81,
      0,
      0.061564,
      0,
      '30321',
      '',
      '',
      0.118750,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      7.200661,
      122.881439,
      45.629248,
      3.202382,
      17,
      NULL,
      4,
      1.050311,
      3,
      1,
      1.758012,
      1,
      NULL,
      NULL,
      0.400753,
      NULL,
      NULL,
      1.935416,
      NULL,
      3,
      0.173650,
      NULL,
      NULL,
      0.889533,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573945,
      2,
      1.938365,
      0.941351,
      0.148568,
      3.507972,
      0.867580,
      NULL,
      NULL,
      NULL,
      0,
      1.506664,
      0.511908,
      1.255910,
      0.052547,
      1.487356,
      0,
      1.893938,
      5.155176,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.382782,
      NULL,
      NULL,
      NULL,
      0.097722,
      NULL,
      NULL,
      0.066536,
      NULL,
      NULL,
      0.308328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001597,
      NULL,
      NULL,
      1.202298,
      NULL,
      NULL,
      0.347871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.363395,
      NULL,
      NULL,
      2,
      3.440230,
      2,
      1,
      NULL,
      NULL,
      4.019121,
      NULL,
      4.421250,
      1.481089,
      1,
      0,
      1,
      NULL,
      0,
      6.778969,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104994,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444579,
      1,
      4,
      3,
      NULL,
      1.768214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035242,
      0,
      1,
      NULL,
      NULL,
      0.160623,
      NULL,
      NULL,
      4.562351,
      0,
      1.417895,
      2.635718,
      3.583859,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0,
      2.449396,
      1,
      2.090002,
      3.728777,
      6,
      3.682686,
      4.102313,
      3,
      1,
      3.975355,
      3.313323,
      0,
      0.574471,
      1,
      NULL,
      0,
      NULL,
      2.673022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.435464,
      NULL,
      NULL,
      3.065058,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.795022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.516817,
      2,
      1,
      1.947858,
      0.131578,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.851025,
      NULL,
      NULL,
      NULL,
      1.124747,
      NULL,
      NULL,
      3,
      0.095274,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.590189,
      0,
      NULL,
      NULL,
      2,
      0.267519,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.387436,
      1.666638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389598,
      0.949905,
      2.989816,
      NULL,
      30.412063,
      2.858429,
      1.075352,
      NULL,
      NULL,
      0.447348,
      NULL,
      NULL,
      1.487234,
      1.851624,
      2.223796,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.902111,
      1852.820331,
      1226.205722,
      0,
      2,
      0.243359,
      0.507086,
      0.860743,
      1.204797,
      1,
      NULL,
      0.007270,
      3,
      0.813711,
      1.873866,
      1,
      0.041331,
      0.734688,
      0.211155,
      1.290868,
      1.793086,
      NULL,
      NULL,
      NULL,
      1.626488,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1820.928140,
      NULL,
      108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.737216,
      1.832503,
      11.367779,
      2.175116,
      3.780301,
      1,
      3.769777,
      15,
      0.090761,
      1,
      0.082560,
      NULL,
      1.545333,
      NULL,
      1.393395,
      1.811451,
      NULL,
      1,
      1.583950,
      NULL,
      0.811267,
      0.704457,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.830340,
      NULL,
      1,
      2.287021,
      NULL,
      1,
      0,
      NULL,
      0.807045,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.339449,
      NULL,
      1.597803,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.079851,
      NULL,
      NULL,
      4,
      12.510177,
      1.483113,
      0,
      0.069535,
      30,
      41.857059,
      6,
      0.453669,
      NULL,
      '44203',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


