set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9623778';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '1400214',
      NULL,
      1,
      3,
      NULL,
      '2123',
      NULL,
      1.312690,
      NULL,
      NULL,
      ' 5- 5-1978',
      29,
      NULL,
      3.397620,
      0,
      1.269766,
      NULL,
      7,
      1.582166,
      236.228739,
      120,
      0.156405,
      ' 4-19-1975',
      ' 7-27-1995',
      ' 6-29-1993',
      NULL,
      3.917681,
      3,
      NULL,
      1.045798,
      3.159773,
      NULL,
      0.222757,
      1,
      NULL,
      7,
      NULL,
      0.583675,
      17.105770,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.051784,
      NULL,
      3,
      0.336362,
      NULL,
      3,
      NULL,
      0,
      1.873385,
      0.994394,
      0.827003,
      NULL,
      3.511509,
      0,
      NULL,
      0.715828,
      0,
      0.040710,
      NULL,
      1.256033,
      0,
      2.695390,
      NULL,
      NULL,
      3.792394,
      0,
      0,
      10.391398,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.844015,
      10.137068,
      NULL,
      2.187250,
      1,
      NULL,
      0,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1.536824,
      1.585353,
      0,
      2.332461,
      1.739108,
      NULL,
      1.104748,
      0,
      NULL,
      1.984689,
      3.605333,
      0,
      0,
      NULL,
      NULL,
      1.714404,
      NULL,
      NULL,
      0.677534,
      NULL,
      1.220383,
      0.684891,
      NULL,
      1.499227,
      1.121412,
      0.989023,
      0,
      NULL,
      1.408328,
      1,
      1.837682,
      0.781271,
      NULL,
      1.364344,
      1.533479,
      1.148419,
      1,
      NULL,
      NULL,
      1.416122,
      3,
      3.742703,
      0.948113,
      1,
      2,
      3,
      NULL,
      1,
      1.353646,
      0,
      0.838891,
      1,
      0.583179,
      0,
      6.686813,
      1.435012,
      5.743005,
      1,
      6,
      2.391522,
      4.762239,
      NULL,
      1.724872,
      NULL,
      2.744922,
      0.275182,
      ' 3- 7-1989',
      59.106359,
      ' 7- 1-1980',
      13,
      1,
      1,
      0.582084,
      2,
      0.059788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1.140427,
      1.862462,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.145065,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.050231,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.929832,
      1.331776,
      0.028530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.232871,
      0,
      1,
      0,
      NULL,
      38,
      0.899498,
      1.209060,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379623,
      2,
      0,
      1.465798,
      NULL,
      2,
      NULL,
      0,
      3.798165,
      2.356956,
      0,
      NULL,
      0,
      NULL,
      12,
      109.210653,
      14.969033,
      185,
      164.543395,
      45,
      NULL,
      5,
      1,
      1,
      3.719047,
      1.743811,
      0,
      2.535492,
      1.102714,
      2.367445,
      NULL,
      5,
      8.234676,
      3,
      1,
      3,
      NULL,
      1.394734,
      3,
      1,
      3,
      0,
      NULL,
      18,
      3,
      NULL,
      NULL,
      6.814372,
      11,
      57,
      0.190691,
      0,
      1.751630,
      '10304',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      NULL,
      326,
      24.816862,
      NULL,
      NULL,
      2.901074,
      2.468051,
      2,
      2,
      2,
      0.484787,
      0,
      0,
      NULL,
      NULL,
      0.628664,
      0.335726,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.087052,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.178871,
      NULL,
      NULL,
      3,
      0.339405,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      6,
      0,
      1.408307,
      1,
      NULL,
      NULL,
      NULL,
      0.832603,
      NULL,
      NULL,
      NULL,
      1.905420,
      3.607416,
      NULL,
      1,
      NULL,
      0.834301,
      3.579258,
      3,
      0,
      3.961387,
      0.249158,
      1.272150,
      3.588340,
      3,
      3.970914,
      NULL,
      1.284192,
      0.130517,
      0.097668,
      2.671671,
      NULL,
      1.305979,
      1.848448,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.126911,
      NULL,
      0,
      0.828164,
      NULL,
      3,
      1.756048,
      0.448420,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811189,
      NULL,
      NULL,
      0.635095,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.526429,
      NULL,
      NULL,
      0.004135,
      NULL,
      NULL,
      1.782362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.811026,
      1.285041,
      NULL,
      NULL,
      1.102160,
      1.672890,
      1,
      2.072866,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.160545,
      NULL,
      3.554068,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.014190,
      0.234964,
      1.891072,
      2.982562,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.443799,
      1,
      3,
      3,
      NULL,
      1.343674,
      0.940748,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871945,
      NULL,
      NULL,
      0.761478,
      NULL,
      NULL,
      0.217191,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.286498,
      NULL,
      NULL,
      1.240720,
      NULL,
      NULL,
      1.670472,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.124336,
      1.431028,
      0,
      1.793663,
      0.485283,
      2.061708,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.598501,
      NULL,
      NULL,
      0.077919,
      0.966211,
      NULL,
      NULL,
      0,
      0.351900,
      NULL,
      NULL,
      0.777742,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.855845,
      NULL,
      NULL,
      NULL,
      3.495767,
      2.339397,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      5.424169,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.938157,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008567,
      1.579635,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      3.673353,
      NULL,
      NULL,
      1.946392,
      NULL,
      0,
      NULL,
      0.905914,
      1.024384,
      0,
      0,
      1,
      0.690146,
      1,
      1,
      0,
      0,
      0.560004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.644283,
      NULL,
      1.858774,
      NULL,
      2.152664,
      0.424589,
      3,
      2.552867,
      NULL,
      2.575781,
      1,
      0.752990,
      1.771234,
      1.631045,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0.733453,
      3.135982,
      2.124322,
      1.550201,
      0,
      NULL,
      0.633240,
      0.859666,
      NULL,
      1,
      1.150406,
      0,
      NULL,
      1.885264,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0.555668,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.650105,
      NULL,
      0.673338,
      1.819321,
      1.826910,
      1,
      2,
      7.945132,
      1.792611,
      1,
      NULL,
      NULL,
      70,
      68,
      4.453111,
      0.219404,
      1.127953,
      '04141',
      '',
      '',
      0,
      '',
      '',
      '',
      0.710166,
      NULL,
      '',
      '');
commit;
end;
/


