set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4611223';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1142434',
      2,
      0.560435,
      3,
      0,
      '1220',
      2.991991,
      1.198251,
      NULL,
      9,
      ' 8- 9-1993',
      21.458137,
      NULL,
      5.326124,
      0.591727,
      1.182755,
      NULL,
      56.831593,
      2,
      207.464247,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.598896,
      2.231114,
      1.800902,
      NULL,
      1.382370,
      6,
      0.684169,
      NULL,
      NULL,
      NULL,
      3.492286,
      2.558875,
      12,
      26,
      NULL,
      31,
      NULL,
      NULL,
      5,
      2.593005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.826671,
      NULL,
      3.281171,
      NULL,
      1,
      1,
      1.969389,
      1,
      0.748043,
      0,
      1,
      0.023936,
      NULL,
      0.098684,
      NULL,
      1.981375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.988191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.670094,
      0.374869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838430,
      1,
      NULL,
      0.009536,
      NULL,
      0,
      0.750838,
      NULL,
      0.735561,
      0,
      0.989156,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.455917,
      NULL,
      1.699077,
      2.774263,
      0,
      0.258683,
      1.721499,
      1.459740,
      4.552835,
      5.436906,
      0.594736,
      1,
      1,
      2,
      1.223598,
      5,
      0.716552,
      4,
      4.962643,
      5.534738,
      3.001925,
      NULL,
      6,
      1.801087,
      8.875314,
      4,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.800663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.768806,
      1.532380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.201357,
      1,
      1.274177,
      NULL,
      NULL,
      NULL,
      5,
      1.229318,
      0.758980,
      NULL,
      0,
      NULL,
      0.521367,
      NULL,
      NULL,
      NULL,
      0.973544,
      1,
      1.088854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.011196,
      1,
      NULL,
      1.899299,
      NULL,
      1.390664,
      NULL,
      NULL,
      NULL,
      189.683121,
      612.020308,
      1624.899231,
      1,
      0,
      NULL,
      NULL,
      2.956734,
      3,
      1,
      1.342677,
      NULL,
      3,
      2,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      1.781462,
      3.428608,
      0.401716,
      NULL,
      0,
      0.538809,
      0,
      0.009446,
      0,
      1,
      1.085551,
      1.673847,
      NULL,
      0.582220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440259,
      78,
      NULL,
      NULL,
      NULL,
      4.995623,
      1.102872,
      NULL,
      '24212',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.366803,
      NULL,
      '',
      '',
      0,
      38.574979,
      42,
      NULL,
      1,
      10.827073,
      5.492984,
      61.150658,
      0.883009,
      2,
      2,
      1.207831,
      NULL,
      NULL,
      NULL,
      1.611763,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.674502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.740785,
      1.099790,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.761162,
      16.732540,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.026183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.677277,
      NULL,
      0.275923,
      2.377179,
      1.169245,
      1,
      1,
      NULL,
      NULL,
      0,
      0.670804,
      0,
      0.592475,
      2.910880,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.627915,
      0.563344,
      3.713183,
      2.701998,
      NULL,
      0.874385,
      0,
      NULL,
      NULL,
      2.854384,
      0,
      1.445567,
      0,
      NULL,
      NULL,
      8,
      5,
      0.460170,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.716482,
      0.503429,
      1.041218,
      1,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      1,
      1.208863,
      NULL,
      NULL,
      0.552985,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.929448,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.458758,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.430506,
      3,
      0.223299,
      1,
      NULL,
      NULL,
      6.351528,
      NULL,
      1,
      2.209447,
      5,
      2.748482,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2.959133,
      0.765564,
      1,
      1.404687,
      NULL,
      NULL,
      2.280036,
      3.505264,
      NULL,
      0.835162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.006059,
      1,
      0,
      NULL,
      2,
      NULL,
      7,
      0,
      NULL,
      NULL,
      1,
      1.660398,
      2,
      0.083557,
      1.090410,
      NULL,
      1,
      0.115393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560021,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.014534,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.867430,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.441529,
      NULL,
      NULL,
      NULL,
      0.442740,
      NULL,
      NULL,
      0.409940,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249932,
      NULL,
      NULL,
      NULL,
      0,
      0.900458,
      NULL,
      NULL,
      NULL,
      1.409204,
      NULL,
      NULL,
      3,
      0.621060,
      NULL,
      NULL,
      0.963814,
      1.987061,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.945024,
      3.102405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.936417,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.994814,
      NULL,
      NULL,
      0.665820,
      NULL,
      NULL,
      1.753164,
      NULL,
      NULL,
      0,
      NULL,
      0,
      372.751153,
      735.285444,
      1,
      1,
      0.776391,
      0.324924,
      1.929116,
      0,
      1,
      NULL,
      1.265278,
      0.496565,
      1,
      0.461617,
      1.829298,
      0,
      0.673411,
      0,
      0.262242,
      0.480540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      2.717264,
      1.186775,
      NULL,
      6,
      3.032238,
      3,
      3.467825,
      NULL,
      0,
      0.234501,
      0.148975,
      1,
      1.291520,
      2.168782,
      1,
      1,
      0.971185,
      1,
      1.564382,
      0.617476,
      3,
      2.521416,
      1.647733,
      0,
      0.432755,
      1.794787,
      3.445400,
      0.299914,
      2,
      0,
      0,
      0.305830,
      1.982862,
      NULL,
      NULL,
      1.305082,
      0.256405,
      0.812742,
      0,
      1,
      NULL,
      1,
      0.587368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.282433,
      0,
      0.258231,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      5.665999,
      80.035201,
      0.522056,
      1,
      0,
      '23442',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


