set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8103026';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '4312243',
      0.385818,
      0.743191,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.679235,
      NULL,
      NULL,
      44.844121,
      NULL,
      0,
      2,
      0.016466,
      ' 2-10-1978',
      39,
      2,
      NULL,
      103,
      NULL,
      '10-16-1984',
      ' 4-16-1988',
      ' 3-28-1995',
      1.611356,
      0,
      3,
      0.661189,
      NULL,
      1,
      NULL,
      NULL,
      1,
      83,
      8,
      6,
      NULL,
      11.589751,
      11,
      NULL,
      NULL,
      NULL,
      0,
      0.918469,
      NULL,
      1,
      NULL,
      1,
      0.294907,
      0.058752,
      1.553256,
      3,
      0.500752,
      1,
      1.052890,
      NULL,
      4.581124,
      5.369162,
      3,
      9,
      0,
      0,
      1.313069,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.760100,
      1,
      1.772162,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.017657,
      NULL,
      NULL,
      0,
      0.825156,
      1.221478,
      0.839178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.845925,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902310,
      NULL,
      10,
      1.090863,
      NULL,
      1.552328,
      1.871955,
      0,
      1,
      0.576475,
      0.734264,
      0.463778,
      NULL,
      0,
      1,
      0,
      0.152460,
      NULL,
      1.457050,
      NULL,
      0.746904,
      1.557250,
      NULL,
      NULL,
      0.866620,
      0,
      3,
      2,
      0.726564,
      5,
      4.505160,
      NULL,
      NULL,
      NULL,
      NULL,
      2.157624,
      5,
      7,
      0,
      3.252740,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0,
      NULL,
      1,
      ' 7-28-2002',
      367,
      ' 1-19-1990',
      286,
      2.642167,
      NULL,
      0.353189,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176584,
      NULL,
      1,
      1.646468,
      0.625144,
      1.614736,
      1.364030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      2,
      1.892343,
      0,
      0,
      NULL,
      4.960574,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.921718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.003264,
      1,
      1,
      0.739738,
      NULL,
      NULL,
      18.857680,
      2,
      0.449282,
      NULL,
      NULL,
      NULL,
      5.414467,
      1,
      0.195288,
      NULL,
      1.811682,
      3,
      NULL,
      0,
      0.338595,
      0,
      1.799828,
      0.922447,
      4,
      2,
      0.110961,
      3,
      4.599982,
      1.778077,
      NULL,
      11.600901,
      1,
      0,
      1.354823,
      NULL,
      1,
      2.463095,
      0.599872,
      NULL,
      1,
      0,
      4.440174,
      NULL,
      5.619975,
      5,
      4,
      1.211313,
      NULL,
      3.885940,
      3.310458,
      3.564622,
      3.705076,
      3,
      2.531445,
      NULL,
      NULL,
      3.256558,
      3,
      NULL,
      37.432577,
      56,
      20,
      4.532609,
      1,
      1,
      '14123',
      '44102',
      '21432',
      0.855533,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      45,
      181,
      42.875900,
      3,
      NULL,
      1,
      17.654434,
      3,
      0,
      NULL,
      2,
      1.977748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.665379,
      NULL,
      NULL,
      1.472106,
      2.064357,
      NULL,
      0.084740,
      NULL,
      NULL,
      0.820221,
      1.412983,
      1.758206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.399609,
      2.589723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.852462,
      1.449731,
      1.058810,
      0.498268,
      NULL,
      1,
      0.343990,
      0.678196,
      1.690716,
      1.749029,
      NULL,
      1,
      0.426846,
      NULL,
      1.533496,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.035626,
      1,
      1.195230,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.037417,
      NULL,
      NULL,
      2.647017,
      0,
      NULL,
      1.070741,
      NULL,
      2.291510,
      0,
      NULL,
      NULL,
      0.178564,
      5,
      2,
      0.701773,
      1.318103,
      NULL,
      NULL,
      0,
      1,
      7,
      NULL,
      1.830126,
      1.743359,
      NULL,
      NULL,
      2.084799,
      1,
      NULL,
      0.596757,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.066994,
      0,
      1.686507,
      0.304229,
      0.252551,
      0,
      2.755965,
      3.744268,
      3.162970,
      10.933122,
      3,
      4,
      3,
      6.052503,
      4.200647,
      8.866255,
      2.957903,
      NULL,
      3,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2,
      3.550668,
      3,
      NULL,
      4.280382,
      11.118071,
      2,
      3.775743,
      0.145836,
      0,
      NULL,
      0,
      1,
      2.331661,
      0,
      3.825347,
      2.407847,
      1.727694,
      5,
      4,
      6,
      3.006727,
      1.967922,
      5.826977,
      0,
      1,
      3.481583,
      NULL,
      3,
      0,
      NULL,
      1.775309,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1731.932040,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.294821,
      NULL,
      NULL,
      1.947708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.903124,
      NULL,
      NULL,
      3.656027,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.879268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1,
      1.847394,
      1,
      NULL,
      1.389613,
      1,
      2,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      65,
      160.844960,
      NULL,
      NULL,
      2.054036,
      0.902392,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.863753,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903931,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.942846,
      NULL,
      NULL,
      NULL,
      2.670804,
      0.204471,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.117024,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.529735,
      1,
      NULL,
      NULL,
      2,
      9,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      90.059218,
      11,
      0.949185,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.638322,
      NULL,
      NULL,
      0.018882,
      NULL,
      NULL,
      0,
      NULL,
      0,
      10804.479345,
      728,
      NULL,
      0.423357,
      1,
      NULL,
      3,
      1,
      2,
      0,
      2,
      0,
      3,
      0.719031,
      NULL,
      1.618825,
      1,
      1.207702,
      NULL,
      0.003836,
      2.209431,
      NULL,
      1.550964,
      NULL,
      0.102285,
      NULL,
      1.264443,
      NULL,
      2.939601,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.274926,
      NULL,
      0.170155,
      NULL,
      1,
      NULL,
      1.366231,
      NULL,
      0.798660,
      NULL,
      NULL,
      NULL,
      0.342724,
      NULL,
      1,
      NULL,
      1.837838,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.780899,
      NULL,
      0.943794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.583402,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229388,
      NULL,
      0.157167,
      NULL,
      1,
      1.903004,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.644739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.871043,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.953035,
      0,
      0,
      0.044715,
      NULL,
      1,
      0.110417,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.628686,
      2.521400,
      0,
      8,
      3,
      NULL,
      7,
      17,
      NULL,
      0.421915,
      3.827504,
      NULL,
      4,
      9.328692,
      NULL,
      2.912584,
      0.461066,
      NULL,
      NULL,
      NULL,
      NULL,
      18.048786,
      6,
      NULL,
      1,
      2,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      2.553815,
      NULL,
      17,
      9,
      NULL,
      3,
      0.836686,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009043,
      NULL,
      NULL,
      13,
      6,
      NULL,
      1.656188,
      3.675240,
      1,
      16.473426,
      NULL,
      NULL,
      4,
      '30444',
      NULL,
      '44322',
      0.153473,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


