set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9037938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '0340120',
      1,
      NULL,
      NULL,
      NULL,
      '0233',
      2.321270,
      1,
      NULL,
      NULL,
      ' 1-16-2000',
      NULL,
      NULL,
      4,
      3,
      1,
      ' 8- 0-1976',
      98.937484,
      0.548430,
      275,
      NULL,
      2,
      ' 4-24-1980',
      NULL,
      ' 5-17-1980',
      NULL,
      0,
      2,
      1.187721,
      NULL,
      1,
      5,
      0.231877,
      0,
      454,
      0.940010,
      16.860128,
      3,
      NULL,
      64,
      7.184455,
      24.943006,
      NULL,
      3.010404,
      3.607402,
      0.436488,
      0.617302,
      0,
      0,
      1.232479,
      0.626166,
      NULL,
      NULL,
      0.923664,
      NULL,
      5,
      4.224725,
      2,
      4,
      3.056339,
      1.534199,
      0,
      1.737499,
      0.516717,
      1.944914,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020064,
      0.329013,
      NULL,
      1.114351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      0,
      3,
      NULL,
      1.370891,
      0,
      0.514394,
      1.195674,
      1.945568,
      0.758945,
      NULL,
      0.527263,
      1,
      1.967993,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.514576,
      0.990540,
      7.095535,
      0.324275,
      1,
      1.368367,
      4,
      5,
      1,
      0,
      NULL,
      0,
      9,
      3.091869,
      3.350673,
      8,
      2.746089,
      0,
      4,
      5.727882,
      1.156439,
      6,
      NULL,
      0.436748,
      NULL,
      1716.658764,
      NULL,
      1490,
      2.618887,
      0,
      NULL,
      0,
      0.485542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668129,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967743,
      NULL,
      NULL,
      1.761274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109444,
      0,
      1.785178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243807,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.450300,
      NULL,
      NULL,
      1,
      0.127270,
      NULL,
      NULL,
      NULL,
      0.062059,
      1.228509,
      1,
      NULL,
      0,
      3.186181,
      1,
      0.619217,
      1.750585,
      0.705115,
      NULL,
      2,
      NULL,
      0,
      18.662143,
      19,
      173.062521,
      NULL,
      138,
      164,
      106,
      88.384611,
      60.559665,
      65,
      151,
      2,
      18.311779,
      139,
      1,
      1.311814,
      0,
      NULL,
      3,
      5,
      NULL,
      1,
      1,
      1,
      2,
      1.336615,
      5.592280,
      1.442630,
      NULL,
      1.623395,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10123',
      NULL,
      NULL,
      1.387807,
      '',
      '',
      '',
      3,
      '0024',
      '1200',
      '41102',
      1,
      NULL,
      236,
      0.214800,
      2.545516,
      18,
      5,
      114,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.191741,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.830123,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273121,
      1,
      0.568189,
      NULL,
      1,
      1.263843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      0.185255,
      NULL,
      1.637103,
      1.826096,
      1.634565,
      NULL,
      1.678491,
      0,
      1.465772,
      3,
      1.313031,
      1,
      NULL,
      NULL,
      1.430418,
      NULL,
      NULL,
      2.614060,
      2.954786,
      3,
      1.501733,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166255,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.901712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.767292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.148609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868014,
      NULL,
      NULL,
      1.001117,
      2,
      2.616266,
      1,
      NULL,
      NULL,
      NULL,
      9.217592,
      NULL,
      2,
      NULL,
      0.159552,
      0,
      4.609401,
      3,
      NULL,
      NULL,
      NULL,
      2.987407,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7,
      2.603471,
      1.857481,
      0.963401,
      0.376452,
      NULL,
      NULL,
      2,
      0,
      1.642321,
      3,
      3,
      NULL,
      1.539422,
      0.529754,
      NULL,
      3.733863,
      NULL,
      2.088040,
      5.649699,
      0.685006,
      2.129298,
      2,
      6.311886,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248576,
      NULL,
      NULL,
      0.253051,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.005354,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904258,
      1,
      0.395306,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.961008,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182097,
      NULL,
      278,
      0.892430,
      NULL,
      NULL,
      1.793930,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.890227,
      NULL,
      NULL,
      1.326890,
      NULL,
      NULL,
      3,
      NULL,
      2.349928,
      18761.313458,
      9.033687,
      1.611684,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0.334977,
      NULL,
      1,
      0,
      1,
      1.010678,
      1,
      1.930004,
      1,
      0.201663,
      1.911448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4,
      1.083255,
      6.129383,
      3,
      4,
      13,
      0.436766,
      2.054416,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.696179,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.182406,
      0.232706,
      NULL,
      1.749390,
      0,
      NULL,
      1,
      1.313576,
      NULL,
      0,
      1.465805,
      0.429127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332101,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.486044,
      NULL,
      NULL,
      3.525482,
      3.901012,
      25,
      8.842582,
      3.511145,
      0,
      5.920304,
      '21323',
      NULL,
      '',
      1.849506,
      '',
      '',
      NULL,
      5,
      NULL,
      '2223',
      '33230');
commit;
end;
/


