set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9720166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      0,
      7,
      3,
      0,
      0.618580,
      2.759972,
      3,
      '211',
      '44331410',
      14.673994,
      32.056795,
      '4310224',
      0.395638,
      0.079462,
      1,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      ' 9-20-1999',
      124,
      NULL,
      NULL,
      1.675704,
      NULL,
      ' 4-12-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      1.494886,
      NULL,
      ' 1-21-1987',
      NULL,
      2.938860,
      1,
      2.392686,
      0,
      0,
      3.358817,
      8,
      NULL,
      0,
      1.865783,
      2,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.705364,
      11,
      3,
      5,
      1.899092,
      1,
      0,
      1.554562,
      2.130437,
      3,
      NULL,
      1.517361,
      0.748564,
      0.042042,
      1.449980,
      5,
      1.284389,
      0.107114,
      1.586021,
      1.404019,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.539647,
      0.934617,
      1.981529,
      1.072097,
      1.103148,
      NULL,
      3,
      3.517160,
      0,
      0,
      0,
      2.446535,
      1,
      3.856155,
      3.262891,
      3,
      4.274182,
      NULL,
      0.283838,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.145700,
      1.954229,
      0,
      NULL,
      0,
      0.331490,
      1.533222,
      0,
      0,
      1.528565,
      0.952833,
      0.341496,
      3,
      1,
      0,
      1.484435,
      0.854294,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1.351350,
      0,
      1.801556,
      0.131947,
      NULL,
      0.705899,
      NULL,
      0.803290,
      4,
      2,
      1,
      5.387460,
      2,
      0.031941,
      4.058422,
      1,
      5,
      0,
      1,
      1,
      1.609495,
      ' 6- 7-1986',
      423.308784,
      ' 0-17-1991',
      38.102567,
      1.571084,
      1,
      NULL,
      NULL,
      0.184194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167442,
      NULL,
      NULL,
      0,
      1.449139,
      1,
      0.580094,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      0.737034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.654079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585174,
      0,
      NULL,
      0,
      0,
      1.659691,
      1,
      3,
      0,
      2.509224,
      1,
      NULL,
      NULL,
      NULL,
      3.364094,
      0,
      0,
      0,
      NULL,
      1.580284,
      0,
      2.255431,
      1,
      NULL,
      NULL,
      3.848631,
      NULL,
      2.691942,
      0,
      0,
      0.255429,
      1,
      0.743143,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.703868,
      0,
      0.188754,
      NULL,
      NULL,
      NULL,
      1.606691,
      0,
      NULL,
      11,
      2,
      1,
      10.382328,
      7,
      0.861926,
      0,
      3.726201,
      3,
      NULL,
      1.461973,
      53,
      1.654718,
      3,
      24,
      NULL,
      20.697537,
      41,
      5.581708,
      NULL,
      3,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.703204,
      NULL,
      '',
      '',
      0,
      6.685169,
      107,
      14,
      1,
      2.355429,
      3,
      NULL,
      3.236802,
      NULL,
      0,
      2,
      1.336703,
      NULL,
      NULL,
      0.526625,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.622628,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      1,
      1.876026,
      0.150921,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      2.898435,
      NULL,
      1.174680,
      0.182264,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.219457,
      1.985016,
      0.151937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884299,
      1,
      NULL,
      0.845683,
      1.802654,
      2,
      3.611159,
      3.047492,
      0,
      NULL,
      0,
      1,
      2,
      1.788243,
      3,
      1,
      0.672201,
      0.714113,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      0.082466,
      0.162943,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.874896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158224,
      NULL,
      NULL,
      1.412246,
      NULL,
      NULL,
      0.727865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.272786,
      NULL,
      1,
      3,
      NULL,
      1.642915,
      NULL,
      NULL,
      NULL,
      0.804769,
      NULL,
      NULL,
      NULL,
      0.009985,
      0.309358,
      0,
      NULL,
      NULL,
      0.009752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011657,
      0.733274,
      1.579122,
      3,
      0,
      0.683890,
      3,
      0.539678,
      0.752406,
      3.681416,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.187363,
      0.566219,
      3,
      1,
      0.767467,
      0.344679,
      1.581988,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.591049,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.609217,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.444769,
      NULL,
      NULL,
      1.501231,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.025007,
      0.865613,
      1.313927,
      1.163896,
      NULL,
      NULL,
      1.297693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.071035,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478592,
      NULL,
      NULL,
      0.239173,
      NULL,
      NULL,
      0.685678,
      NULL,
      0,
      NULL,
      25.209094,
      1.581586,
      0,
      1.552225,
      1,
      0.468893,
      NULL,
      NULL,
      1,
      1.887045,
      0.405892,
      1.305981,
      0,
      0,
      1,
      NULL,
      NULL,
      0.684534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286494,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.982111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.039266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490597,
      NULL,
      0,
      NULL,
      0.926573,
      0.537420,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      563.656877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118993,
      NULL,
      0,
      NULL,
      0.597629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.334524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.248543,
      NULL,
      1.492416,
      NULL,
      NULL,
      NULL,
      0.696568,
      NULL,
      0,
      NULL,
      1.916195,
      0,
      NULL,
      7.299553,
      23.806996,
      3.617145,
      NULL,
      3.511603,
      3,
      NULL,
      0,
      0,
      0.091326,
      0,
      2.897835,
      NULL,
      0,
      4,
      3,
      NULL,
      1,
      1.429447,
      NULL,
      NULL,
      0,
      3.595216,
      NULL,
      0.577140,
      1,
      NULL,
      0.630618,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.227815,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.848337,
      0.798250,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.281796,
      NULL,
      3.421140,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834086,
      NULL,
      NULL,
      NULL,
      1,
      9,
      3,
      0.185336,
      NULL,
      NULL,
      70.858683,
      15.987625,
      0,
      5.620828,
      NULL,
      '21431',
      NULL,
      '',
      NULL,
      '0441',
      '',
      '',
      NULL,
      '4142',
      '',
      NULL);
commit;
end;
/


