set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526069';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4041020',
      2,
      0.026661,
      NULL,
      3,
      '3000',
      0,
      1.583851,
      NULL,
      NULL,
      ' 3-28-1977',
      69.341547,
      NULL,
      3,
      3.239120,
      NULL,
      ' 2-27-1977',
      13,
      0.256246,
      NULL,
      147,
      2.513120,
      ' 5- 1-1992',
      '10-19-1979',
      ' 8- 7-1994',
      3.001036,
      1,
      3,
      1.792816,
      0,
      0,
      5.604263,
      1,
      1,
      17,
      7.021052,
      3.776693,
      9.331536,
      22.121895,
      NULL,
      9.342180,
      2,
      4.313465,
      0,
      NULL,
      0,
      3,
      1,
      NULL,
      1,
      0.348164,
      NULL,
      1,
      1.916135,
      1.449163,
      1.794146,
      NULL,
      5,
      3,
      3.570482,
      2,
      0,
      2,
      1,
      1.553459,
      NULL,
      5.383194,
      NULL,
      3,
      NULL,
      0.067138,
      0,
      4,
      0.918162,
      3.686235,
      1.511376,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      1,
      1,
      3.590857,
      2.931901,
      NULL,
      NULL,
      0,
      2.352684,
      3,
      NULL,
      0,
      0,
      1.245737,
      2,
      1,
      0,
      NULL,
      NULL,
      8.940498,
      0.056114,
      4.611897,
      0.145626,
      0.425860,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067362,
      0,
      NULL,
      4.547737,
      1.758992,
      1,
      NULL,
      0,
      1.842027,
      0,
      1.939685,
      2.563732,
      1,
      NULL,
      0,
      1,
      0.502479,
      NULL,
      0.343182,
      0,
      1.713395,
      1.936337,
      0,
      NULL,
      NULL,
      2.918877,
      1.015418,
      0,
      1,
      0,
      0.367900,
      3.606887,
      0.160205,
      1,
      5.767311,
      4.574420,
      NULL,
      4.280105,
      NULL,
      1,
      9,
      11,
      1.444363,
      0.433762,
      4,
      0.787345,
      ' 6- 1-1999',
      730,
      ' 6- 9-1990',
      777,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.387449,
      1.609148,
      0.201911,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      14,
      1.524480,
      1,
      1.572071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.502844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696434,
      NULL,
      7.340389,
      1.303926,
      9,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.697542,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.009479,
      0.724474,
      0.401575,
      NULL,
      1,
      1,
      NULL,
      7,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.078318,
      1.559684,
      1.999940,
      0,
      3.226207,
      3.545244,
      3.448557,
      2,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      1.549050,
      0.854823,
      1,
      2.126625,
      NULL,
      0.207694,
      NULL,
      2.733582,
      1.794437,
      0,
      0,
      1,
      0.104975,
      1.519792,
      4,
      0,
      6.227016,
      2.016616,
      4.014340,
      3.370129,
      8.109074,
      0.519763,
      0.374328,
      2.219299,
      NULL,
      0.467516,
      1.465467,
      2,
      15.456626,
      1.493346,
      NULL,
      NULL,
      7,
      NULL,
      53,
      0,
      1,
      3.357888,
      '34401',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      54.091662,
      79,
      47,
      NULL,
      64.627446,
      1,
      103.245789,
      4,
      3,
      3.508852,
      1,
      0.801385,
      NULL,
      NULL,
      0.970518,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.148686,
      3.415516,
      0.492737,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.381766,
      1.859869,
      NULL,
      NULL,
      1.438478,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.978184,
      NULL,
      2.180379,
      1.795820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491714,
      0,
      1,
      1.324405,
      1,
      1,
      NULL,
      0.947010,
      1,
      3.320065,
      0,
      0.649952,
      0,
      0,
      0.868521,
      3.556028,
      1.937148,
      2,
      3.054024,
      1,
      2,
      0.504163,
      2.221357,
      2.090333,
      3.219722,
      1,
      NULL,
      NULL,
      3.077432,
      1,
      1.496132,
      1.636759,
      1,
      0,
      NULL,
      1.552775,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.336483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      1.539892,
      1,
      NULL,
      NULL,
      11.641538,
      11.068366,
      NULL,
      0.985781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373368,
      NULL,
      NULL,
      0.392057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.865050,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.130463,
      NULL,
      NULL,
      0.237606,
      NULL,
      NULL,
      0.630986,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.046986,
      NULL,
      NULL,
      2.559308,
      1.749246,
      3.732713,
      2,
      0.539364,
      3,
      6,
      5.586787,
      3,
      3.378128,
      NULL,
      0.940361,
      0.992391,
      3,
      1,
      1,
      1.516663,
      NULL,
      1,
      0,
      2.699318,
      4,
      6.140428,
      1.662598,
      5.838575,
      1,
      0,
      3.003395,
      NULL,
      NULL,
      0.090825,
      1,
      1.311864,
      1.764704,
      NULL,
      3,
      NULL,
      NULL,
      0.683314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762528,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.887910,
      NULL,
      NULL,
      1.747068,
      NULL,
      NULL,
      0.979671,
      NULL,
      NULL,
      1.731784,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.677121,
      NULL,
      NULL,
      1.784457,
      0.867096,
      1.490890,
      1.263390,
      1.988654,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360926,
      NULL,
      NULL,
      NULL,
      1.901895,
      NULL,
      NULL,
      NULL,
      1.475855,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.182507,
      NULL,
      NULL,
      NULL,
      1,
      21,
      12,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.876667,
      NULL,
      NULL,
      0,
      NULL,
      1.453557,
      174.804153,
      52.149331,
      0.740090,
      1,
      0,
      NULL,
      0,
      0.246448,
      0.287943,
      0,
      1.624681,
      0,
      0,
      1,
      1,
      1,
      0.825585,
      0.251257,
      1.927694,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324777,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.076015,
      NULL,
      0.071908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826270,
      1.927259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526145,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862251,
      1.880170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.757020,
      0.491333,
      0,
      1.851439,
      2,
      0,
      5.932309,
      3.697710,
      1,
      NULL,
      0.224204,
      0,
      NULL,
      0,
      0.261843,
      NULL,
      0.070628,
      1.810874,
      NULL,
      1,
      1.020806,
      NULL,
      1.169601,
      1.352948,
      NULL,
      0.084986,
      1.644604,
      NULL,
      1.530927,
      1,
      NULL,
      1.238756,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.532655,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      5,
      1,
      0,
      2,
      NULL,
      54,
      NULL,
      0,
      2,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


