set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3222040',
      3,
      1.750890,
      0,
      NULL,
      '0400',
      NULL,
      1.481205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.397923,
      1,
      ' 4- 6-1980',
      10.941055,
      1.507062,
      283,
      NULL,
      1.859564,
      ' 7-15-1987',
      ' 3- 2-1988',
      ' 5-29-1991',
      1.614072,
      2,
      2,
      2,
      NULL,
      3.277507,
      2,
      0,
      1,
      83,
      4,
      9,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      4.291867,
      NULL,
      1.015595,
      NULL,
      5.756250,
      0,
      0.071020,
      1.630875,
      1.127683,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.679649,
      NULL,
      0,
      1,
      7.035271,
      4,
      7.427940,
      NULL,
      0,
      7,
      1.587225,
      0.425917,
      6,
      0.274226,
      NULL,
      1.801113,
      NULL,
      NULL,
      0,
      0.673776,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.566166,
      5.292729,
      NULL,
      3,
      3.186856,
      NULL,
      NULL,
      1,
      3,
      1,
      0.051549,
      1.700618,
      1,
      3,
      1,
      2,
      NULL,
      3.755580,
      2,
      8.591500,
      1,
      0,
      4,
      0.982908,
      2,
      0.328363,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.274322,
      NULL,
      9,
      2.491989,
      0,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.391149,
      0.985774,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.723546,
      0.132537,
      3.080249,
      1,
      8.338604,
      NULL,
      4.633014,
      0,
      7,
      8,
      NULL,
      5,
      7.956984,
      1.690026,
      10,
      6.961521,
      10,
      7,
      NULL,
      2,
      NULL,
      9,
      1.351226,
      5,
      7.487835,
      2,
      ' 4-26-1980',
      518.662915,
      NULL,
      NULL,
      0.632442,
      2,
      NULL,
      5,
      0.889384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.223091,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.250122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.372534,
      0,
      1,
      NULL,
      7,
      1.378632,
      NULL,
      NULL,
      NULL,
      0,
      1.473690,
      0.677537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.824095,
      3.258879,
      0.453720,
      0,
      0.528548,
      NULL,
      0.948534,
      2,
      120.078527,
      0.057885,
      NULL,
      28.678429,
      NULL,
      122,
      4.343687,
      0,
      0.242721,
      1.846737,
      2,
      4,
      2,
      NULL,
      3.030405,
      3.853642,
      0.597519,
      NULL,
      0,
      1.491895,
      0.566004,
      NULL,
      2.364089,
      1.079418,
      1,
      0,
      NULL,
      NULL,
      183.842007,
      163,
      120,
      1,
      NULL,
      NULL,
      4.561672,
      0,
      0.772820,
      1.356204,
      NULL,
      1,
      3.965101,
      NULL,
      1,
      5.019283,
      5,
      NULL,
      7,
      0,
      3.159277,
      2,
      55,
      3,
      0,
      NULL,
      7,
      NULL,
      30.048905,
      1.157282,
      NULL,
      0.917362,
      '02434',
      '13111',
      '',
      0,
      '',
      '',
      '',
      1.581148,
      NULL,
      '',
      '',
      0,
      37,
      60.649414,
      35,
      1.053531,
      27.251936,
      NULL,
      10.240910,
      4.181852,
      1.999362,
      0.678467,
      1,
      1.078459,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.048462,
      NULL,
      NULL,
      3,
      1,
      2,
      3,
      3,
      2,
      0.628650,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.448889,
      NULL,
      0,
      NULL,
      NULL,
      1.853545,
      0,
      NULL,
      NULL,
      1.789656,
      NULL,
      4,
      0,
      1.162632,
      NULL,
      NULL,
      NULL,
      2,
      0.253041,
      1,
      1,
      3,
      2,
      2.685074,
      0,
      1,
      1.284195,
      1,
      0.144361,
      1.159691,
      0.076991,
      NULL,
      NULL,
      0.066767,
      1.643994,
      2.347145,
      1,
      2,
      0,
      1,
      3.076334,
      2,
      0.751780,
      NULL,
      0,
      2.083809,
      0.657527,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      2.892670,
      1,
      1.314214,
      NULL,
      NULL,
      NULL,
      1.984120,
      NULL,
      1.631872,
      3,
      1.184019,
      NULL,
      NULL,
      NULL,
      2.802506,
      0,
      1.823403,
      NULL,
      0.440612,
      1.295993,
      NULL,
      NULL,
      5.083563,
      3.042391,
      0.226835,
      0.654885,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      NULL,
      NULL,
      0,
      1.568297,
      NULL,
      NULL,
      1.372904,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.897371,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      1.393769,
      NULL,
      NULL,
      1,
      0.051309,
      8,
      5.114750,
      0.604076,
      8.123580,
      0.212964,
      9.218068,
      NULL,
      8,
      1.161274,
      1.160934,
      2,
      0,
      1.455473,
      NULL,
      2.653478,
      NULL,
      1.673046,
      0,
      4.961323,
      NULL,
      7.881750,
      2.007425,
      3,
      0.762451,
      0.505365,
      2,
      NULL,
      1,
      2,
      0.185406,
      3.199011,
      1,
      1.448668,
      1,
      NULL,
      3.882400,
      8,
      1,
      NULL,
      3.682838,
      NULL,
      6.866896,
      1,
      1.664802,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257012,
      3.525534,
      3.571354,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.935720,
      2,
      NULL,
      NULL,
      0.784498,
      1.116107,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.841095,
      1,
      NULL,
      NULL,
      2.046670,
      0.613517,
      NULL,
      NULL,
      0.427125,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.278098,
      NULL,
      NULL,
      NULL,
      0.369551,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.548722,
      NULL,
      NULL,
      NULL,
      1.321243,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.832552,
      NULL,
      NULL,
      NULL,
      2.011718,
      3,
      NULL,
      NULL,
      3,
      2.716152,
      3.206336,
      2.734537,
      1.546475,
      0,
      31,
      54.345679,
      3,
      4.578173,
      3,
      0.356968,
      NULL,
      NULL,
      3,
      0.706642,
      4.628992,
      1,
      NULL,
      NULL,
      1.755985,
      NULL,
      NULL,
      0.592880,
      NULL,
      1,
      288.264492,
      25,
      1,
      3.594614,
      NULL,
      0,
      0.674959,
      1.910509,
      1.884812,
      0,
      0.093558,
      0.385933,
      NULL,
      1.630552,
      0,
      2.195664,
      NULL,
      1.450830,
      NULL,
      0.244423,
      NULL,
      0.544970,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      34.201116,
      15,
      NULL,
      3.998756,
      3.712301,
      NULL,
      0.321783,
      NULL,
      1,
      NULL,
      0.166447,
      NULL,
      1.674596,
      NULL,
      0.517581,
      NULL,
      2.927924,
      NULL,
      3,
      NULL,
      0.172747,
      NULL,
      1.181808,
      NULL,
      0,
      NULL,
      0.300618,
      NULL,
      1.924758,
      NULL,
      0.488817,
      NULL,
      NULL,
      NULL,
      NULL,
      3.189583,
      NULL,
      NULL,
      NULL,
      0.625190,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.491020,
      NULL,
      0.358195,
      NULL,
      NULL,
      0.385693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607819,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.520944,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.814473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906845,
      3,
      NULL,
      1.968746,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607895,
      0,
      NULL,
      2.654681,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.423152,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      3,
      1,
      3,
      5,
      NULL,
      3,
      0.401790,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.256785,
      NULL,
      1,
      1,
      NULL,
      2.403599,
      1,
      NULL,
      0.856041,
      1,
      NULL,
      0.761773,
      3.667148,
      NULL,
      NULL,
      0.430054,
      NULL,
      1.867336,
      1.344102,
      NULL,
      1,
      1.056273,
      NULL,
      0,
      0.613310,
      NULL,
      3.083305,
      0.966437,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225679,
      NULL,
      1,
      NULL,
      1.409440,
      NULL,
      3,
      2.126120,
      9.741129,
      NULL,
      NULL,
      NULL,
      43,
      20.084848,
      3.274258,
      1,
      4,
      NULL,
      '34310',
      '34404',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


