set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2,
      NULL,
      NULL,
      1,
      3,
      2,
      2,
      '240',
      '14221000',
      70.657927,
      23.131822,
      '2222321',
      1.095840,
      1,
      1,
      1,
      '4301',
      3.317508,
      1,
      NULL,
      NULL,
      ' 5-14-1979',
      NULL,
      49.414681,
      NULL,
      NULL,
      2.989057,
      ' 2- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1993',
      NULL,
      1,
      2,
      2.220582,
      1.574177,
      NULL,
      NULL,
      NULL,
      1.729430,
      NULL,
      8,
      18.127886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.679861,
      1.132462,
      NULL,
      3.295561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.339069,
      7.757143,
      0.844659,
      0,
      3.829763,
      4.171394,
      NULL,
      2,
      4,
      0.467021,
      NULL,
      0,
      0.081163,
      6,
      0.825642,
      3.344909,
      NULL,
      1.496624,
      1,
      NULL,
      NULL,
      1.631942,
      NULL,
      NULL,
      2,
      1,
      3.505335,
      0.707690,
      1.383291,
      1.295901,
      0.251650,
      2.215043,
      0,
      3.206170,
      1,
      NULL,
      0,
      0.158722,
      1,
      2.110253,
      1,
      NULL,
      NULL,
      NULL,
      0.752149,
      1,
      0.535310,
      NULL,
      0.995739,
      2.796776,
      1.084417,
      NULL,
      NULL,
      0.473771,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.938302,
      1.768106,
      0.402568,
      NULL,
      1,
      2.330656,
      NULL,
      1,
      5.723489,
      NULL,
      0,
      0,
      0.063303,
      0,
      NULL,
      NULL,
      1,
      0,
      1.596613,
      0,
      3.317028,
      2.110883,
      4,
      0.832067,
      0,
      1.474439,
      0.044159,
      1.089269,
      5.110019,
      NULL,
      0.160558,
      NULL,
      3.924145,
      7.584917,
      NULL,
      8,
      0,
      5.812722,
      7.228712,
      NULL,
      1.065277,
      0,
      2.012146,
      '11- 3-1989',
      239.706783,
      ' 6-19-1989',
      520.549652,
      2.459637,
      0.489033,
      NULL,
      3.214733,
      1.515740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.187846,
      3,
      NULL,
      0,
      NULL,
      1.313295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.018176,
      0.523508,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.181534,
      1.120478,
      2.668367,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687416,
      2,
      2.402772,
      1.547705,
      0.975031,
      2.824994,
      1.571429,
      0,
      NULL,
      2.221771,
      0,
      NULL,
      2,
      1,
      1,
      1.431047,
      0,
      3.715415,
      1.738093,
      NULL,
      0.208260,
      1,
      0.606555,
      1,
      0.986689,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.793321,
      1,
      6.977798,
      NULL,
      7,
      5.947040,
      0,
      7.159360,
      0,
      2,
      0,
      9.433709,
      3.511612,
      0.330687,
      22,
      NULL,
      NULL,
      NULL,
      1.769058,
      NULL,
      0.268547,
      '22400',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.654118,
      NULL,
      11.935113,
      NULL,
      2.583125,
      24,
      2.511405,
      7.615378,
      NULL,
      3,
      NULL,
      0.533753,
      0.491051,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      3.010792,
      1.834789,
      1.434843,
      0.250000,
      NULL,
      NULL,
      3.362047,
      0.368941,
      0.874849,
      1.661474,
      0,
      NULL,
      0,
      1.025544,
      1,
      1.367382,
      NULL,
      NULL,
      3.657722,
      0.019570,
      1.841400,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666944,
      NULL,
      NULL,
      NULL,
      3,
      0.562941,
      3,
      0.761346,
      1.107868,
      0,
      3,
      1.896372,
      NULL,
      2,
      0.070929,
      0.596228,
      1.234845,
      3,
      NULL,
      2.817467,
      3,
      1,
      NULL,
      1.292254,
      1.681748,
      0,
      1,
      0,
      1.935430,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.418105,
      0.883274,
      4,
      1.064380,
      1.814855,
      NULL,
      NULL,
      NULL,
      0.162658,
      NULL,
      NULL,
      NULL,
      1.727308,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.495110,
      0.869194,
      NULL,
      NULL,
      0,
      0,
      4.286945,
      2.098986,
      1.511087,
      2.887564,
      0.523023,
      1,
      2.670423,
      3,
      0,
      7,
      1.380385,
      NULL,
      NULL,
      1.376733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.378945,
      1,
      1,
      2.653790,
      NULL,
      1,
      1.329682,
      1.174697,
      NULL,
      NULL,
      0.847527,
      NULL,
      NULL,
      1.672295,
      1,
      NULL,
      2.678814,
      NULL,
      3,
      2.176718,
      0.907614,
      0.254350,
      3,
      NULL,
      3,
      2.009272,
      0,
      3.977484,
      3.901107,
      0,
      1,
      3.354953,
      NULL,
      NULL,
      8,
      2,
      4,
      NULL,
      1.031984,
      1.740071,
      2.439973,
      0.465132,
      6,
      0,
      0.478766,
      0.984244,
      0.064991,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      15.020793,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.863035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.483314,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1.716125,
      1,
      0,
      1,
      0.779519,
      3.485118,
      1.579182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.985035,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176945,
      NULL,
      NULL,
      NULL,
      1.701884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997489,
      NULL,
      NULL,
      NULL,
      3.370462,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206299,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.742990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.131676,
      78.964288,
      50.444927,
      NULL,
      20.280499,
      NULL,
      0.347192,
      NULL,
      NULL,
      1.683687,
      10.912898,
      NULL,
      NULL,
      10,
      4.968450,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.115825,
      60.401312,
      0.002372,
      1,
      0.279604,
      0,
      NULL,
      0.456808,
      1.811074,
      0.010767,
      NULL,
      0.729880,
      0.107802,
      NULL,
      1,
      0.622936,
      NULL,
      0,
      NULL,
      1.380672,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.816027,
      0.201642,
      1,
      3,
      0,
      NULL,
      2,
      5,
      NULL,
      0,
      1,
      0.185065,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.899892,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.250492,
      NULL,
      NULL,
      0.685556,
      NULL,
      0,
      0.039274,
      NULL,
      1,
      1.670398,
      NULL,
      1.008924,
      1.622720,
      NULL,
      1,
      1.007042,
      NULL,
      NULL,
      0.499715,
      NULL,
      2,
      NULL,
      0.762465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      5,
      0,
      NULL,
      NULL,
      56,
      13.997895,
      NULL,
      0.370900,
      0.111715,
      '01011',
      '',
      '',
      1.702285,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


