set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9708246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.574560,
      NULL,
      1,
      '212',
      NULL,
      39.109171,
      18,
      '4020412',
      1,
      1.409700,
      0,
      1,
      '3420',
      3,
      NULL,
      NULL,
      NULL,
      '10-14-1989',
      231,
      184,
      NULL,
      3,
      2,
      ' 2-12-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      3.866780,
      ' 4- 1-2000',
      '10-12-1993',
      '11- 6-2001',
      2.566695,
      3,
      NULL,
      2.215273,
      0,
      2.411048,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.632977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857675,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.844240,
      NULL,
      0,
      NULL,
      1.880011,
      1.355502,
      0.071393,
      1.268877,
      5.209188,
      6.888365,
      0,
      3.697844,
      0.175299,
      0.032982,
      0.447455,
      0,
      0.452377,
      1,
      1.028993,
      NULL,
      1,
      NULL,
      NULL,
      3.945353,
      NULL,
      NULL,
      1.591999,
      1.218492,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.467285,
      2,
      0.304092,
      3.407060,
      0,
      0.286131,
      3.151120,
      NULL,
      0.117606,
      2,
      2,
      0.934062,
      2,
      2,
      NULL,
      3,
      0,
      0.732615,
      NULL,
      6.086634,
      NULL,
      0.132245,
      4,
      0,
      0,
      1.785514,
      1.374912,
      NULL,
      NULL,
      1.098145,
      NULL,
      NULL,
      0,
      0.915282,
      1.114141,
      1,
      5.344277,
      1,
      NULL,
      1.206491,
      0,
      0.140351,
      0.593553,
      NULL,
      0,
      0.981019,
      NULL,
      0.812910,
      1,
      NULL,
      0.830554,
      NULL,
      1.011742,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.189654,
      2,
      1.644317,
      1,
      0,
      NULL,
      0.466389,
      4.022503,
      0,
      NULL,
      6,
      1.588349,
      9,
      2,
      NULL,
      NULL,
      4.240522,
      3.693101,
      NULL,
      0.471558,
      0.382245,
      3,
      NULL,
      1251,
      ' 1-17-1999',
      442.363141,
      0,
      3.075835,
      NULL,
      2,
      0.998704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.757018,
      0,
      NULL,
      1.576490,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      1.922524,
      1,
      NULL,
      0,
      3,
      1.707535,
      0.340474,
      1.297207,
      3,
      1.705925,
      1.391979,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      0.265984,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.625600,
      0.630989,
      NULL,
      0,
      NULL,
      2,
      1.394898,
      35,
      3.178845,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688078,
      1.783094,
      0.179630,
      0,
      0,
      NULL,
      3.466289,
      3.777779,
      5.103220,
      0.419778,
      5.278945,
      NULL,
      0.362566,
      6.401597,
      5.323299,
      0,
      NULL,
      2.327009,
      0.529903,
      NULL,
      0,
      1,
      1.472005,
      0,
      1,
      1.806946,
      NULL,
      NULL,
      1.297295,
      2,
      4.294717,
      0,
      1,
      0,
      7,
      0.799192,
      6.257040,
      7,
      2.515964,
      3,
      3,
      3,
      1.534468,
      0,
      28.259142,
      1.897840,
      2,
      43.458839,
      NULL,
      13,
      12,
      5,
      NULL,
      3,
      '14013',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      2.147429,
      '40044',
      '',
      '',
      2.431457,
      15.953221,
      NULL,
      41.130650,
      3.996185,
      6,
      0,
      10,
      5,
      2,
      1,
      NULL,
      0.759102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.335891,
      NULL,
      NULL,
      NULL,
      0.985307,
      2.157433,
      1,
      NULL,
      NULL,
      0.450975,
      0,
      0,
      0,
      NULL,
      NULL,
      0.152653,
      NULL,
      NULL,
      0.764578,
      NULL,
      NULL,
      11.291735,
      4,
      2,
      3.214879,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.304543,
      3,
      3,
      NULL,
      1.625062,
      0,
      1,
      1,
      NULL,
      0,
      1.548706,
      0,
      0,
      1.153195,
      NULL,
      2.602611,
      1,
      NULL,
      0.674208,
      NULL,
      NULL,
      1.068660,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.224740,
      2,
      0.678287,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527602,
      1,
      NULL,
      3.792373,
      0.746944,
      NULL,
      NULL,
      3,
      2.278831,
      NULL,
      2.013674,
      0.717354,
      1,
      1.879049,
      NULL,
      NULL,
      5,
      5.312487,
      4.260908,
      2,
      NULL,
      1,
      0.357821,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.490727,
      NULL,
      NULL,
      1.064592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.295454,
      NULL,
      1.270159,
      NULL,
      NULL,
      2,
      0.315065,
      0.246757,
      NULL,
      1,
      2.259636,
      2.198316,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      0,
      0,
      3.072789,
      3,
      3,
      1.307098,
      0,
      0,
      1.827231,
      NULL,
      1.980620,
      7.006797,
      2.530722,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.480011,
      0,
      1,
      NULL,
      0.369378,
      1,
      3,
      NULL,
      NULL,
      1.350857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.860912,
      NULL,
      NULL,
      3.727615,
      NULL,
      NULL,
      0.226237,
      NULL,
      NULL,
      1.729162,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089692,
      0.080379,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      6.355487,
      0,
      NULL,
      NULL,
      NULL,
      3.411129,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.363735,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.674502,
      NULL,
      NULL,
      NULL,
      1.138167,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.420901,
      NULL,
      NULL,
      NULL,
      1.514104,
      NULL,
      NULL,
      0,
      0.378741,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.753937,
      2,
      NULL,
      NULL,
      2.076570,
      1,
      NULL,
      NULL,
      NULL,
      0.499068,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.373557,
      NULL,
      NULL,
      NULL,
      1,
      2.497295,
      0,
      1,
      4.987268,
      2,
      64.543212,
      13,
      3.725965,
      29,
      NULL,
      0.354575,
      NULL,
      NULL,
      2,
      60.413463,
      0,
      1,
      NULL,
      NULL,
      1.491437,
      NULL,
      NULL,
      1,
      4,
      1.540238,
      NULL,
      2.852070,
      1,
      2.586843,
      NULL,
      2.195767,
      0,
      NULL,
      1.222721,
      1.238125,
      NULL,
      0.893466,
      1.254367,
      1.216659,
      0.885491,
      2.364200,
      0.010552,
      NULL,
      1.695065,
      1.738503,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.080632,
      NULL,
      113,
      NULL,
      2,
      NULL,
      20.091679,
      1,
      0,
      4,
      NULL,
      3.354739,
      NULL,
      1.352105,
      NULL,
      1.273521,
      NULL,
      3.862202,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.587669,
      NULL,
      1,
      NULL,
      1.581597,
      NULL,
      1,
      NULL,
      1.466013,
      NULL,
      1,
      NULL,
      3,
      1.988173,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.314093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.232309,
      NULL,
      0.345341,
      NULL,
      3.284423,
      NULL,
      NULL,
      NULL,
      2.630109,
      NULL,
      1.471635,
      NULL,
      0,
      NULL,
      2.800987,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.748349,
      NULL,
      1.383990,
      NULL,
      0,
      NULL,
      29.489972,
      NULL,
      3.992199,
      NULL,
      1,
      NULL,
      0.990272,
      1.153445,
      2.133069,
      27.661011,
      26.388280,
      NULL,
      NULL,
      3.137268,
      2.621925,
      NULL,
      0,
      NULL,
      1.443119,
      0,
      3.340861,
      3,
      1,
      0,
      NULL,
      1.941880,
      NULL,
      1,
      0,
      NULL,
      1.853255,
      NULL,
      2,
      0.001556,
      3.384570,
      1.121375,
      0.081291,
      3,
      0,
      1,
      2.213413,
      1,
      0,
      0.465280,
      0.375105,
      1,
      3,
      0.818484,
      0.756246,
      NULL,
      3.720245,
      1,
      0,
      0.679505,
      0.806057,
      1,
      0.450220,
      NULL,
      NULL,
      0,
      3.869390,
      3.460186,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.145635,
      1,
      2,
      0.799729,
      0,
      1.001355,
      1,
      1,
      3,
      NULL,
      0.332307,
      0,
      NULL,
      3.408418,
      1.731923,
      0.260187,
      NULL,
      1,
      0.699636,
      NULL,
      1.199051,
      0.152979,
      0.825310,
      NULL,
      NULL,
      NULL,
      0,
      10,
      2.379514,
      NULL,
      0.610631,
      NULL,
      3,
      2,
      0,
      1,
      3,
      9.489773,
      4.792215,
      0,
      NULL,
      NULL,
      13.671712,
      27,
      3,
      2,
      NULL,
      NULL,
      '11314',
      '',
      0.451173,
      '',
      '',
      '',
      NULL,
      '13413',
      '',
      '');
commit;
end;
/


