set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      1.977113,
      NULL,
      NULL,
      0,
      5.314042,
      1.389839,
      '110',
      NULL,
      72,
      NULL,
      NULL,
      2,
      1.204905,
      5,
      NULL,
      '1030',
      NULL,
      0.157011,
      NULL,
      NULL,
      ' 4- 5-1996',
      24.857556,
      43.470789,
      NULL,
      0.781992,
      3.889850,
      ' 6-20-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      0.305405,
      NULL,
      NULL,
      ' 9- 9-1992',
      2.013319,
      0,
      NULL,
      0.842229,
      1,
      0,
      1.066924,
      NULL,
      0.134163,
      49,
      10,
      13.887298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.681776,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.849920,
      1.455190,
      1.399321,
      5.980611,
      0,
      0.199387,
      2.261392,
      NULL,
      5.459028,
      NULL,
      NULL,
      0.086390,
      NULL,
      NULL,
      5,
      1.308662,
      2,
      0.272827,
      NULL,
      NULL,
      0.655856,
      NULL,
      NULL,
      6.070628,
      1.434489,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      2.548137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.155645,
      3.339614,
      NULL,
      1,
      NULL,
      0.958866,
      0,
      1,
      1,
      1,
      1,
      0,
      1.040993,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.723133,
      6.261189,
      1,
      NULL,
      3,
      NULL,
      5.459499,
      6,
      4,
      4.539539,
      4,
      2.926481,
      1.607392,
      1,
      1,
      NULL,
      NULL,
      4,
      4.624889,
      NULL,
      2,
      7.891887,
      NULL,
      3,
      3,
      2,
      5,
      1,
      ' 6-19-1982',
      251,
      NULL,
      337.399588,
      0.193603,
      0.754212,
      1,
      2.485033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850937,
      0,
      1.614803,
      0,
      1,
      0.252191,
      3.218109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.327411,
      1,
      1.280777,
      NULL,
      NULL,
      NULL,
      5.822309,
      1.078848,
      4.111737,
      2,
      1.807636,
      1,
      1.326823,
      NULL,
      NULL,
      NULL,
      1.786829,
      NULL,
      0.062293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.785435,
      NULL,
      1.965648,
      1,
      0.896724,
      NULL,
      15,
      2,
      0.167212,
      NULL,
      NULL,
      NULL,
      1.001692,
      1,
      3,
      0,
      0.201824,
      0,
      1.087130,
      3,
      NULL,
      0,
      2,
      1.830549,
      1,
      2.066638,
      3,
      1.991683,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.779354,
      1,
      1.838262,
      1,
      0,
      NULL,
      1,
      2.715004,
      3.493267,
      NULL,
      NULL,
      NULL,
      2,
      8,
      4,
      2.868983,
      5.744375,
      2.243748,
      NULL,
      NULL,
      NULL,
      2,
      43,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687978,
      0,
      1,
      NULL,
      '',
      '',
      1.262598,
      '',
      '',
      '',
      0.831297,
      '',
      NULL,
      '',
      0.832779,
      NULL,
      45.695836,
      NULL,
      3.649769,
      36,
      5,
      0,
      1,
      NULL,
      NULL,
      3.052029,
      1.602342,
      NULL,
      NULL,
      1.566186,
      NULL,
      NULL,
      0,
      NULL,
      2.589151,
      0,
      NULL,
      NULL,
      0.333995,
      NULL,
      NULL,
      NULL,
      1.256067,
      1.673826,
      1.116583,
      NULL,
      NULL,
      1.768794,
      2.944858,
      3.854456,
      1,
      NULL,
      NULL,
      0.974946,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.647420,
      2.388127,
      0.417994,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.949364,
      0.556165,
      NULL,
      1.373535,
      NULL,
      NULL,
      1.174794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646552,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3.612661,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.884977,
      NULL,
      NULL,
      NULL,
      0.824505,
      0.181039,
      1.267507,
      1.296908,
      NULL,
      NULL,
      1.392203,
      1.987066,
      1.123002,
      1.196150,
      NULL,
      NULL,
      5,
      4,
      3,
      1.950375,
      3,
      0,
      1.489082,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1,
      NULL,
      NULL,
      0.592809,
      NULL,
      NULL,
      3,
      2,
      1.694525,
      0,
      NULL,
      NULL,
      2.610406,
      1.728900,
      1,
      4,
      NULL,
      0,
      2.331640,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9.780639,
      0,
      2.341762,
      5,
      5,
      6.238360,
      2.259236,
      0.122960,
      2.982087,
      2,
      2,
      0.166460,
      0.406048,
      2.309999,
      2.030988,
      2,
      3,
      9,
      7,
      0.645702,
      NULL,
      0.535317,
      1.763409,
      2,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1,
      0,
      1.813487,
      3,
      2.462097,
      4.732140,
      NULL,
      NULL,
      4.415920,
      3.784175,
      3.759218,
      NULL,
      1.167503,
      1.684147,
      0.575745,
      NULL,
      NULL,
      2.237497,
      NULL,
      NULL,
      1.260760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.160120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.438807,
      NULL,
      NULL,
      0.691338,
      0.410767,
      NULL,
      1.951000,
      0.542859,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.726971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.529333,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.089064,
      NULL,
      NULL,
      NULL,
      1.258691,
      NULL,
      NULL,
      NULL,
      1.046695,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.159769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.819255,
      1.208625,
      1.379689,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.503638,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401631,
      0,
      0,
      1,
      NULL,
      3,
      1.440370,
      0.162258,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.773244,
      1.761749,
      0,
      0.883480,
      0.649099,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.978680,
      NULL,
      NULL,
      10,
      NULL,
      2,
      0.011765,
      NULL,
      NULL,
      2,
      NULL,
      0.713583,
      NULL,
      1,
      NULL,
      1.844851,
      NULL,
      NULL,
      NULL,
      3.869907,
      NULL,
      NULL,
      NULL,
      0.451801,
      NULL,
      0.264338,
      NULL,
      1.691084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160685,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.294642,
      NULL,
      NULL,
      NULL,
      0.071789,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.450857,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.229072,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.264039,
      NULL,
      NULL,
      NULL,
      0.301580,
      NULL,
      1.048633,
      1,
      0.609311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277820,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.680214,
      NULL,
      75,
      NULL,
      1.034409,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      27,
      20,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.319367,
      2.545719,
      2.830856,
      0,
      0,
      1,
      3.128507,
      3,
      NULL,
      2,
      0.853018,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.320600,
      NULL,
      0,
      1,
      NULL,
      3.745208,
      2.946023,
      NULL,
      0,
      NULL,
      NULL,
      1.281279,
      NULL,
      NULL,
      1.411983,
      0,
      NULL,
      1,
      2,
      NULL,
      1.093689,
      0.041325,
      NULL,
      1.534094,
      NULL,
      NULL,
      1,
      NULL,
      0.430404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      6.303412,
      4.642782,
      0,
      5,
      '10101',
      NULL,
      '03230',
      1.967027,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


