set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7220278';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      0.498498,
      0.646118,
      NULL,
      1,
      '4232',
      0.216371,
      NULL,
      NULL,
      NULL,
      ' 8-17-1989',
      9,
      NULL,
      9.448296,
      1.406907,
      9.058448,
      ' 3-13-1982',
      NULL,
      NULL,
      NULL,
      12.601036,
      1,
      ' 2-12-2002',
      ' 3-11-2001',
      ' 6-13-1994',
      2,
      3,
      1.283016,
      1.213563,
      0.368251,
      1.949955,
      5.349634,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4,
      17,
      148.434561,
      4,
      9,
      0.769622,
      0.338292,
      7,
      0,
      0.931237,
      1.939912,
      NULL,
      5,
      0.052293,
      0,
      0.741177,
      0.714117,
      NULL,
      1.560487,
      0.710461,
      NULL,
      NULL,
      3.952065,
      3,
      NULL,
      NULL,
      5.329249,
      NULL,
      4,
      0,
      NULL,
      3,
      8,
      0.495802,
      NULL,
      1.591460,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      3.127723,
      9,
      11.477462,
      6,
      3.218393,
      0.233421,
      1.950792,
      2.695395,
      NULL,
      3.527831,
      3,
      3.582325,
      1.571260,
      2.507803,
      0.455402,
      0,
      NULL,
      0.015807,
      0,
      0,
      0.851608,
      0.340103,
      NULL,
      8.863495,
      2,
      4.893661,
      0,
      0,
      NULL,
      NULL,
      2.553215,
      1.241748,
      NULL,
      1,
      4.012549,
      NULL,
      5.625203,
      2.114285,
      2.807503,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      0,
      3,
      1.537330,
      1.382010,
      1,
      1.911846,
      0,
      1,
      3.968023,
      1.087969,
      1.741014,
      NULL,
      NULL,
      1,
      5,
      2,
      1,
      NULL,
      7,
      4.361719,
      2.931220,
      6,
      NULL,
      0,
      9.220364,
      9,
      5,
      8,
      1.678346,
      5.889876,
      2.316491,
      NULL,
      7.160917,
      2.303777,
      9.630892,
      3.967659,
      NULL,
      NULL,
      '10- 4-1991',
      9,
      1,
      2.638548,
      1.182464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826822,
      NULL,
      1,
      1.013169,
      1,
      5,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798208,
      NULL,
      NULL,
      3.907349,
      0,
      1,
      1,
      1.162747,
      0,
      0,
      0.054588,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5,
      2.705513,
      5.177796,
      5,
      2,
      7,
      7,
      1,
      NULL,
      NULL,
      1,
      9,
      3,
      1,
      3,
      1,
      0.050459,
      ' 0-25-1987',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.333644,
      3,
      1.402052,
      1.063136,
      0,
      1.712871,
      0.560339,
      1.411933,
      0.526610,
      17.143907,
      0.589825,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.274697,
      2.174820,
      3,
      NULL,
      NULL,
      2.796308,
      2,
      1.896059,
      1.405078,
      0.931628,
      NULL,
      0.381793,
      1.839710,
      NULL,
      1.320034,
      NULL,
      0,
      NULL,
      3.514428,
      1,
      1,
      5.953323,
      1.987067,
      1.339561,
      1.029359,
      0,
      NULL,
      3,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.935199,
      10.746507,
      5.898094,
      1,
      4.851807,
      NULL,
      '13433',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.366552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616107,
      0.380447,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986592,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058655,
      NULL,
      NULL,
      7476.508399,
      275,
      NULL,
      1,
      0,
      1,
      0.979382,
      0.716804,
      1,
      1.748700,
      0.923867,
      NULL,
      0.414291,
      NULL,
      NULL,
      0,
      0.320046,
      1.161958,
      1.831164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611252,
      1.780733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.006680,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.347991,
      NULL,
      1.041154,
      NULL,
      0,
      NULL,
      1,
      0,
      3.917155,
      NULL,
      3,
      NULL,
      0.705963,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.796648,
      NULL,
      NULL,
      0,
      0.625537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455237,
      2.912826,
      1.546929,
      NULL,
      0,
      1.001623,
      NULL,
      NULL,
      1.374630,
      NULL,
      1,
      2,
      NULL,
      3.855542,
      NULL,
      2,
      NULL,
      181,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      4.251578,
      0,
      NULL,
      NULL,
      NULL,
      0.981665,
      NULL,
      5,
      8,
      0.243778,
      5,
      NULL,
      3.563608,
      15,
      2,
      2.190103,
      1,
      0,
      NULL,
      NULL,
      1.134146,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.273927,
      NULL,
      NULL,
      3,
      2.366112,
      NULL,
      1,
      0.783410,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.986211,
      0.266121,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.635041,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.549536,
      NULL,
      0.643331,
      NULL,
      1,
      NULL,
      1.904996,
      NULL,
      0.574996,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      9.856474,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.182986,
      9.291645,
      2.756649,
      2.045759,
      1,
      14,
      NULL,
      NULL,
      1,
      2,
      '03024',
      '20443',
      '12140',
      2.753984,
      '43203',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


