set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005690';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2411020',
      2,
      0.414170,
      1,
      3,
      '4403',
      1.674276,
      1.627356,
      NULL,
      NULL,
      ' 5-22-1996',
      8.652706,
      NULL,
      NULL,
      1,
      0,
      '10-11-1999',
      NULL,
      4,
      169,
      60,
      0,
      NULL,
      NULL,
      '10-25-1993',
      0.795635,
      0.395792,
      1,
      3,
      0.341170,
      NULL,
      3.145052,
      1,
      1.058054,
      8,
      10,
      NULL,
      2,
      NULL,
      21.149189,
      5,
      NULL,
      NULL,
      5.403745,
      2,
      0.088951,
      1,
      1,
      0,
      NULL,
      0,
      1.269149,
      0.925418,
      0.224070,
      0,
      0,
      3,
      NULL,
      2.973931,
      1.049971,
      4,
      0,
      7,
      NULL,
      2.691683,
      NULL,
      4,
      2.491206,
      7,
      2.810036,
      9.491343,
      3.022376,
      6,
      1,
      NULL,
      5,
      2,
      1.966571,
      NULL,
      NULL,
      0.702253,
      NULL,
      NULL,
      NULL,
      2.678762,
      4.526535,
      2.999656,
      2,
      1.168607,
      1.020789,
      2.532850,
      NULL,
      0,
      1.841182,
      0,
      1,
      2,
      2.145977,
      1,
      1.094116,
      3.997539,
      NULL,
      11.900731,
      7.334951,
      0,
      9,
      0,
      NULL,
      0.951208,
      1.841667,
      NULL,
      NULL,
      0.508793,
      NULL,
      NULL,
      1,
      0.429382,
      1,
      1.192546,
      0,
      0,
      3,
      1,
      0,
      NULL,
      0,
      1,
      0,
      2.441968,
      0,
      2.344313,
      1,
      0,
      NULL,
      NULL,
      4,
      0,
      0.527368,
      NULL,
      3.276177,
      1.707185,
      11.229585,
      NULL,
      8,
      5,
      5,
      5,
      0.624498,
      1.674017,
      3.644675,
      5,
      5.996928,
      3.446049,
      6.903539,
      NULL,
      8,
      0,
      10.603712,
      11.446637,
      3.751943,
      1.691575,
      6,
      1,
      ' 0-11-1995',
      154.603295,
      ' 7-27-1994',
      1587,
      3.332990,
      1.804329,
      0,
      4.111682,
      0.205506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630353,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.624350,
      1.710624,
      1,
      0.264079,
      1.124604,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.445132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.884023,
      NULL,
      0.989790,
      1.156447,
      NULL,
      0,
      0.867672,
      2.468735,
      57.654608,
      0.113661,
      1.247777,
      NULL,
      NULL,
      NULL,
      5.905418,
      0.000814,
      0.111576,
      NULL,
      5.333419,
      1,
      3,
      3,
      NULL,
      3,
      4.652025,
      4,
      0,
      3,
      2,
      1.595793,
      3.461105,
      1,
      NULL,
      5.115652,
      1.754811,
      NULL,
      1.756073,
      1.922117,
      1.810043,
      1.274571,
      1.215269,
      1.660583,
      NULL,
      0,
      3,
      NULL,
      10,
      8.982479,
      1.267832,
      NULL,
      9,
      3,
      1.133470,
      0,
      2.164308,
      1,
      0,
      1,
      52.560047,
      1.860949,
      2,
      NULL,
      9,
      NULL,
      2,
      1,
      1,
      4.053287,
      '40211',
      '30102',
      '',
      0.446926,
      NULL,
      NULL,
      '',
      0.860799,
      '',
      '',
      '',
      3.820364,
      1.725859,
      19,
      33,
      NULL,
      10,
      4.582966,
      3.414282,
      4.577977,
      2,
      3.129221,
      NULL,
      0,
      NULL,
      NULL,
      0.174656,
      NULL,
      NULL,
      3.502879,
      1,
      NULL,
      0.021951,
      2,
      2.304940,
      3.769792,
      1.902078,
      0,
      2,
      3.308520,
      1.647087,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078962,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      3,
      NULL,
      0.795706,
      1.848121,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.322349,
      0,
      3,
      0,
      NULL,
      NULL,
      0.318442,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.131375,
      0,
      3.100538,
      0,
      2,
      0,
      NULL,
      3.084835,
      NULL,
      0,
      3,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      0.881664,
      2.290269,
      3,
      NULL,
      1.584396,
      8,
      6.744219,
      1.368449,
      1.626137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.814483,
      2.741704,
      NULL,
      2,
      NULL,
      2,
      1.865093,
      NULL,
      0,
      3.291180,
      0,
      2,
      0.860340,
      NULL,
      NULL,
      3,
      0.733726,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.439474,
      NULL,
      NULL,
      0.223013,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.873119,
      3,
      NULL,
      2,
      2,
      0.250957,
      NULL,
      0.259588,
      NULL,
      9.434440,
      7,
      2.506708,
      NULL,
      NULL,
      NULL,
      2.128344,
      NULL,
      1.877580,
      NULL,
      1.461373,
      2,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      0.350085,
      NULL,
      2,
      2,
      0.856847,
      0.703305,
      0.824625,
      NULL,
      NULL,
      2,
      1.044080,
      2.660802,
      11,
      7.806946,
      8.986621,
      4,
      7,
      NULL,
      0.895972,
      3.318862,
      1.583970,
      1.487876,
      0,
      0.877676,
      NULL,
      1.750666,
      3.139399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397352,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.045483,
      NULL,
      NULL,
      1.984664,
      NULL,
      NULL,
      0.126379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097129,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.176094,
      1.707347,
      1.370167,
      1.107364,
      NULL,
      2.043088,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      0.872618,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.007843,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.531949,
      NULL,
      NULL,
      NULL,
      1.299259,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.271293,
      NULL,
      NULL,
      NULL,
      1.735760,
      NULL,
      NULL,
      NULL,
      0.240675,
      NULL,
      NULL,
      NULL,
      1.412964,
      NULL,
      NULL,
      NULL,
      0.730994,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      5.370868,
      NULL,
      NULL,
      231.877154,
      NULL,
      NULL,
      NULL,
      0.247662,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235268,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      15.585900,
      0,
      0.058532,
      NULL,
      0,
      0,
      1.892286,
      1,
      1.698475,
      1,
      1.741526,
      0,
      1.835955,
      0,
      NULL,
      1.135790,
      1.852404,
      1,
      0.522265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585731,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919749,
      0.854656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507645,
      0.739700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080959,
      2.522316,
      NULL,
      1.664413,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.301556,
      0.183626,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      NULL,
      0.102285,
      NULL,
      1.352631,
      NULL,
      0,
      0.680074,
      3,
      4.699404,
      8.749544,
      0.723156,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4,
      3,
      0,
      0,
      1,
      5.530892,
      1,
      3,
      1,
      0,
      0,
      NULL,
      1,
      0.643280,
      NULL,
      1,
      1,
      NULL,
      1.048926,
      0,
      NULL,
      0,
      0.988488,
      NULL,
      1.864578,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.292622,
      NULL,
      0.667620,
      0.740033,
      NULL,
      1,
      0,
      NULL,
      1.450660,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.660854,
      NULL,
      NULL,
      NULL,
      4.122908,
      6.776020,
      2.463858,
      3,
      0,
      1,
      NULL,
      27.843051,
      3,
      0,
      5.525596,
      '00134',
      NULL,
      '11224',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


