set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7431336';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3410331',
      1,
      NULL,
      1,
      3,
      '4234',
      1.546081,
      1,
      NULL,
      NULL,
      ' 2- 4-1995',
      NULL,
      NULL,
      NULL,
      1,
      0.890694,
      ' 0-28-1982',
      NULL,
      0.694520,
      234,
      79,
      1,
      ' 0- 0-1977',
      ' 5- 4-1974',
      NULL,
      1,
      NULL,
      2.133964,
      2.076566,
      0.733618,
      0.655971,
      2.609462,
      3.915753,
      NULL,
      NULL,
      NULL,
      5.874972,
      6,
      13.725497,
      7.541154,
      3.282919,
      4.713899,
      6,
      2.736561,
      1.772599,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.084079,
      2.193943,
      0.374592,
      0.134090,
      1.331914,
      NULL,
      0.809572,
      1,
      7,
      0.486190,
      NULL,
      1.378835,
      0.254121,
      0.679277,
      0,
      5.012816,
      0,
      0,
      1.718862,
      0.445411,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446877,
      1.487910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.906387,
      1,
      10.866756,
      NULL,
      5.392014,
      1.830810,
      0.075075,
      NULL,
      NULL,
      0.430246,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4.183149,
      NULL,
      0.021208,
      NULL,
      1.880719,
      2,
      NULL,
      1,
      2.060129,
      NULL,
      1,
      NULL,
      1.695993,
      5.013962,
      NULL,
      NULL,
      6,
      6,
      0.752856,
      0.482119,
      5.120030,
      4.292583,
      7.035099,
      NULL,
      10.713798,
      10,
      9.528694,
      5.587892,
      3,
      1,
      NULL,
      1,
      7,
      7.840696,
      3.867837,
      10,
      6,
      NULL,
      11,
      7.553357,
      9.400861,
      6.329423,
      1,
      ' 3-26-1996',
      203,
      ' 3-20-1982',
      215,
      0,
      1.348834,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.390421,
      0.431722,
      1.966430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.360839,
      NULL,
      150.127262,
      1.858905,
      2,
      1.228778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.500611,
      0,
      NULL,
      3.223303,
      1.937042,
      1,
      NULL,
      2,
      3.062326,
      1.726323,
      NULL,
      4,
      1.275362,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      0,
      0.829993,
      0.218750,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.116199,
      0.865899,
      2,
      NULL,
      NULL,
      2.999539,
      1,
      0.093388,
      NULL,
      NULL,
      2,
      3,
      3,
      2.414531,
      2.660759,
      2,
      0,
      0.958139,
      0.563339,
      3.197345,
      0,
      1,
      NULL,
      1,
      0.130381,
      1,
      NULL,
      1,
      0,
      NULL,
      2,
      1.583933,
      NULL,
      5,
      1.954458,
      4,
      NULL,
      7.622219,
      NULL,
      NULL,
      1.035478,
      0,
      3,
      1,
      57,
      3.403860,
      NULL,
      NULL,
      22,
      6,
      NULL,
      NULL,
      5,
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.321591,
      29,
      NULL,
      46.987811,
      0.952634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.186613,
      NULL,
      NULL,
      0.639857,
      NULL,
      NULL,
      3,
      1.644302,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.712038,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.213412,
      1.892110,
      1.745273,
      1.383574,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.266313,
      3,
      NULL,
      1.758543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2.394664,
      2,
      1.445295,
      0.683753,
      NULL,
      0,
      1.322408,
      0.671627,
      1.289119,
      NULL,
      1,
      1,
      0.227511,
      2.005592,
      1.294563,
      1,
      1.773964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5.037827,
      1,
      0.527448,
      1.987192,
      NULL,
      NULL,
      NULL,
      2,
      1.793767,
      NULL,
      0.793870,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3,
      0,
      3,
      2,
      1.801727,
      NULL,
      4,
      NULL,
      0,
      2.750145,
      0,
      2,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.890457,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.285928,
      0.588065,
      NULL,
      5.090003,
      0,
      0.708142,
      NULL,
      2.157111,
      2,
      0,
      NULL,
      1,
      NULL,
      7.008256,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.422005,
      1,
      0.330139,
      1,
      NULL,
      3,
      1.380425,
      3,
      11.339864,
      1.327546,
      3,
      0.377400,
      3,
      0.609255,
      1.656801,
      2.030620,
      2,
      1.495842,
      NULL,
      NULL,
      3,
      0.741186,
      1.415386,
      10,
      6.628660,
      4,
      1,
      4,
      2,
      3.817700,
      1.615696,
      1.551728,
      0.972503,
      1,
      0.241248,
      0.260412,
      1.019143,
      0,
      NULL,
      NULL,
      1.256578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681342,
      NULL,
      NULL,
      1.848652,
      NULL,
      NULL,
      1.761996,
      NULL,
      NULL,
      0.733746,
      NULL,
      NULL,
      0.620064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.159581,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      4.760069,
      NULL,
      0.082612,
      0.879992,
      NULL,
      NULL,
      83.729154,
      NULL,
      0.450112,
      NULL,
      0.492188,
      NULL,
      NULL,
      NULL,
      1.080741,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.231739,
      NULL,
      NULL,
      NULL,
      2.713366,
      NULL,
      NULL,
      NULL,
      3.796115,
      NULL,
      1,
      1.347968,
      3,
      NULL,
      3.812964,
      1.401905,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.456776,
      NULL,
      1,
      1,
      2,
      NULL,
      0.777327,
      1,
      0.649533,
      NULL,
      NULL,
      1.253980,
      NULL,
      NULL,
      3.724280,
      0,
      0,
      NULL,
      1.986634,
      1.806128,
      NULL,
      NULL,
      NULL,
      1,
      1.573703,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.169594,
      0,
      3,
      NULL,
      7.950991,
      5.542349,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.126646,
      4.238531,
      1.332672,
      2.671654,
      504.256892,
      28.453819,
      1,
      NULL,
      NULL,
      0,
      307.324189,
      73,
      1,
      NULL,
      NULL,
      1.774050,
      NULL,
      NULL,
      1.299620,
      NULL,
      NULL,
      NULL,
      1,
      0.616084,
      0.914408,
      0,
      1.479267,
      1.289914,
      0,
      0,
      0.655193,
      0,
      NULL,
      1.323416,
      0,
      0,
      0.298016,
      0,
      1,
      1.370275,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.983780,
      2.193223,
      3,
      9.634230,
      2,
      2,
      NULL,
      3.625831,
      14,
      0,
      1.767451,
      3.238287,
      NULL,
      1.232379,
      0.769375,
      1,
      1.937296,
      0.002913,
      NULL,
      NULL,
      1.514093,
      NULL,
      1,
      1,
      0.115606,
      NULL,
      2,
      2.101609,
      3,
      2.907110,
      2,
      1,
      2.420504,
      3.613370,
      2,
      0.330093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346801,
      2,
      2,
      2,
      1,
      1.347827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.810260,
      1.311640,
      NULL,
      6.230771,
      0,
      NULL,
      0.229372,
      0.412600,
      1.277684,
      8.159409,
      31,
      0.126526,
      5,
      3.671563,
      NULL,
      '23324',
      '',
      1.541824,
      '',
      '',
      '',
      7.580664,
      '24310',
      '11321',
      '22344');
commit;
end;
/


