set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7431336';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      42,
      26.629172,
      NULL,
      NULL,
      1.247690,
      1,
      NULL,
      '1021',
      5.941329,
      0.768510,
      NULL,
      NULL,
      NULL,
      31,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851635,
      NULL,
      NULL,
      ' 2- 0-1981',
      NULL,
      3.745259,
      0.463205,
      2.163261,
      0,
      3.158178,
      4,
      0,
      0.918813,
      7.328621,
      3,
      0.585809,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.153199,
      4.610400,
      1.538696,
      1.928322,
      0,
      0.780984,
      1.211656,
      1.296135,
      11.458256,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      0.297851,
      4,
      1,
      0,
      1.788376,
      NULL,
      NULL,
      0.375317,
      NULL,
      NULL,
      1.822899,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578701,
      1,
      NULL,
      11.012196,
      0,
      2.028548,
      0.181498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.153024,
      5.223992,
      1.908611,
      5,
      0,
      NULL,
      NULL,
      0.447459,
      NULL,
      0.293405,
      3,
      0.429579,
      1.623071,
      1.190024,
      0,
      0.576858,
      NULL,
      0.568278,
      6,
      NULL,
      0.192487,
      1.803305,
      3.066730,
      0,
      7,
      3.068245,
      7,
      NULL,
      NULL,
      5.873789,
      1,
      2.714749,
      NULL,
      7.455515,
      NULL,
      11,
      5.862064,
      6.744985,
      NULL,
      0,
      1.083058,
      3.697078,
      NULL,
      1.143146,
      1.458973,
      ' 3-19-1979',
      710,
      ' 0-29-1986',
      341.782799,
      3,
      NULL,
      0.764688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.688709,
      NULL,
      1.988682,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      628.364621,
      3.161258,
      3,
      1.756374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.539703,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.795256,
      NULL,
      1.986659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779285,
      0,
      0,
      2,
      1.405600,
      NULL,
      1,
      NULL,
      30.902456,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      3.415935,
      0,
      3.493875,
      0.106371,
      1,
      0,
      3,
      3,
      3.784559,
      NULL,
      3,
      0.295700,
      NULL,
      1,
      1,
      1,
      6.809447,
      0,
      0.639888,
      1,
      NULL,
      0.439912,
      1.809547,
      1,
      0,
      0.103131,
      NULL,
      3,
      1.416683,
      10.822441,
      NULL,
      5,
      NULL,
      7.872838,
      7,
      4,
      2,
      0,
      NULL,
      1.543060,
      NULL,
      30,
      3,
      1,
      NULL,
      NULL,
      NULL,
      59.203189,
      NULL,
      NULL,
      0.095215,
      '42321',
      '',
      '',
      0.630553,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      26.594164,
      356,
      34,
      2.235941,
      60,
      0,
      2.483715,
      2.645948,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.313829,
      NULL,
      NULL,
      0.619434,
      NULL,
      NULL,
      1.714926,
      NULL,
      NULL,
      3,
      0.405146,
      1.157967,
      1.458976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130451,
      NULL,
      NULL,
      0.716306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.225124,
      NULL,
      NULL,
      NULL,
      0.737644,
      1.393103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.938965,
      1.797539,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.949940,
      0,
      1.029722,
      NULL,
      3.140605,
      0,
      1.748908,
      0,
      0,
      1,
      0,
      1,
      2.941417,
      1,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.441240,
      6.935487,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      1.387359,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      5,
      3.731711,
      4.509568,
      1.208603,
      2,
      2,
      1,
      0,
      0,
      5.762805,
      0,
      1.648071,
      1.405235,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.372961,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.454029,
      NULL,
      NULL,
      1.437813,
      0.455329,
      3,
      2.409133,
      2,
      NULL,
      NULL,
      8.636028,
      3.485599,
      2,
      5,
      1,
      NULL,
      1.388984,
      NULL,
      NULL,
      2.228373,
      1.590436,
      NULL,
      NULL,
      NULL,
      1,
      2.839754,
      0.647525,
      NULL,
      2.180402,
      5.105113,
      2.533284,
      NULL,
      0.891598,
      1.489700,
      2,
      1,
      1.124305,
      1,
      1,
      2.894338,
      2,
      1.728841,
      1,
      7,
      3,
      3.544963,
      5.451490,
      2,
      2.416451,
      1.518205,
      2,
      7,
      0,
      1,
      0.234396,
      0.415707,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643297,
      NULL,
      NULL,
      0.603687,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.107052,
      3,
      1.987718,
      1,
      0.777619,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      13.188691,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950219,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551159,
      3,
      NULL,
      NULL,
      3.638783,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214979,
      NULL,
      NULL,
      NULL,
      0.985752,
      NULL,
      NULL,
      0.185687,
      0.941186,
      NULL,
      NULL,
      0.921983,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.093911,
      NULL,
      NULL,
      NULL,
      2,
      0.400955,
      NULL,
      NULL,
      0,
      0.663408,
      NULL,
      NULL,
      0.946149,
      NULL,
      NULL,
      NULL,
      1,
      0.478620,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.965486,
      NULL,
      NULL,
      NULL,
      2.735598,
      2,
      1.320193,
      2.076834,
      42.086223,
      38.772210,
      1,
      NULL,
      NULL,
      1,
      423.814158,
      NULL,
      0,
      NULL,
      NULL,
      0.232259,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973437,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.908493,
      1,
      1,
      1,
      1.386512,
      NULL,
      1.747520,
      0,
      1.002186,
      1.567845,
      1,
      1.545839,
      0.986610,
      1.353081,
      1.615355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.329370,
      9.255971,
      1.516580,
      2.203591,
      5,
      NULL,
      4.062570,
      1.790990,
      NULL,
      3.626816,
      1.937974,
      0,
      1,
      0,
      1,
      0,
      0,
      0.512875,
      NULL,
      NULL,
      0.954316,
      1.875992,
      1.888723,
      NULL,
      1.216724,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.955066,
      NULL,
      0,
      2.231139,
      0.644848,
      0.990269,
      NULL,
      3.482933,
      2.111586,
      NULL,
      NULL,
      0.750805,
      1.727756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.136978,
      6,
      12.223957,
      9.635031,
      0.206983,
      0.515939,
      1.172825,
      68.039563,
      79,
      0,
      3.757786,
      3,
      '24222',
      '32102',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


