set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '0443002',
      NULL,
      0,
      NULL,
      1,
      '4144',
      2.387968,
      0.824151,
      NULL,
      NULL,
      ' 5- 9-1976',
      NULL,
      NULL,
      NULL,
      1,
      0,
      ' 6-18-2001',
      NULL,
      NULL,
      147,
      25,
      3.485043,
      ' 9- 4-1987',
      NULL,
      NULL,
      2,
      3.251945,
      2,
      3.367736,
      0.486272,
      2,
      NULL,
      NULL,
      1.658511,
      NULL,
      4.460875,
      0.169141,
      NULL,
      NULL,
      4.760453,
      9,
      9,
      NULL,
      1,
      9,
      1,
      1.471623,
      2,
      0.023454,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      5.832246,
      0.500425,
      0.695918,
      NULL,
      NULL,
      1.483592,
      1,
      0.254387,
      3.467650,
      0.610003,
      1,
      0.173788,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220448,
      1,
      1.345481,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      5.031178,
      5,
      NULL,
      1,
      NULL,
      1.650911,
      0,
      0,
      1,
      0,
      1.680545,
      NULL,
      NULL,
      0.127614,
      1,
      0.454028,
      NULL,
      NULL,
      0,
      0.822061,
      NULL,
      1.558833,
      5,
      5.667204,
      7.319632,
      0.047344,
      4,
      1,
      0,
      4,
      7.252908,
      NULL,
      7,
      5,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.012993,
      0,
      1,
      7.764096,
      1.388326,
      1.173088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.376496,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628132,
      0.840233,
      0.118612,
      0,
      0.382390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579214,
      4.082676,
      1,
      0,
      NULL,
      0.193066,
      0,
      2.774495,
      0,
      1.547200,
      NULL,
      3,
      1,
      4,
      0,
      1,
      4,
      1.793624,
      4.388908,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421542,
      3,
      0.898521,
      0,
      1,
      1.915629,
      0,
      3,
      19,
      2,
      0.107813,
      NULL,
      0,
      12,
      NULL,
      0,
      3,
      1,
      NULL,
      3.995841,
      0.866700,
      NULL,
      2.660423,
      2.946006,
      0,
      0.759041,
      2,
      3.463497,
      NULL,
      2,
      0.738478,
      1,
      1,
      1.069601,
      0,
      0.087291,
      1.769193,
      0,
      NULL,
      6,
      1,
      1.361465,
      NULL,
      NULL,
      1,
      0,
      7,
      4,
      2.286245,
      1,
      4,
      5,
      3.785034,
      2.527078,
      5.161459,
      0,
      3,
      1,
      NULL,
      3,
      NULL,
      NULL,
      20,
      55.754623,
      NULL,
      5.137494,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0,
      24.003767,
      14.249328,
      NULL,
      NULL,
      24,
      1.479065,
      2.605685,
      NULL,
      0,
      NULL,
      3,
      1,
      1.872035,
      1,
      1,
      NULL,
      1,
      1.537322,
      NULL,
      NULL,
      0.390664,
      0.692736,
      0,
      0,
      NULL,
      NULL,
      1.505286,
      NULL,
      NULL,
      0.966240,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.412669,
      NULL,
      NULL,
      0.747123,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.161624,
      3.326594,
      1,
      0.228530,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243051,
      0.323641,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.775226,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975137,
      NULL,
      NULL,
      0.887647,
      NULL,
      NULL,
      0.368517,
      NULL,
      NULL,
      2.257080,
      0.781092,
      0,
      0.227467,
      0.125567,
      NULL,
      NULL,
      NULL,
      1.451223,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0.732227,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      2.674612,
      NULL,
      1,
      NULL,
      NULL,
      1.787118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.479665,
      NULL,
      NULL,
      1.246798,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.459927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.314846,
      1,
      NULL,
      0,
      1.628028,
      5.368600,
      1.874851,
      0.864227,
      5.629404,
      1.837855,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.019469,
      0.421391,
      0,
      0,
      2,
      1,
      0,
      2,
      0.141994,
      0,
      NULL,
      0,
      1.881834,
      1,
      0,
      0,
      1,
      1.834142,
      1,
      0.906805,
      0.807760,
      NULL,
      1,
      NULL,
      NULL,
      3.769427,
      7,
      1,
      0.311485,
      0,
      1,
      0.424243,
      1.916201,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.757032,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.666346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.256540,
      0,
      1,
      1,
      1,
      2,
      NULL,
      6,
      NULL,
      6,
      NULL,
      4.449726,
      30,
      24.452656,
      NULL,
      2.769748,
      1,
      3,
      NULL,
      1,
      1.430871,
      2,
      NULL,
      3,
      NULL,
      2.330414,
      NULL,
      1,
      0.916899,
      1.232174,
      NULL,
      0,
      1.753533,
      1.272326,
      NULL,
      0.951359,
      3,
      2,
      NULL,
      0.191535,
      3,
      0,
      NULL,
      NULL,
      3,
      0.550419,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      3.597873,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.400180,
      1.638748,
      0.413577,
      NULL,
      0.047406,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.308582,
      NULL,
      0,
      1,
      0.279547,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      0.271893,
      NULL,
      NULL,
      NULL,
      0.055304,
      15.316082,
      8.306364,
      2.664093,
      12.711306,
      0.319721,
      NULL,
      NULL,
      NULL,
      2.578489,
      NULL,
      1,
      0.604903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      177,
      NULL,
      1,
      0.380981,
      NULL,
      0,
      1,
      1,
      1.347146,
      1,
      0,
      1.051805,
      1.166433,
      0,
      0.030123,
      1,
      NULL,
      NULL,
      NULL,
      1.486603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.975413,
      1.195121,
      0,
      10,
      NULL,
      NULL,
      0.632135,
      3.279594,
      2.113276,
      0,
      1.298998,
      NULL,
      0.434530,
      1,
      0.590698,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.965420,
      1,
      0.372209,
      0.654329,
      0,
      2,
      3.121905,
      1,
      1.443283,
      0.642131,
      0.639669,
      3.062450,
      3,
      0.950332,
      0.985681,
      3,
      0,
      3,
      1.318217,
      1.463827,
      2.056724,
      3.655590,
      1.510545,
      3,
      2.156427,
      1.832074,
      3.125895,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.106308,
      1.124418,
      1,
      3,
      1,
      2,
      2,
      0,
      0.952759,
      2,
      0,
      0.744239,
      1,
      3,
      NULL,
      3,
      NULL,
      2,
      1.465289,
      NULL,
      NULL,
      1.213347,
      1.774058,
      NULL,
      0.932763,
      NULL,
      17.245577,
      0.780342,
      5.649763,
      NULL,
      1,
      0,
      0.561791,
      0.147452,
      0,
      6.015901,
      4,
      4.341480,
      0,
      0,
      3.830156,
      24.137009,
      31.430460,
      NULL,
      1.939295,
      NULL,
      '24433',
      '00234',
      '',
      1.691182,
      '',
      '',
      '',
      4,
      '21331',
      '20312',
      '42313');
commit;
end;
/


