set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8806665';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '3002343',
      2,
      0.405982,
      1,
      3,
      '4010',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.256196,
      NULL,
      ' 9-27-1985',
      2.893760,
      2,
      305,
      NULL,
      NULL,
      ' 0- 9-1983',
      NULL,
      ' 5-21-2001',
      3,
      1.590961,
      1.113066,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0.177213,
      NULL,
      18,
      2,
      6,
      NULL,
      NULL,
      17.705027,
      0,
      0,
      6.239062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.037736,
      2.712912,
      6.349884,
      0.761068,
      1.612518,
      0.464461,
      1,
      1.239275,
      0.655991,
      0,
      1,
      NULL,
      0,
      0,
      1.008292,
      2.213129,
      0.717551,
      0,
      1.879669,
      1.044315,
      NULL,
      NULL,
      1.884723,
      NULL,
      NULL,
      1.035002,
      0.181334,
      0.312125,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968991,
      0.794294,
      1.571778,
      1.165539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.664755,
      1.367472,
      0,
      0.860654,
      NULL,
      4,
      NULL,
      0,
      1,
      2,
      0,
      1.182750,
      1.494539,
      0.652452,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.339791,
      NULL,
      1.743887,
      1,
      0,
      1,
      0,
      1.812704,
      3,
      0,
      0,
      0.646134,
      NULL,
      5,
      0,
      6,
      NULL,
      NULL,
      5,
      3.454314,
      7,
      4.895740,
      NULL,
      4,
      2.864420,
      '11- 9-1997',
      NULL,
      ' 5- 5-1998',
      35,
      3,
      NULL,
      NULL,
      3.626637,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.631874,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185907,
      0,
      1.384099,
      NULL,
      NULL,
      NULL,
      0,
      1.600969,
      1.134329,
      0,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435875,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.100927,
      0.083563,
      0.161816,
      1,
      NULL,
      0.983179,
      1.016096,
      0,
      17,
      1,
      0.417455,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555106,
      3.287442,
      3,
      2,
      3,
      2,
      2.530824,
      3.712328,
      0.821391,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276161,
      7,
      1,
      0.867461,
      1,
      NULL,
      1.680781,
      NULL,
      NULL,
      1.273449,
      NULL,
      1.357892,
      1.920491,
      0.115073,
      0,
      0.128054,
      1,
      3.898927,
      8.287392,
      1.709433,
      0.698782,
      2,
      1,
      5,
      1.552667,
      NULL,
      NULL,
      1,
      0,
      55,
      2.292921,
      NULL,
      NULL,
      46,
      20.671507,
      12,
      1,
      NULL,
      5,
      '23110',
      NULL,
      NULL,
      0.203529,
      '',
      '',
      NULL,
      1.945327,
      '',
      '',
      '',
      NULL,
      41,
      3.372244,
      43.487715,
      NULL,
      13,
      1.316853,
      11.193029,
      2,
      0.764502,
      NULL,
      NULL,
      1.533499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.401440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662112,
      NULL,
      NULL,
      0.320928,
      NULL,
      NULL,
      6,
      NULL,
      5.752004,
      0.541467,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467555,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.672309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498887,
      NULL,
      NULL,
      0.502971,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.191329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741123,
      NULL,
      NULL,
      2.674291,
      2,
      1.888699,
      NULL,
      NULL,
      NULL,
      0.843061,
      NULL,
      NULL,
      0.366816,
      5,
      1.904428,
      3.977296,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.170523,
      5.523090,
      1.847962,
      1.065924,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.141026,
      NULL,
      NULL,
      0.633177,
      NULL,
      NULL,
      1.533961,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.956794,
      0,
      1.889248,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.675340,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140272,
      NULL,
      NULL,
      NULL,
      1.720352,
      0.921597,
      1.168441,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.170681,
      0,
      0,
      7.318670,
      NULL,
      1.860693,
      NULL,
      3,
      3.200178,
      4,
      6.847412,
      0,
      1,
      NULL,
      0.633777,
      0.338825,
      0,
      NULL,
      NULL,
      0.059109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352923,
      NULL,
      NULL,
      1.044381,
      NULL,
      NULL,
      1.257383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378492,
      NULL,
      NULL,
      1.125381,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.392418,
      0.723360,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582126,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.365517,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.977758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.649088,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.480930,
      4,
      NULL,
      0.342162,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      7,
      1.708428,
      NULL,
      NULL,
      1,
      0.121831,
      0,
      0,
      0.671225,
      3,
      0,
      3.711911,
      NULL,
      0.231920,
      1.559904,
      NULL,
      0.099942,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.483677,
      NULL,
      1.363177,
      NULL,
      NULL,
      NULL,
      87.297582,
      NULL,
      1,
      NULL,
      27,
      NULL,
      NULL,
      1,
      3,
      0.689499,
      NULL,
      1.269493,
      NULL,
      NULL,
      NULL,
      1.601151,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.934190,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.792169,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655604,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.449322,
      NULL,
      0.795776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.580005,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      187,
      NULL,
      2,
      NULL,
      1.608684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.373977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608426,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.177703,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.248614,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.130302,
      NULL,
      3,
      NULL,
      111.317896,
      NULL,
      3,
      NULL,
      3.107334,
      NULL,
      0,
      NULL,
      0,
      0,
      8,
      NULL,
      0,
      0,
      0.616496,
      3,
      1,
      0.414846,
      0.866061,
      1,
      1,
      1,
      1.466333,
      0.219838,
      3.392407,
      2.087983,
      2.378176,
      0.297624,
      1.329914,
      1,
      NULL,
      NULL,
      1.949886,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.438740,
      NULL,
      0,
      0.250425,
      NULL,
      0.749623,
      1.581647,
      NULL,
      1,
      0.039702,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.745130,
      1,
      NULL,
      1.220586,
      1,
      NULL,
      1.732680,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110833,
      NULL,
      0,
      NULL,
      3.958415,
      NULL,
      NULL,
      0.071780,
      NULL,
      NULL,
      44.996518,
      44.800362,
      0,
      0,
      1.774896,
      '41210',
      '42232',
      '13324',
      0,
      NULL,
      '',
      NULL,
      0.364635,
      '',
      '',
      NULL);
commit;
end;
/


