set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      2.420027,
      1.463928,
      5,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      ' 7-13-1994',
      8.684505,
      NULL,
      5.239372,
      3,
      4.591611,
      NULL,
      NULL,
      3.782469,
      NULL,
      22.374300,
      3,
      ' 5-26-1981',
      ' 3- 7-1999',
      ' 3-15-1978',
      0.852300,
      NULL,
      1.113527,
      NULL,
      1.402078,
      1.628376,
      2.967994,
      0,
      NULL,
      289.442391,
      1.908085,
      11.086886,
      0.520917,
      7,
      17,
      5.555248,
      12.543633,
      4.301028,
      9,
      NULL,
      1,
      5,
      1.052719,
      0.903137,
      0.897991,
      0.034528,
      0.328148,
      NULL,
      1,
      0,
      0,
      1,
      3,
      5.437276,
      3,
      3.316005,
      1,
      0.335327,
      8.752663,
      5,
      0,
      7.942024,
      7.086122,
      NULL,
      3.369543,
      NULL,
      0,
      8.997873,
      1,
      5,
      NULL,
      2.779661,
      NULL,
      NULL,
      NULL,
      1.013116,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464171,
      3.433457,
      1.894866,
      NULL,
      0.374513,
      0.580538,
      NULL,
      3,
      2.250496,
      NULL,
      0.359133,
      1.113160,
      0.477326,
      NULL,
      1.708325,
      0.986521,
      0,
      1.213923,
      1,
      0.566276,
      NULL,
      0,
      3,
      NULL,
      0.638412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998340,
      7.520689,
      5.677023,
      1.052999,
      3,
      NULL,
      3,
      1,
      2,
      1,
      3,
      0.483609,
      0,
      2,
      NULL,
      1.811110,
      NULL,
      0.410838,
      NULL,
      NULL,
      1.662190,
      3.199185,
      NULL,
      0.557110,
      NULL,
      0,
      2.449072,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.548703,
      5,
      NULL,
      5,
      8.226021,
      2.917453,
      9.480619,
      NULL,
      8,
      9,
      7.596096,
      4.814794,
      1,
      5,
      0.642014,
      NULL,
      '10- 1-1994',
      1585.960201,
      ' 2-13-1997',
      279,
      2,
      0,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614541,
      0,
      0.075685,
      0,
      0.135232,
      1.441797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.913120,
      1.001529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.015433,
      NULL,
      3.621112,
      1.916391,
      1.696166,
      NULL,
      NULL,
      NULL,
      1,
      7.901142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      1,
      1.000659,
      3.637958,
      NULL,
      NULL,
      0.021597,
      NULL,
      NULL,
      NULL,
      2.237126,
      0,
      0.241556,
      1.790676,
      0,
      0,
      4,
      3,
      7.093423,
      NULL,
      3.210774,
      2,
      3.201098,
      5,
      2.939578,
      NULL,
      5,
      NULL,
      0,
      0,
      0.806553,
      1.441563,
      NULL,
      1,
      NULL,
      1,
      1,
      0.437539,
      NULL,
      1,
      1,
      0.181433,
      7,
      9.425713,
      2.538406,
      NULL,
      11.461355,
      7.399944,
      NULL,
      NULL,
      2.293042,
      3,
      3.559147,
      0,
      36,
      1,
      0.351454,
      NULL,
      1,
      12,
      56.990145,
      5.677736,
      1,
      3.175469,
      NULL,
      '03032',
      '',
      0,
      '',
      '',
      '',
      2,
      '0111',
      NULL,
      '3032',
      1,
      26,
      95,
      8,
      1.524499,
      25,
      NULL,
      8,
      0,
      3.303479,
      2.137347,
      1.699453,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.996690,
      1.805712,
      1,
      0.164084,
      3,
      NULL,
      1.917000,
      0,
      0,
      0,
      0.852587,
      NULL,
      NULL,
      NULL,
      3,
      2.939810,
      1,
      0.548811,
      0,
      0.588621,
      1,
      4.117951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675418,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.774506,
      NULL,
      NULL,
      3.551367,
      0.017291,
      0.555078,
      0,
      1,
      NULL,
      1.753480,
      3,
      0.476570,
      1.203825,
      NULL,
      3.183204,
      NULL,
      1,
      NULL,
      1,
      1.980369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.669902,
      1.305813,
      1.289716,
      NULL,
      1.236471,
      NULL,
      0.980733,
      1,
      NULL,
      NULL,
      NULL,
      0.627742,
      NULL,
      NULL,
      NULL,
      1.556347,
      NULL,
      NULL,
      1,
      2,
      2,
      0.382014,
      0.817975,
      0.648566,
      1.213632,
      NULL,
      NULL,
      NULL,
      2.125836,
      2,
      2,
      1,
      0,
      2,
      0,
      0.829157,
      2,
      0.446319,
      1,
      0.259153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.024431,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      1.317113,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      2,
      2,
      NULL,
      1.460651,
      5,
      3,
      1.218757,
      2.364204,
      3.050186,
      1.481289,
      3.850537,
      2,
      2,
      NULL,
      0.468157,
      4.887846,
      4.937570,
      NULL,
      1,
      1.333151,
      1,
      1.096453,
      0.949326,
      2.394939,
      NULL,
      1,
      0.156505,
      3,
      0,
      1.642153,
      NULL,
      1,
      5.236471,
      0.264911,
      1.011991,
      2.248134,
      3.434482,
      6,
      0.101494,
      NULL,
      0,
      0,
      1.753973,
      NULL,
      NULL,
      NULL,
      1.401481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067503,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.663561,
      NULL,
      NULL,
      0.623475,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.335410,
      NULL,
      NULL,
      0.117507,
      1.101359,
      1.208743,
      1.549675,
      1.726513,
      NULL,
      0,
      NULL,
      NULL,
      1.531229,
      0.889116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.970555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.294334,
      NULL,
      NULL,
      NULL,
      0.149491,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192636,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.226690,
      NULL,
      NULL,
      3.821770,
      1.046570,
      NULL,
      NULL,
      3,
      1.440143,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      14.603309,
      0.112967,
      NULL,
      NULL,
      1.259121,
      NULL,
      NULL,
      NULL,
      1,
      4.420416,
      3,
      0.448681,
      NULL,
      NULL,
      0.107790,
      NULL,
      NULL,
      1.408326,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      403.186701,
      15.528730,
      NULL,
      1,
      1.950171,
      NULL,
      0,
      1.530648,
      2,
      1.035270,
      NULL,
      0,
      1,
      1.655204,
      1.767641,
      1,
      0.965738,
      0,
      3.128744,
      1.975415,
      1.680245,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      61.388812,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.839678,
      0.050620,
      NULL,
      1.883727,
      NULL,
      0,
      NULL,
      0.313344,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.330924,
      NULL,
      NULL,
      NULL,
      0.202020,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889382,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.678369,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.754042,
      9.128480,
      5,
      NULL,
      1,
      1,
      14,
      1.737736,
      2,
      1.785204,
      0.480401,
      3,
      NULL,
      NULL,
      3.214152,
      NULL,
      3.451821,
      1,
      0,
      NULL,
      0.788812,
      1.999543,
      3.574577,
      2.954801,
      NULL,
      0,
      1.812294,
      0,
      1,
      0,
      0.603389,
      0.937579,
      1,
      1.122262,
      1.280419,
      3,
      0,
      3,
      3,
      0,
      1,
      0,
      NULL,
      1,
      1.738182,
      1.916542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771295,
      0,
      1.567763,
      1,
      1,
      1,
      3.006385,
      3,
      NULL,
      1,
      2,
      0.848216,
      NULL,
      NULL,
      NULL,
      0.745134,
      3.885322,
      '12234',
      '32214',
      '',
      0,
      '22033',
      '',
      '',
      1,
      '0100',
      '0442',
      NULL);
commit;
end;
/


