set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      37,
      5,
      '4113424',
      NULL,
      NULL,
      0,
      NULL,
      '2132',
      2,
      0.559706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-26-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      1.961226,
      NULL,
      NULL,
      ' 6- 2-1999',
      2,
      2,
      2.321389,
      2,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      11.173711,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430928,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.853494,
      NULL,
      1,
      0.627332,
      1.227729,
      1,
      0.999831,
      NULL,
      1,
      3,
      3.944240,
      1.731570,
      4,
      1.451781,
      0.444367,
      0.074632,
      2,
      0,
      5.406650,
      1,
      NULL,
      0.561941,
      1,
      0,
      3.911652,
      1,
      3.043416,
      1.390114,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.119820,
      NULL,
      0.885638,
      1.825367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.517199,
      1,
      3.564123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.467916,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0.639262,
      3.049393,
      0.121554,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0.363484,
      1.076499,
      NULL,
      1,
      0.322357,
      1,
      1,
      1,
      1,
      1,
      3.174770,
      0,
      0.948854,
      1.333070,
      4.544513,
      NULL,
      0,
      NULL,
      0,
      2,
      5,
      3,
      6.715139,
      0.234325,
      0.757440,
      4,
      7,
      1.976779,
      0.048296,
      5.768816,
      1.381961,
      ' 2- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.571835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434692,
      0,
      NULL,
      1.989294,
      0,
      0.428009,
      0.281415,
      0.467675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.141142,
      NULL,
      27.086778,
      NULL,
      2,
      2.134013,
      0,
      1.793969,
      2,
      NULL,
      6,
      2,
      1,
      NULL,
      3,
      0.677846,
      NULL,
      1.684573,
      0.844871,
      5,
      3.855953,
      7,
      1,
      NULL,
      2,
      0.935890,
      0.304910,
      3,
      7.975227,
      1,
      4.269282,
      5.526736,
      1.361709,
      1,
      ' 7-19-1998',
      NULL,
      ' 5- 7-1990',
      12.509611,
      0.935978,
      1.041623,
      1.907401,
      3,
      NULL,
      0.237701,
      0,
      1.130791,
      0.530617,
      1,
      0,
      0,
      NULL,
      1.101282,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545680,
      NULL,
      3.603345,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      0.856388,
      2,
      2.283490,
      NULL,
      1,
      3.037012,
      0.570722,
      0.895529,
      NULL,
      3.879685,
      0,
      1,
      1.438960,
      NULL,
      0,
      NULL,
      0,
      1,
      1.206237,
      0.830336,
      1,
      0,
      1,
      6,
      2.706256,
      2,
      1,
      3.047885,
      0.944104,
      0.114759,
      3.331854,
      1.595086,
      1,
      1,
      54,
      1.609531,
      2.840951,
      NULL,
      NULL,
      15.929938,
      12.779476,
      2.497616,
      3,
      2.632073,
      '14432',
      '22022',
      '',
      2.702470,
      '34322',
      '',
      '',
      NULL,
      '1200',
      '3144',
      NULL,
      3.615729,
      21.037365,
      62.937292,
      9.617466,
      1.668543,
      NULL,
      NULL,
      NULL,
      2.497837,
      2,
      1.415049,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.825241,
      1.334580,
      NULL,
      2,
      1,
      0,
      NULL,
      2,
      3.608761,
      NULL,
      1,
      NULL,
      1.604015,
      3,
      2.827756,
      2.456181,
      1.849260,
      NULL,
      NULL,
      2.464739,
      3.387847,
      3.002069,
      1.642813,
      1,
      1.585487,
      4,
      5.782115,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.621674,
      NULL,
      NULL,
      NULL,
      3.694767,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.587418,
      NULL,
      3.008374,
      0,
      NULL,
      NULL,
      0.804276,
      2,
      2.436973,
      1.383665,
      2,
      2.912556,
      1,
      NULL,
      NULL,
      1.306622,
      NULL,
      NULL,
      NULL,
      1.265926,
      0.683093,
      1,
      1.126679,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.252147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.666934,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3.228990,
      0,
      0.024721,
      NULL,
      1,
      0,
      1,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.854543,
      NULL,
      NULL,
      1.293188,
      NULL,
      NULL,
      0.340713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663430,
      NULL,
      NULL,
      0,
      2.126559,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.754864,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.354907,
      3.722374,
      NULL,
      2.419113,
      3,
      NULL,
      1,
      4,
      7.467556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3.155100,
      2,
      2,
      2.261838,
      3.295353,
      NULL,
      4,
      1.082831,
      6.074772,
      1.136371,
      1,
      NULL,
      0.699373,
      5,
      NULL,
      0,
      0.700249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.045514,
      NULL,
      NULL,
      0.717148,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.983987,
      NULL,
      NULL,
      3,
      1.468126,
      NULL,
      1.372350,
      1,
      2.470690,
      3,
      NULL,
      NULL,
      1.632577,
      1.392882,
      NULL,
      NULL,
      89,
      NULL,
      NULL,
      NULL,
      1.958769,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.172518,
      NULL,
      NULL,
      NULL,
      1.611936,
      NULL,
      NULL,
      NULL,
      0.999037,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.735755,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.139139,
      NULL,
      NULL,
      1,
      0.427951,
      NULL,
      NULL,
      NULL,
      1.362222,
      NULL,
      NULL,
      14.287639,
      0.757226,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      10,
      2.730816,
      NULL,
      NULL,
      0.989760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281829,
      NULL,
      NULL,
      1.477330,
      NULL,
      NULL,
      0,
      NULL,
      0.327692,
      1723,
      15,
      0.158251,
      3,
      1,
      0.894832,
      0.503354,
      0,
      1,
      3.782509,
      0,
      NULL,
      0,
      2,
      0.458049,
      1,
      1.227263,
      0,
      1,
      NULL,
      NULL,
      1.051909,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      63.173300,
      NULL,
      NULL,
      44,
      34,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.424226,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.438058,
      NULL,
      0.411920,
      NULL,
      2.124234,
      NULL,
      1.289434,
      1.036107,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265832,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.712441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896966,
      1.626609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.488654,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021907,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      4.194700,
      4,
      4.375914,
      1,
      3,
      1,
      2.872569,
      3.002069,
      0.859751,
      2,
      1.441543,
      1,
      1,
      0.765733,
      NULL,
      1,
      0.449165,
      NULL,
      NULL,
      1.701995,
      0,
      3,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      2.364837,
      1,
      0,
      1,
      3.714360,
      1.465134,
      NULL,
      NULL,
      2,
      3,
      0,
      1.691283,
      1,
      3,
      3.961466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.083481,
      1,
      6.835744,
      2,
      11.397384,
      2.463399,
      0,
      3,
      26.022723,
      70,
      2.424655,
      2.258464,
      2.757751,
      '43220',
      NULL,
      '',
      3,
      '10001',
      '',
      NULL,
      4.110913,
      '0034',
      NULL,
      '');
commit;
end;
/


