set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0182143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.831093,
      0.219104,
      NULL,
      0,
      3.698081,
      2.116847,
      3,
      2.638263,
      '242',
      NULL,
      2.849696,
      27,
      NULL,
      NULL,
      0.525195,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 2-15-2002',
      10.651251,
      NULL,
      NULL,
      2,
      0,
      ' 6-13-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      5.072015,
      NULL,
      NULL,
      ' 7- 0-1976',
      2.901002,
      0,
      0.256064,
      NULL,
      1,
      3.085187,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.739138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.888123,
      0,
      NULL,
      1,
      1.775819,
      1,
      0,
      1,
      1.475050,
      NULL,
      1.710148,
      1.899406,
      NULL,
      1,
      2,
      5,
      3,
      2.731851,
      2.975522,
      1,
      1.205742,
      0,
      NULL,
      1.190746,
      4,
      1.034686,
      1,
      1.310155,
      0,
      0,
      NULL,
      0.317659,
      3,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081571,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149109,
      0.054556,
      0.821371,
      0.562968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755270,
      NULL,
      1.228324,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.859247,
      1,
      NULL,
      1,
      1.024253,
      1.911378,
      0,
      1,
      NULL,
      1.593498,
      3,
      1.545109,
      2.823372,
      0.605130,
      0,
      4.789119,
      5,
      1.761544,
      1.185852,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      0.294840,
      NULL,
      0,
      3,
      NULL,
      NULL,
      8.028833,
      4,
      0.432102,
      2.934934,
      NULL,
      2.786420,
      ' 0- 0-2000',
      129.597279,
      ' 9-26-1994',
      97,
      3,
      0,
      0.349435,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.491153,
      2.838266,
      1,
      1.532023,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.075283,
      0,
      NULL,
      2,
      1,
      0.578284,
      1.517602,
      1,
      2.956379,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837961,
      2.978122,
      NULL,
      1.066518,
      0.538566,
      1.519720,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      0.169014,
      1,
      1.835962,
      0.436078,
      2,
      0,
      3.238939,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0,
      0,
      0.585263,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.532655,
      0.579718,
      1,
      NULL,
      0.876320,
      0.514092,
      1,
      NULL,
      9.814358,
      0.500701,
      2.226578,
      2,
      NULL,
      4.750012,
      0.621641,
      4.018712,
      2.846690,
      3,
      0.460677,
      18.970724,
      1,
      1,
      27,
      NULL,
      NULL,
      NULL,
      4,
      0.867201,
      2,
      '14014',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      1.775220,
      34.236485,
      20.808044,
      1,
      11.822470,
      NULL,
      2.914127,
      5.010695,
      0.563935,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      1.054102,
      1.373356,
      NULL,
      NULL,
      2,
      3.762258,
      0.770396,
      0,
      3.829232,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.913322,
      3.535469,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.355594,
      NULL,
      4,
      2.980238,
      4.259003,
      0,
      NULL,
      1.258680,
      2,
      NULL,
      2.683923,
      0.580439,
      1,
      1.643525,
      0,
      NULL,
      0,
      2.880463,
      2.647220,
      0.895418,
      NULL,
      2.396713,
      1.754745,
      2.859199,
      0,
      0.196288,
      1.237173,
      1.063601,
      1,
      3.492788,
      3,
      1,
      NULL,
      0,
      0.098255,
      NULL,
      0,
      NULL,
      0.521768,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      0.931485,
      NULL,
      5.431820,
      0.940222,
      1.588360,
      NULL,
      1.969982,
      3,
      2,
      NULL,
      2.184959,
      3.761948,
      1,
      NULL,
      NULL,
      3.595840,
      NULL,
      2.803019,
      NULL,
      2.215337,
      0.063221,
      0.525800,
      NULL,
      NULL,
      NULL,
      4,
      4.272150,
      NULL,
      0.343949,
      0,
      3,
      0.697542,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.947588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825073,
      NULL,
      NULL,
      0.137827,
      NULL,
      NULL,
      1.940778,
      NULL,
      NULL,
      1.200054,
      2,
      NULL,
      0.048459,
      NULL,
      NULL,
      4.024491,
      4,
      NULL,
      9.328017,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.392142,
      3.936293,
      NULL,
      0.439848,
      NULL,
      0,
      1,
      3,
      2.726065,
      0,
      6,
      NULL,
      NULL,
      3,
      0,
      1,
      2.201569,
      3.439427,
      0,
      1,
      0,
      3.358158,
      1.823137,
      1,
      11.623303,
      2,
      1.035879,
      6,
      NULL,
      0.777274,
      NULL,
      2.617709,
      NULL,
      NULL,
      3,
      2,
      1.807787,
      3,
      0.256078,
      NULL,
      3,
      4.670151,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.698290,
      NULL,
      1.257103,
      NULL,
      NULL,
      0,
      1.910706,
      NULL,
      3.684515,
      NULL,
      NULL,
      0,
      2.903565,
      NULL,
      0.206031,
      3.569840,
      NULL,
      1,
      3.494695,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      3.031497,
      0,
      NULL,
      8.328155,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.081265,
      NULL,
      1.257015,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      19.281881,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.822898,
      NULL,
      NULL,
      NULL,
      NULL,
      3.342412,
      NULL,
      NULL,
      1.842760,
      NULL,
      NULL,
      NULL,
      0,
      0.841868,
      NULL,
      NULL,
      3.339503,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.121529,
      0.134805,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.157997,
      0.004748,
      NULL,
      NULL,
      1.541692,
      NULL,
      NULL,
      NULL,
      0.518620,
      0.038488,
      NULL,
      NULL,
      1,
      3.693024,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.209605,
      NULL,
      NULL,
      6,
      6,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.389736,
      NULL,
      8.454185,
      1,
      1.371164,
      2,
      NULL,
      NULL,
      NULL,
      1.505369,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.608745,
      NULL,
      0.181599,
      61,
      2,
      NULL,
      0.266803,
      0,
      1,
      0,
      0,
      0.239609,
      0,
      1.545970,
      0,
      1,
      1.114034,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714611,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013299,
      2,
      NULL,
      NULL,
      NULL,
      1.247762,
      NULL,
      NULL,
      NULL,
      0.536726,
      NULL,
      0,
      NULL,
      0,
      1.480279,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.808623,
      7,
      1.105930,
      0,
      NULL,
      3.569276,
      1,
      3,
      3,
      NULL,
      0,
      0.718309,
      1,
      NULL,
      0,
      0.263497,
      0.752692,
      3.111567,
      NULL,
      0.408638,
      NULL,
      0.514787,
      0,
      0,
      1,
      1.866751,
      1.421702,
      0.761300,
      NULL,
      2.980924,
      3.080532,
      0,
      0,
      0.793999,
      1,
      0.624446,
      0,
      0.244409,
      0,
      1,
      0,
      1,
      0,
      NULL,
      2.139592,
      1.748151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444382,
      1.748500,
      NULL,
      1,
      1,
      1,
      0.409865,
      1.659857,
      NULL,
      NULL,
      NULL,
      NULL,
      8.610096,
      32,
      NULL,
      0.650217,
      NULL,
      '20343',
      NULL,
      '',
      1.639458,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


