set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.215191,
      1.400140,
      3.507515,
      NULL,
      NULL,
      0,
      0,
      3.313275,
      '414',
      NULL,
      NULL,
      41.079025,
      '1434232',
      0.149344,
      0,
      NULL,
      2,
      '4441',
      2.737013,
      0,
      NULL,
      NULL,
      NULL,
      121,
      183.727318,
      NULL,
      NULL,
      4,
      ' 1- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      3.623710,
      ' 5-20-1993',
      NULL,
      ' 8-22-1984',
      2.495803,
      NULL,
      0.100826,
      0.982095,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297016,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1.365666,
      1.665395,
      0,
      NULL,
      NULL,
      0.424022,
      2.608031,
      0,
      3.800972,
      0,
      1.972433,
      2.461129,
      NULL,
      1.611878,
      0.052072,
      NULL,
      2,
      NULL,
      6,
      4.886253,
      1.232753,
      0.608661,
      0.436937,
      NULL,
      6.646265,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.289902,
      2.582789,
      3,
      0.952127,
      1.844207,
      1.427516,
      1,
      0,
      NULL,
      0.982936,
      1,
      3,
      2.564725,
      NULL,
      0,
      0,
      1,
      NULL,
      0.362797,
      1,
      NULL,
      2,
      NULL,
      NULL,
      5,
      1,
      3,
      2.373957,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      5,
      9.054841,
      0,
      1,
      1.651943,
      1.537710,
      NULL,
      1.107919,
      0.978363,
      1.819020,
      0,
      0.261458,
      1,
      NULL,
      1,
      1.240126,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      7.936441,
      1.757308,
      NULL,
      4,
      1,
      1.590639,
      NULL,
      1,
      1.047833,
      0.766410,
      0.821684,
      4,
      NULL,
      9.689699,
      1,
      0.359322,
      9.587513,
      1.166360,
      NULL,
      NULL,
      2.716602,
      ' 3-17-2002',
      NULL,
      NULL,
      2,
      1.727786,
      NULL,
      NULL,
      4,
      0.163194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.362990,
      1.391563,
      1.425354,
      1.116814,
      NULL,
      0,
      0.979092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.475312,
      1.975766,
      NULL,
      3,
      1.712186,
      1,
      1.030850,
      NULL,
      NULL,
      8.365348,
      0,
      0.465010,
      NULL,
      NULL,
      NULL,
      1,
      5,
      6,
      3,
      NULL,
      4,
      3,
      0.380382,
      NULL,
      NULL,
      3,
      13.182039,
      NULL,
      3.671619,
      3,
      0,
      0,
      ' 3- 3-1976',
      261,
      ' 6- 6-1996',
      21.096410,
      0.604363,
      1.350531,
      NULL,
      3,
      0.763675,
      1,
      1.898468,
      1,
      1,
      0.273281,
      1.408090,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.851199,
      2,
      3.136291,
      1.815777,
      2.258166,
      1,
      1.543477,
      0.391051,
      2,
      1,
      0.887470,
      1,
      2.924121,
      3,
      0,
      NULL,
      1.022215,
      2.384417,
      1,
      0,
      1,
      1.562741,
      0.771590,
      NULL,
      0.296443,
      NULL,
      0.250141,
      1,
      0.765337,
      0.681282,
      11.264029,
      NULL,
      3,
      6.947021,
      8.656554,
      1,
      NULL,
      0,
      1.172603,
      2.014206,
      0,
      2.368945,
      NULL,
      NULL,
      2.209419,
      NULL,
      NULL,
      32.708793,
      60,
      1,
      NULL,
      NULL,
      '31224',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951925,
      1.354658,
      0,
      0,
      1.659046,
      1.256185,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.525869,
      NULL,
      NULL,
      1.805374,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124985,
      101.556144,
      2.120518,
      1,
      1.489988,
      0,
      0,
      0.710956,
      NULL,
      0.200620,
      1.219443,
      1,
      0,
      0,
      0.562836,
      0,
      1,
      1.894402,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670736,
      2,
      1.323097,
      4,
      1.328495,
      0,
      1,
      0.066627,
      3,
      3,
      1.919450,
      1,
      NULL,
      3,
      NULL,
      1,
      0.087837,
      NULL,
      1,
      0.820276,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.385491,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.102631,
      1.660135,
      NULL,
      1,
      1,
      NULL,
      0.411251,
      0.165386,
      NULL,
      3,
      0.575214,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035834,
      NULL,
      0.592946,
      NULL,
      3.243729,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      39.306763,
      49,
      2.869396,
      3,
      NULL,
      '13123',
      '',
      '',
      0,
      '',
      '',
      '',
      1.048176,
      '',
      '',
      '');
commit;
end;
/


