set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      5.029622,
      2.706350,
      3,
      4.079235,
      NULL,
      NULL,
      2.482794,
      '001',
      '32323203',
      34,
      52.433634,
      '0404041',
      1.358649,
      0.923219,
      0,
      3,
      '4140',
      1.457474,
      0.579235,
      NULL,
      NULL,
      NULL,
      0,
      37.344505,
      NULL,
      NULL,
      NULL,
      ' 2- 0-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      9.503571,
      NULL,
      NULL,
      ' 7-10-1977',
      1,
      0.961660,
      3,
      0,
      0.958402,
      NULL,
      0,
      NULL,
      0.812861,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947148,
      NULL,
      NULL,
      1.558686,
      NULL,
      1.683844,
      0,
      1,
      1,
      1,
      1,
      1.125645,
      0.640082,
      NULL,
      1,
      0,
      3,
      3,
      8,
      1,
      1,
      1,
      1.809717,
      0,
      7.902200,
      0.134522,
      3,
      0.955627,
      0.854588,
      1.879153,
      9.452259,
      NULL,
      3.792386,
      1.699922,
      1.498982,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      1.872057,
      0,
      NULL,
      0,
      1.083787,
      2.662754,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      1.886688,
      0.818906,
      2.881991,
      NULL,
      1,
      NULL,
      1.663337,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.819901,
      2,
      0,
      0.245091,
      3,
      1.724925,
      0,
      1.868199,
      NULL,
      4,
      NULL,
      2,
      0,
      0,
      1,
      0.776087,
      0.403284,
      NULL,
      1,
      0.700913,
      0,
      5,
      0.446237,
      NULL,
      3,
      NULL,
      3.537084,
      1.400503,
      NULL,
      2,
      1.990306,
      1.403324,
      2.356344,
      4,
      6.221210,
      NULL,
      4,
      1,
      8,
      NULL,
      NULL,
      NULL,
      2.822723,
      0.164184,
      0.020639,
      3,
      ' 9-29-1984',
      440,
      '10-18-1984',
      38,
      0,
      1.204661,
      1.018524,
      6.743984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384667,
      1.323523,
      1.403641,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.292503,
      3,
      1,
      1.238004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.455464,
      1.239118,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.288986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.179334,
      0.416614,
      NULL,
      1,
      1,
      0,
      0.874511,
      NULL,
      NULL,
      0.229289,
      NULL,
      NULL,
      NULL,
      1.592104,
      0,
      3,
      3,
      1.333173,
      2,
      0.291739,
      0.687977,
      NULL,
      3.786828,
      NULL,
      2,
      2.503617,
      0.250693,
      3.091665,
      3.032780,
      NULL,
      1,
      0.351087,
      1,
      NULL,
      0.957798,
      1.845822,
      0.818103,
      0,
      1.511781,
      0.289591,
      1.620792,
      0.414583,
      0.895483,
      NULL,
      NULL,
      9,
      0.981901,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      4,
      NULL,
      3,
      1,
      22,
      1,
      1.387588,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.080609,
      '33024',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.963304,
      NULL,
      21,
      19.118494,
      NULL,
      NULL,
      3,
      3,
      2.744111,
      0.856206,
      NULL,
      1.249931,
      1.445651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.793797,
      NULL,
      NULL,
      0,
      NULL,
      0.475394,
      0,
      0,
      NULL,
      2.032004,
      1.947336,
      0.872212,
      2.564506,
      0,
      1,
      0.225565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.219307,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      1.343550,
      1.396034,
      1,
      NULL,
      NULL,
      NULL,
      3.459790,
      1.376301,
      1,
      0.732288,
      3,
      1.510819,
      0.597627,
      0.028266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708006,
      1.088838,
      1,
      0.911793,
      NULL,
      1,
      0,
      1.424592,
      0,
      1,
      NULL,
      1,
      1.465820,
      NULL,
      NULL,
      1,
      0,
      1,
      1.726882,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.865977,
      3,
      0.621340,
      0.577173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.329932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806993,
      1.103219,
      1.253901,
      0,
      1.743514,
      0,
      NULL,
      1,
      0.005326,
      NULL,
      1.054651,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.726685,
      NULL,
      1,
      NULL,
      NULL,
      0.926542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162050,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1.470154,
      1.165880,
      NULL,
      NULL,
      1.012981,
      0.279581,
      1.354498,
      3.401572,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.503879,
      3.893794,
      1.452303,
      3,
      3.936191,
      1.970959,
      1,
      NULL,
      3,
      9,
      4.212892,
      4,
      3,
      3,
      1,
      3.839874,
      0,
      1.562741,
      0,
      2.092739,
      3.880741,
      3,
      2,
      0,
      2,
      1,
      0.636235,
      0.979653,
      1,
      3.345293,
      0,
      NULL,
      NULL,
      0.406028,
      1.639644,
      0.204900,
      1.105157,
      1,
      0.647373,
      NULL,
      NULL,
      0.157764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.907745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.324066,
      0,
      NULL,
      NULL,
      1.371610,
      1,
      3.697246,
      NULL,
      7.508056,
      NULL,
      NULL,
      NULL,
      2.072100,
      NULL,
      26,
      NULL,
      2.166919,
      NULL,
      0.625427,
      NULL,
      0.536041,
      NULL,
      0,
      NULL,
      2.945153,
      1.469479,
      1,
      NULL,
      0.658395,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.871504,
      1,
      NULL,
      1.678983,
      NULL,
      NULL,
      NULL,
      0.537576,
      NULL,
      NULL,
      NULL,
      1.003088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785824,
      NULL,
      0,
      NULL,
      0,
      0.491652,
      3.891644,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.427785,
      NULL,
      NULL,
      1,
      1,
      1.475549,
      NULL,
      3,
      1.797528,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.300788,
      0.578485,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.018011,
      0.088190,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.828217,
      NULL,
      NULL,
      0,
      7.568168,
      0,
      0.032286,
      1,
      1.879349,
      0,
      NULL,
      0.655909,
      1.483125,
      NULL,
      1.128635,
      NULL,
      0.227017,
      NULL,
      NULL,
      NULL,
      1.918068,
      NULL,
      0.268957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.683702,
      1.725824,
      1,
      4,
      1,
      0.223100,
      1.537590,
      2,
      3,
      3.326736,
      1.940238,
      0,
      0.419689,
      NULL,
      1,
      1,
      0.695390,
      NULL,
      NULL,
      0,
      3.186759,
      NULL,
      3.907315,
      0,
      NULL,
      NULL,
      NULL,
      0.477050,
      1,
      1,
      NULL,
      2.739997,
      0,
      0.290038,
      1.208387,
      1.907679,
      1,
      0.951717,
      1,
      1,
      1.105206,
      NULL,
      0,
      0,
      0.128853,
      NULL,
      0.826507,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301595,
      NULL,
      0.845342,
      NULL,
      1,
      1.404328,
      3,
      2,
      1.137742,
      1.173917,
      NULL,
      NULL,
      NULL,
      11.334436,
      0,
      3,
      NULL,
      '22141',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.071595,
      NULL,
      '',
      '');
commit;
end;
/


