set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      1.704887,
      1.515053,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-15-1979',
      11,
      NULL,
      NULL,
      3,
      4.138521,
      ' 2- 3-1993',
      28,
      NULL,
      256.960641,
      102.717401,
      2,
      ' 5- 0-1988',
      ' 3- 4-1981',
      ' 0- 8-1988',
      1.293965,
      3.132409,
      3.121637,
      1,
      0.049820,
      3.303872,
      2,
      1.901845,
      1,
      0.586280,
      10.909118,
      NULL,
      0,
      6,
      3.013639,
      NULL,
      16,
      3,
      1.538140,
      1.203739,
      0,
      3.838294,
      0.120762,
      0,
      1,
      1,
      0.810139,
      1.188903,
      NULL,
      1.983699,
      0.605106,
      0.985744,
      3,
      NULL,
      1,
      4,
      1,
      2.971141,
      NULL,
      1,
      1.802884,
      1,
      1,
      0.292538,
      NULL,
      1.167532,
      1,
      NULL,
      1,
      NULL,
      0.565133,
      1.746803,
      0.216795,
      NULL,
      NULL,
      0.503453,
      NULL,
      NULL,
      1,
      0.945564,
      1.624566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095215,
      0.395180,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420668,
      1.283853,
      0,
      0.892740,
      0,
      1.716340,
      1.274995,
      0,
      NULL,
      1,
      NULL,
      1,
      1.859430,
      1,
      NULL,
      NULL,
      1.414676,
      0,
      NULL,
      1,
      1.534427,
      1.458292,
      0,
      5.102055,
      3.664359,
      0,
      1.627891,
      1,
      1.400720,
      NULL,
      1,
      0.879111,
      2.105522,
      1,
      2.436601,
      4.392214,
      1.928250,
      8.248206,
      4,
      1.870722,
      NULL,
      7,
      1.198722,
      2.459294,
      1,
      5,
      0,
      ' 1-13-1996',
      15,
      '10-20-1979',
      17,
      1,
      0,
      1.005981,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656198,
      1.268802,
      0.479822,
      1.712226,
      0.033561,
      1.121277,
      0.300655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.962415,
      0.061206,
      6.318760,
      NULL,
      3.579020,
      0.033448,
      1.842561,
      NULL,
      8,
      0.703199,
      1,
      NULL,
      NULL,
      NULL,
      1.925571,
      0.671586,
      1,
      4.861329,
      1,
      3,
      3.475073,
      NULL,
      NULL,
      NULL,
      0.506910,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.753181,
      NULL,
      3,
      0.420041,
      NULL,
      1,
      2.727617,
      3,
      NULL,
      0.352214,
      NULL,
      NULL,
      NULL,
      2,
      0.624585,
      1.914324,
      0,
      NULL,
      3.634285,
      NULL,
      2.511757,
      1.196973,
      2.122799,
      0.278526,
      NULL,
      0.006540,
      0,
      3,
      0.808293,
      NULL,
      0,
      1.122556,
      NULL,
      0.861247,
      0,
      1,
      0.427013,
      NULL,
      1.917106,
      1,
      NULL,
      NULL,
      NULL,
      0.959772,
      NULL,
      9.083718,
      1.802351,
      6.205900,
      11,
      NULL,
      3,
      5.674823,
      NULL,
      NULL,
      0,
      3.818031,
      2.455574,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      23.352769,
      NULL,
      5,
      0,
      3,
      '23133',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      38.429914,
      32,
      10.231285,
      NULL,
      29,
      NULL,
      0.445406,
      2.751063,
      3,
      NULL,
      2.086538,
      1.677665,
      NULL,
      NULL,
      3.921803,
      2,
      3.594223,
      3,
      0,
      1.975216,
      1,
      NULL,
      NULL,
      0.072748,
      NULL,
      NULL,
      0,
      2,
      3.581797,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.141203,
      NULL,
      NULL,
      1.272817,
      NULL,
      NULL,
      7.353142,
      NULL,
      4,
      1.460215,
      0,
      1.619974,
      2.114567,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.418100,
      NULL,
      NULL,
      0.699760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140523,
      NULL,
      NULL,
      3,
      2.579815,
      1.591855,
      1.740925,
      0,
      0,
      1.664864,
      NULL,
      NULL,
      NULL,
      5,
      1.404968,
      1,
      NULL,
      NULL,
      0.648812,
      NULL,
      NULL,
      0.746658,
      NULL,
      NULL,
      0.327746,
      NULL,
      NULL,
      1.400098,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.352887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000495,
      NULL,
      NULL,
      3.613755,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      7.833688,
      0,
      0.251454,
      NULL,
      NULL,
      1.012638,
      1.535528,
      1,
      NULL,
      2.074122,
      NULL,
      3,
      2,
      1.397494,
      1.327930,
      NULL,
      6.572065,
      3.871753,
      3.095211,
      3,
      NULL,
      NULL,
      NULL,
      2.582959,
      2.320226,
      NULL,
      NULL,
      0,
      0.178980,
      2,
      11.610171,
      NULL,
      5,
      6.641536,
      0,
      2.905471,
      0.224788,
      NULL,
      2.748764,
      NULL,
      1.722439,
      1,
      0.794819,
      NULL,
      NULL,
      3.213778,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404988,
      NULL,
      NULL,
      1,
      0.049389,
      NULL,
      0.117110,
      1.014872,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.764950,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057904,
      NULL,
      NULL,
      0.233178,
      0.729993,
      NULL,
      0.360680,
      1.071866,
      NULL,
      2.978289,
      0,
      NULL,
      2.731300,
      NULL,
      1,
      0,
      1.405979,
      1.058287,
      NULL,
      1,
      2,
      1.573516,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.425016,
      NULL,
      1,
      1.477790,
      1.264776,
      NULL,
      NULL,
      NULL,
      0.602179,
      NULL,
      NULL,
      NULL,
      3.976623,
      NULL,
      0,
      0,
      1.979209,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.693956,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.488863,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.989270,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.306287,
      1,
      NULL,
      NULL,
      0.585251,
      15,
      NULL,
      0,
      1.631405,
      0,
      NULL,
      3.229746,
      3.090008,
      5.168437,
      0.340811,
      2,
      4,
      1,
      1,
      NULL,
      1.250776,
      0,
      NULL,
      NULL,
      0,
      12,
      0.426520,
      0,
      11,
      1.223020,
      1.339517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.100856,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.320472,
      0.200714,
      0,
      NULL,
      1.406248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.063183,
      3,
      6,
      1,
      3,
      2.981926,
      3,
      NULL,
      3.796874,
      NULL,
      NULL,
      1,
      1.942663,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.787569,
      NULL,
      1.295067,
      2.943870,
      NULL,
      0.763480,
      1.749309,
      0.377679,
      NULL,
      0.119158,
      1.377700,
      1.514937,
      1.555228,
      0,
      1.992025,
      NULL,
      0,
      0.163871,
      0.578639,
      0.332843,
      2.302385,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.848593,
      0,
      0,
      1.424837,
      1,
      4.619932,
      1,
      1.688439,
      NULL,
      NULL,
      119.336288,
      58,
      3,
      0,
      1,
      '12241',
      NULL,
      '',
      0.499338,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


