set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '2323344',
      0,
      1,
      0,
      2,
      '0213',
      3.912335,
      0,
      NULL,
      NULL,
      NULL,
      20.745457,
      NULL,
      2.993223,
      1.106289,
      1.468904,
      '10- 4-1999',
      8.361811,
      2,
      98.920865,
      144,
      2,
      ' 5-21-1986',
      ' 6-21-2003',
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      1.477821,
      0.872127,
      0,
      0,
      NULL,
      NULL,
      1,
      2.293081,
      15,
      13,
      4.200817,
      24.813212,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.178766,
      1.162278,
      0,
      1.520589,
      NULL,
      1.829734,
      0,
      0,
      2,
      3,
      3,
      0.171298,
      1.585348,
      9,
      NULL,
      0.112192,
      0,
      NULL,
      1.168147,
      1.656287,
      1.718043,
      0,
      NULL,
      NULL,
      NULL,
      2.439561,
      NULL,
      NULL,
      1.958409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.010879,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.341548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.880612,
      1.263113,
      1,
      1,
      1.869835,
      0,
      1.779720,
      0,
      0.337294,
      NULL,
      0.840922,
      NULL,
      1.604792,
      1,
      1.234239,
      0,
      NULL,
      0.722501,
      NULL,
      1,
      4.810478,
      0,
      0,
      1.411924,
      0.710111,
      0,
      0.149405,
      1,
      9.129684,
      4,
      0.680054,
      3.832347,
      4,
      0.610437,
      4.780927,
      NULL,
      NULL,
      NULL,
      4,
      6.504763,
      NULL,
      5,
      6,
      1,
      1.370137,
      1,
      1.698884,
      ' 5- 7-1991',
      NULL,
      NULL,
      14.931660,
      3,
      0.894450,
      0,
      3,
      1.806249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.366138,
      1,
      3.192968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.774155,
      1,
      1.425297,
      0.025920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187934,
      4,
      4.527789,
      NULL,
      0.742911,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.956051,
      0.811128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.588053,
      1,
      NULL,
      0,
      0,
      0.833824,
      NULL,
      25,
      0.630490,
      1.887366,
      NULL,
      NULL,
      NULL,
      1.322153,
      NULL,
      1.541653,
      0,
      2,
      1,
      2.817581,
      3.872813,
      NULL,
      2.805408,
      1,
      0,
      3,
      NULL,
      1.928221,
      2,
      4.809289,
      0.767179,
      1,
      0,
      NULL,
      0,
      1.124225,
      0,
      1.449444,
      0.434636,
      NULL,
      0,
      2,
      2.481559,
      0.939340,
      0,
      4,
      NULL,
      NULL,
      4.464857,
      0.293609,
      3,
      NULL,
      0,
      4.376773,
      2.619852,
      0,
      1,
      NULL,
      0,
      1.282407,
      NULL,
      11.514567,
      55,
      11,
      4.245554,
      5.287371,
      NULL,
      '31404',
      '',
      '',
      0,
      '',
      '',
      '',
      0.662732,
      '',
      '',
      '',
      0.739374,
      13,
      19,
      29.161299,
      2,
      18.397247,
      NULL,
      8.159887,
      2,
      NULL,
      0.918808,
      0.653998,
      0.839286,
      NULL,
      NULL,
      NULL,
      1,
      0.367483,
      NULL,
      1,
      1,
      1.041348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.695526,
      NULL,
      NULL,
      1.304670,
      NULL,
      NULL,
      8.673328,
      9,
      NULL,
      1.130778,
      NULL,
      1,
      0,
      0.219922,
      1.838179,
      1.734599,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.529571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.966778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642039,
      NULL,
      NULL,
      3.924351,
      0.699700,
      0.115332,
      3.362364,
      2,
      1.545763,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.309285,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.449501,
      NULL,
      NULL,
      0.687508,
      NULL,
      NULL,
      1.988281,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.361339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.495024,
      0,
      NULL,
      NULL,
      7,
      2.811639,
      5,
      3,
      1,
      2.762396,
      0,
      NULL,
      NULL,
      0,
      3.480739,
      3,
      3,
      NULL,
      1.759321,
      NULL,
      3.060206,
      3.934543,
      0,
      5,
      5,
      2,
      0.421645,
      2.735459,
      0,
      NULL,
      NULL,
      2.649214,
      2.071490,
      0.718003,
      0,
      3,
      3.020733,
      6,
      6,
      NULL,
      6.924605,
      0,
      NULL,
      3,
      5,
      1,
      3.903489,
      NULL,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      3.474211,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526460,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.472673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.916546,
      NULL,
      0,
      0.575538,
      NULL,
      1.552097,
      1.946976,
      NULL,
      3.122192,
      1,
      NULL,
      0,
      0.786837,
      NULL,
      2.749357,
      NULL,
      NULL,
      3,
      1,
      NULL,
      7,
      0.921431,
      NULL,
      0.033341,
      1.405719,
      2.483354,
      3.875174,
      NULL,
      NULL,
      1.331983,
      3,
      NULL,
      NULL,
      3.583391,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.491735,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.238112,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.450647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.569352,
      0,
      1,
      NULL,
      1.046432,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2.981319,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.395900,
      1.043332,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1.543406,
      NULL,
      1,
      0,
      3.227582,
      NULL,
      NULL,
      NULL,
      0.774949,
      NULL,
      1.629620,
      NULL,
      NULL,
      NULL,
      2.937894,
      0.217978,
      4.246284,
      NULL,
      3,
      NULL,
      NULL,
      0.527572,
      NULL,
      10,
      NULL,
      1.577853,
      NULL,
      10.881736,
      1,
      NULL,
      NULL,
      0,
      45.641463,
      3,
      2.155615,
      50,
      2,
      1.074211,
      NULL,
      NULL,
      0.231267,
      12.442411,
      0.259898,
      198.610869,
      0.636598,
      1.928483,
      1,
      1,
      1.979723,
      1.393828,
      1.954070,
      NULL,
      NULL,
      1.410011,
      0,
      0,
      1.914880,
      NULL,
      1.661071,
      0.654854,
      1.500623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.342990,
      0,
      8.076003,
      2.342479,
      4.972813,
      0,
      3,
      0.844200,
      1,
      3,
      2.934195,
      1.150223,
      0.772224,
      1,
      1.270558,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1.698994,
      1.675358,
      0,
      0.885414,
      1.832462,
      3,
      0,
      0,
      0.069564,
      0.997538,
      1.380311,
      1,
      1,
      NULL,
      NULL,
      0.717984,
      NULL,
      1.065014,
      3,
      NULL,
      NULL,
      0.616431,
      2,
      1.113883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952215,
      NULL,
      1.104178,
      1,
      1.789915,
      NULL,
      4,
      4.231821,
      6,
      1.395664,
      NULL,
      NULL,
      NULL,
      88,
      2.211848,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0.194023,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


