set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0114098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      9,
      0,
      8,
      7.163143,
      2.385651,
      1.548413,
      1.439003,
      2,
      '442',
      '32121012',
      37,
      19,
      '3243422',
      NULL,
      0.191661,
      1,
      NULL,
      '1313',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.388262,
      63.694659,
      NULL,
      2,
      3,
      ' 2-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '10-15-1975',
      NULL,
      ' 6-22-1980',
      2.916778,
      NULL,
      2,
      NULL,
      1.708342,
      3,
      2,
      NULL,
      0.831606,
      NULL,
      NULL,
      1.844138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.550164,
      NULL,
      0.856124,
      1,
      1,
      1.554205,
      1.338880,
      NULL,
      1.521527,
      0.676018,
      3.107271,
      1.473594,
      1,
      0,
      6.173090,
      NULL,
      2.292461,
      NULL,
      1.277781,
      NULL,
      1.332077,
      1,
      NULL,
      4.185393,
      0.712398,
      0.476317,
      3.636456,
      0.400865,
      0.697539,
      7.621821,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.716401,
      NULL,
      NULL,
      0.837827,
      0,
      0.271678,
      2.169640,
      0.207629,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.464336,
      0.330367,
      0,
      0,
      3,
      0.342029,
      5,
      4.071833,
      2.112879,
      5,
      0.591856,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.614038,
      0,
      0,
      1,
      5,
      4,
      1,
      0.349102,
      4,
      4,
      NULL,
      0,
      0.519137,
      1.088976,
      0.914851,
      NULL,
      1.405775,
      NULL,
      NULL,
      0.119295,
      0,
      0,
      4.259924,
      0,
      1.218421,
      1,
      5.657829,
      1,
      0,
      6.232662,
      1,
      NULL,
      4.521233,
      0.852142,
      0,
      7,
      7,
      2,
      5,
      3,
      NULL,
      2,
      NULL,
      3,
      NULL,
      6,
      0,
      ' 8-18-1980',
      253,
      NULL,
      98.118561,
      NULL,
      1.695320,
      3.398824,
      NULL,
      0.247596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.561065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707016,
      NULL,
      8.124338,
      3.456964,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.456404,
      NULL,
      3.511637,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      1.204915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.138489,
      NULL,
      NULL,
      2,
      6,
      1,
      0.204558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.219482,
      0.822653,
      1,
      1.624708,
      0,
      3,
      NULL,
      NULL,
      2.271051,
      3.975171,
      1.251106,
      3.517011,
      NULL,
      0,
      0.625215,
      1.488727,
      2.112372,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.748038,
      0.908640,
      0.589045,
      0,
      2.233064,
      1,
      1,
      8,
      5,
      4.322269,
      9.494871,
      0,
      1.104136,
      2,
      NULL,
      NULL,
      0.063682,
      3,
      17.563668,
      3.301419,
      0.352362,
      42.824883,
      NULL,
      9.704825,
      33.386244,
      0,
      5,
      5.044537,
      '20023',
      '10322',
      '',
      3.516185,
      NULL,
      '',
      '',
      0.735800,
      '0402',
      NULL,
      '',
      3,
      19.078498,
      106,
      NULL,
      1.402578,
      0.468048,
      3.644678,
      1,
      2,
      3.425124,
      2.759890,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915130,
      NULL,
      NULL,
      3.645403,
      0.785587,
      3,
      2,
      3.148981,
      3.707046,
      0,
      NULL,
      NULL,
      1.752302,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.291000,
      NULL,
      NULL,
      0.930901,
      NULL,
      NULL,
      NULL,
      2,
      0.656090,
      1.148436,
      0.652086,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.910913,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      1.649840,
      1,
      2,
      1,
      NULL,
      0.944500,
      3.717244,
      2.886415,
      0.601516,
      1,
      1.718867,
      1.506273,
      NULL,
      NULL,
      0.941416,
      1,
      NULL,
      NULL,
      NULL,
      1.456182,
      2.716153,
      NULL,
      5,
      0,
      1,
      NULL,
      1.749337,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.193636,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.555420,
      3.428257,
      0,
      0.363736,
      0,
      NULL,
      NULL,
      0.169319,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.248086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.302309,
      NULL,
      NULL,
      2.734997,
      6,
      0.338512,
      NULL,
      NULL,
      NULL,
      0,
      1.105040,
      0,
      2.858987,
      0.548840,
      0,
      1.118017,
      0.008779,
      1,
      7,
      2.779826,
      1.640763,
      NULL,
      1,
      NULL,
      2.411729,
      3.827083,
      1,
      2,
      3,
      1,
      1.875410,
      3,
      0,
      0,
      9,
      5,
      5,
      2.993245,
      3.615630,
      3.043235,
      NULL,
      7,
      0.984802,
      0.208995,
      1,
      NULL,
      1,
      3.894252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218508,
      NULL,
      NULL,
      1.629770,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.930038,
      NULL,
      NULL,
      3.701454,
      NULL,
      NULL,
      0,
      2.202439,
      1.352475,
      0,
      0.401345,
      3,
      1.008523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042511,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.831512,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      1.561962,
      3,
      0.881347,
      0,
      1,
      3,
      NULL,
      1.285612,
      0.588312,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.838693,
      NULL,
      NULL,
      1.798053,
      NULL,
      NULL,
      0,
      NULL,
      0,
      144.734169,
      3.120130,
      0,
      0.312058,
      NULL,
      0,
      NULL,
      0.977384,
      1.114179,
      0.926334,
      1.790488,
      1,
      NULL,
      NULL,
      NULL,
      1.264010,
      NULL,
      1,
      0.244363,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933625,
      0.965003,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413142,
      NULL,
      1.125334,
      NULL,
      1.193662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.990674,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.568993,
      NULL,
      1.297731,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.843227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.190248,
      1.149726,
      NULL,
      NULL,
      0.171667,
      NULL,
      180.654831,
      NULL,
      2.907474,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      25,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      1,
      3,
      0.938432,
      NULL,
      9.401383,
      1,
      3.653784,
      0,
      1.806785,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0.577757,
      NULL,
      1,
      1.487605,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.077923,
      NULL,
      0.249475,
      0,
      NULL,
      0.196374,
      1.930270,
      NULL,
      1,
      2,
      NULL,
      1.567694,
      0.729568,
      NULL,
      3.123666,
      0,
      1.654585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437837,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810860,
      3,
      '23433',
      '10412',
      '2122',
      NULL,
      '43334',
      '',
      NULL,
      3,
      '30003',
      '3323',
      NULL);
commit;
end;
/


