set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8011440';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3224240',
      3.782773,
      0.992905,
      0,
      2,
      '0121',
      0.499667,
      0,
      NULL,
      NULL,
      '11-20-1977',
      0.681347,
      NULL,
      1,
      1.075279,
      1.073657,
      ' 6-18-1989',
      62.456809,
      2,
      108.905820,
      21,
      NULL,
      ' 6-27-1980',
      ' 3-15-1983',
      ' 6-19-1996',
      NULL,
      3.873493,
      1.523668,
      NULL,
      0.797261,
      0,
      3.233542,
      1.604921,
      1,
      NULL,
      9.955073,
      6.601258,
      7,
      4.701958,
      NULL,
      7,
      NULL,
      0,
      NULL,
      7.062127,
      1,
      0.206989,
      0,
      NULL,
      NULL,
      1.611616,
      0.091800,
      NULL,
      1,
      0,
      153,
      6,
      0.554070,
      2.901103,
      1.259754,
      4,
      0.255414,
      1,
      NULL,
      0.771734,
      1.706541,
      5,
      0.941159,
      2.121835,
      4,
      0,
      8.446878,
      2.094499,
      1.103644,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.555423,
      NULL,
      NULL,
      NULL,
      2,
      6,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1.165944,
      0,
      0.260855,
      1,
      2,
      3,
      3.807695,
      NULL,
      1,
      0,
      1,
      11.467907,
      1.550727,
      5.999883,
      3.991694,
      0.538892,
      NULL,
      NULL,
      1.954422,
      NULL,
      NULL,
      NULL,
      2.116447,
      NULL,
      0.763616,
      NULL,
      3.311223,
      0,
      3,
      2.427201,
      1.927455,
      NULL,
      0.013615,
      1,
      0,
      1.982560,
      1.805698,
      1.983735,
      0,
      1.828996,
      NULL,
      0.098760,
      1,
      1,
      4.466790,
      1,
      0.409429,
      3.148614,
      NULL,
      NULL,
      1.008945,
      0.924303,
      5.582337,
      0,
      NULL,
      0.312411,
      8,
      11.767604,
      3,
      NULL,
      5.767591,
      11,
      4,
      7,
      1.412313,
      NULL,
      11,
      9,
      1.988882,
      ' 4-19-1990',
      989,
      ' 9-22-1980',
      NULL,
      0,
      1,
      0.450668,
      6.215523,
      1.552061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.754251,
      NULL,
      0.048148,
      0.008798,
      0.089165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.144584,
      NULL,
      4.142011,
      0.788300,
      1.576252,
      5,
      NULL,
      0,
      3.846095,
      1,
      0.046955,
      7,
      0.798146,
      2,
      1.295859,
      2.685347,
      0,
      1.699525,
      1.090089,
      NULL,
      4,
      5.320577,
      0.327453,
      1.436692,
      NULL,
      NULL,
      NULL,
      NULL,
      6.860172,
      1.235090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      0.096253,
      NULL,
      NULL,
      0,
      NULL,
      1.930053,
      1.937225,
      NULL,
      NULL,
      NULL,
      1.750232,
      0.576209,
      3,
      1,
      0,
      0,
      3,
      NULL,
      1.931986,
      0,
      1.401203,
      0.375699,
      1,
      1,
      2.081539,
      2.370084,
      5,
      0,
      0,
      0.424370,
      0,
      1.931719,
      NULL,
      0.068920,
      0.426275,
      0,
      NULL,
      0,
      1,
      1,
      1.931443,
      0.083923,
      NULL,
      NULL,
      7,
      6,
      8,
      NULL,
      3.132176,
      3.577326,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.036174,
      NULL,
      NULL,
      4.984329,
      22,
      44,
      2.308346,
      0,
      3.592096,
      '33220',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1.483330,
      '',
      '',
      '',
      NULL,
      11.334173,
      271,
      NULL,
      2,
      20,
      43,
      72,
      10.395996,
      NULL,
      NULL,
      1.492757,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.600498,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      2.039340,
      3,
      1.990865,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678128,
      NULL,
      1,
      1.410753,
      3.125207,
      1,
      NULL,
      NULL,
      NULL,
      1.267064,
      0.530778,
      8,
      8,
      7.889473,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.791952,
      NULL,
      1.685618,
      2,
      0,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      0.136379,
      3,
      0,
      0.057219,
      2,
      0,
      1,
      NULL,
      NULL,
      1.744272,
      3.733027,
      1.582703,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378265,
      0.969958,
      NULL,
      3.513175,
      10,
      1.646767,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.319773,
      0,
      2.012146,
      1.617780,
      NULL,
      NULL,
      3.925854,
      3,
      NULL,
      0,
      NULL,
      NULL,
      8.468611,
      NULL,
      4.363703,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      0.406439,
      0,
      4,
      0.436986,
      NULL,
      NULL,
      1.311614,
      NULL,
      NULL,
      1.908379,
      NULL,
      NULL,
      0.257331,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.848212,
      1,
      1,
      NULL,
      5.852639,
      5.681671,
      2.511340,
      1,
      3,
      NULL,
      4,
      3.998477,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      1.998437,
      1,
      3.576784,
      2.894969,
      5,
      3,
      2,
      3,
      0.140317,
      NULL,
      1.952351,
      NULL,
      0.256673,
      3.289586,
      1,
      3,
      1,
      5.033844,
      NULL,
      NULL,
      1.851450,
      2,
      5,
      2.501069,
      1.188750,
      9.180335,
      0.811264,
      0.023613,
      1,
      1,
      0,
      0.296399,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.841183,
      NULL,
      NULL,
      1.686134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.055143,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.333562,
      NULL,
      NULL,
      0.622099,
      NULL,
      NULL,
      0.423769,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573835,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886586,
      0,
      1,
      NULL,
      0.202487,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621876,
      NULL,
      NULL,
      NULL,
      0.702837,
      NULL,
      NULL,
      NULL,
      3.665366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.978840,
      NULL,
      NULL,
      NULL,
      2.636512,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.060670,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.089351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      7,
      1.821945,
      3,
      146,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      9.009115,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      59.087685,
      NULL,
      368,
      65.280897,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      0.131907,
      NULL,
      0.014226,
      3,
      NULL,
      1.953854,
      0,
      1,
      NULL,
      1.293374,
      1,
      2.230006,
      NULL,
      2.361660,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.389052,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.009356,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981377,
      NULL,
      2,
      NULL,
      0.379137,
      NULL,
      NULL,
      NULL,
      1.451154,
      0.828787,
      0,
      NULL,
      1.244157,
      NULL,
      0.574950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.574434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823181,
      NULL,
      NULL,
      0,
      0.456698,
      1,
      2,
      2.635960,
      5.610705,
      1,
      0.929776,
      0.646805,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.592376,
      NULL,
      0,
      0.487868,
      NULL,
      1,
      2.925974,
      NULL,
      0.367893,
      0,
      NULL,
      2.952503,
      3.784003,
      NULL,
      0.511071,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.471476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.399535,
      NULL,
      7.589223,
      NULL,
      2,
      0.228704,
      0,
      2.997421,
      NULL,
      NULL,
      1.256691,
      0,
      2.427928,
      '02123',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1.166056,
      '',
      '',
      NULL);
commit;
end;
/


