set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1231332',
      1,
      1,
      NULL,
      3,
      '3042',
      2.059643,
      0,
      NULL,
      NULL,
      ' 4-27-2003',
      158.649135,
      NULL,
      1,
      1,
      0.750958,
      '10- 9-1986',
      NULL,
      0,
      184.357607,
      69.275568,
      2.981861,
      '11- 0-1986',
      '10-11-1991',
      '11-14-1978',
      NULL,
      3.845051,
      0.686029,
      NULL,
      1.434200,
      NULL,
      1.380083,
      0.778038,
      0,
      NULL,
      3.538059,
      10.600855,
      6.259717,
      18.397937,
      24.478748,
      1,
      1,
      3,
      NULL,
      NULL,
      1.245736,
      3.249069,
      1.764332,
      0,
      1.034198,
      1,
      0,
      1.910868,
      1.501773,
      1,
      1,
      NULL,
      3.553152,
      5,
      0.202864,
      3.949368,
      7,
      0.545220,
      6,
      0,
      3,
      6.441228,
      1,
      8.240908,
      0.976696,
      1,
      0,
      NULL,
      1.957347,
      2.245925,
      NULL,
      NULL,
      1.771869,
      NULL,
      NULL,
      0.704615,
      NULL,
      NULL,
      0,
      1,
      0.050278,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478063,
      NULL,
      0.569077,
      1.997112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.071707,
      0.163287,
      5.200862,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      1,
      7.366326,
      1.301194,
      NULL,
      3,
      1.087343,
      NULL,
      1.659133,
      0.286178,
      0,
      NULL,
      0,
      1.667957,
      1,
      1,
      1,
      0,
      NULL,
      0.961201,
      5.031779,
      2.717331,
      NULL,
      0.849220,
      1.979996,
      5.826917,
      NULL,
      0,
      2.083816,
      3,
      NULL,
      3.533027,
      NULL,
      3,
      1.448350,
      3.365528,
      NULL,
      3.420750,
      0,
      1.097678,
      ' 5- 8-1989',
      NULL,
      '11- 3-1997',
      NULL,
      3.027543,
      0,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      1.323140,
      0,
      NULL,
      NULL,
      8.791330,
      NULL,
      1,
      0.586647,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.650872,
      NULL,
      0,
      1.936531,
      3,
      1.221739,
      1.116502,
      2.552529,
      0.413447,
      0,
      3,
      1.669373,
      1.293218,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.461873,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911690,
      1.815863,
      1.276552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.577894,
      NULL,
      NULL,
      3.643604,
      132,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.019759,
      1.002344,
      1.208740,
      1.222606,
      1,
      NULL,
      0.712378,
      0.616321,
      0.853496,
      3,
      2,
      2,
      NULL,
      NULL,
      0.795798,
      NULL,
      1,
      1,
      0.753441,
      0,
      1,
      1,
      0.628852,
      0,
      0,
      1,
      1,
      0.077882,
      0,
      NULL,
      1.204511,
      8.784994,
      4,
      7.948923,
      8.117468,
      2.120406,
      3.115786,
      2,
      2.784253,
      7.340572,
      0,
      2,
      0,
      24,
      2.935738,
      3.874656,
      NULL,
      41.532406,
      NULL,
      64.851745,
      3,
      4.263301,
      0.853205,
      '14224',
      '',
      NULL,
      0.072515,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      41.744901,
      123.933509,
      0.381260,
      1.970722,
      24.228757,
      NULL,
      4.009182,
      5,
      3.281677,
      0,
      2.722225,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693552,
      NULL,
      0,
      1.108259,
      1.140751,
      NULL,
      NULL,
      0,
      3.134560,
      3.464838,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      0.682030,
      NULL,
      NULL,
      0.723880,
      NULL,
      NULL,
      4,
      1.764550,
      1,
      1.034297,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.666054,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713528,
      NULL,
      NULL,
      1.271567,
      NULL,
      NULL,
      0.812018,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.785295,
      1.866434,
      NULL,
      NULL,
      NULL,
      0,
      2.246042,
      1.444042,
      NULL,
      NULL,
      6.673709,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.573713,
      0,
      0.256027,
      1,
      NULL,
      1.222234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399882,
      NULL,
      NULL,
      1.406084,
      NULL,
      NULL,
      3,
      1,
      1,
      2.139413,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574483,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3,
      3.352562,
      NULL,
      3.557316,
      0.757888,
      0.250804,
      3.407809,
      0.529340,
      2.430657,
      0.499593,
      0.799086,
      NULL,
      2.146356,
      NULL,
      2,
      3.835720,
      0,
      3.942505,
      3.110474,
      0,
      2,
      3.008633,
      1.997848,
      3.350600,
      0.521858,
      2.494231,
      0.557703,
      1,
      5.619104,
      7,
      NULL,
      NULL,
      1.373986,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.191860,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3.996755,
      NULL,
      NULL,
      9.433071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.124635,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.304285,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.939400,
      NULL,
      NULL,
      1.471829,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382412,
      NULL,
      0.310881,
      0,
      1.686413,
      2,
      1.053785,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      77.019937,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.200784,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.764557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.906009,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.696129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.148686,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.049898,
      2.349956,
      NULL,
      NULL,
      14.310086,
      0.987027,
      13.416765,
      21.358138,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.446716,
      0.000907,
      NULL,
      NULL,
      0.852536,
      NULL,
      NULL,
      0,
      NULL,
      1,
      22.639468,
      1.075570,
      1.860468,
      1.114686,
      1,
      0.281377,
      1.822788,
      1,
      0.225906,
      0.669157,
      1,
      NULL,
      NULL,
      1.496944,
      1,
      1.840705,
      0.717053,
      1,
      0,
      0.229535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.206546,
      0,
      0.344103,
      NULL,
      2.114543,
      1.451743,
      3.355066,
      0,
      0.181291,
      0.731537,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      3.593819,
      3.643422,
      NULL,
      NULL,
      0.996320,
      NULL,
      1,
      1,
      NULL,
      1,
      1.749531,
      NULL,
      2.741965,
      0.435362,
      NULL,
      1,
      1,
      NULL,
      1.879367,
      0,
      NULL,
      2,
      1.044847,
      NULL,
      0.571831,
      1.892446,
      NULL,
      2.365121,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406927,
      NULL,
      0.447514,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.107797,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.487157,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.511997,
      NULL,
      NULL,
      1.774788,
      33,
      0,
      NULL,
      NULL,
      NULL,
      0.208546,
      NULL,
      7,
      1.219509,
      NULL,
      NULL,
      NULL,
      NULL,
      41.890956,
      NULL,
      NULL,
      1.102338,
      0,
      '31224',
      '',
      '',
      1.477652,
      '',
      '',
      '',
      1.615061,
      '',
      '',
      '');
commit;
end;
/


