set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678466';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      '13',
      8.175453,
      16,
      '2323241',
      0,
      0,
      2,
      2,
      '3030',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      7,
      NULL,
      0,
      1.275974,
      ' 8- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 7-20-1976',
      ' 8-10-2003',
      '11- 0-1998',
      3.340815,
      2.164475,
      0,
      NULL,
      1.047411,
      0.755280,
      2,
      0,
      1,
      NULL,
      0.117677,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      9.879064,
      0.517430,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.853969,
      1,
      1.676350,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.447259,
      2.804017,
      0,
      5.599647,
      NULL,
      1.260968,
      1.239350,
      NULL,
      NULL,
      0.569909,
      NULL,
      NULL,
      1,
      NULL,
      0.635770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      5,
      NULL,
      1,
      0.891271,
      0.146834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.325870,
      6,
      7.005146,
      0.779896,
      3.529492,
      1.766379,
      7,
      0,
      NULL,
      0,
      2.166194,
      0.123120,
      1.072922,
      3.616140,
      1,
      NULL,
      1.434965,
      1.677515,
      1.459429,
      NULL,
      0.172493,
      1.645447,
      0.406128,
      0.998470,
      NULL,
      2.288868,
      0.840751,
      1,
      1.009222,
      1.198422,
      1,
      1,
      NULL,
      0.621773,
      1,
      6.777753,
      9.651931,
      0.733383,
      3,
      5,
      2,
      3,
      7,
      7,
      1.325623,
      2,
      6,
      0,
      '11-28-1984',
      305,
      ' 3- 7-1987',
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.030761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.695287,
      3.204104,
      1.013852,
      NULL,
      4,
      5,
      0,
      2.804666,
      1.233714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.456344,
      0.392717,
      0.172769,
      1.949667,
      NULL,
      1.968909,
      0,
      NULL,
      NULL,
      NULL,
      0.975925,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.391619,
      1.581203,
      1,
      1,
      3.777780,
      17,
      1,
      1.538870,
      NULL,
      NULL,
      NULL,
      2.531044,
      1,
      0.642304,
      NULL,
      2.033455,
      1,
      0.592979,
      0.274841,
      2.215299,
      3,
      3,
      2.364405,
      0,
      1,
      NULL,
      2,
      3.005330,
      1,
      0.630141,
      1.404798,
      1.862530,
      1.843737,
      NULL,
      NULL,
      0.277480,
      1.784020,
      1,
      1.926321,
      NULL,
      0.402510,
      NULL,
      NULL,
      4.643460,
      9,
      1.512315,
      9.368714,
      8.054767,
      3.263240,
      0.787901,
      3,
      6.163640,
      2.554357,
      0,
      1,
      67.601285,
      1,
      0.971882,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451804,
      3,
      3,
      '41410',
      '41324',
      '',
      NULL,
      '',
      NULL,
      '',
      0.525551,
      NULL,
      NULL,
      '',
      1.210186,
      31.687012,
      NULL,
      19.816401,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.629428,
      1.548831,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.334706,
      NULL,
      1.510566,
      NULL,
      NULL,
      2.532308,
      2,
      0.622224,
      1.377469,
      1.570527,
      1.402370,
      1.497505,
      NULL,
      NULL,
      0.537350,
      NULL,
      NULL,
      1.609880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566067,
      NULL,
      NULL,
      8.705483,
      3,
      6.476430,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.025134,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.934206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.116364,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.110659,
      NULL,
      NULL,
      1,
      NULL,
      0.100411,
      1,
      1.910756,
      0,
      1.109758,
      NULL,
      NULL,
      2,
      1.698446,
      1,
      1.004657,
      1.221949,
      0,
      3.591977,
      2.455060,
      0,
      0.944886,
      0.048971,
      2.472356,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.076493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374666,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.004390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.908491,
      0,
      1.679747,
      0.157660,
      1,
      0.834020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.001776,
      1.155191,
      0,
      0.124711,
      3.156056,
      1,
      1.459796,
      3.482840,
      1,
      1,
      9,
      1,
      0,
      6.129703,
      1,
      NULL,
      2,
      NULL,
      2.549078,
      0.143017,
      0.911113,
      1.758471,
      0.011948,
      0.028689,
      NULL,
      NULL,
      NULL,
      0.074061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.286555,
      NULL,
      NULL,
      1.066079,
      NULL,
      NULL,
      0.383289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.220803,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.921710,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.991704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.734484,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.672090,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567067,
      NULL,
      NULL,
      NULL,
      0.712870,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.263729,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.463713,
      NULL,
      1,
      1,
      13.372023,
      1.170866,
      NULL,
      0.577267,
      NULL,
      1.352061,
      1.000684,
      1.352566,
      1.974527,
      NULL,
      1.662989,
      NULL,
      1.016552,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839844,
      1.209687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.977996,
      NULL,
      1,
      1,
      152.280014,
      NULL,
      1,
      0,
      NULL,
      1,
      1.220757,
      1.669004,
      0.494878,
      1.059214,
      41.513745,
      32.599145,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.744661,
      1,
      1,
      1,
      2.952464,
      1,
      3,
      2.578293,
      2.869047,
      1,
      0.576172,
      1.682920,
      NULL,
      0.591482,
      0,
      NULL,
      1.428297,
      1.391417,
      NULL,
      1.138696,
      0.694593,
      NULL,
      1,
      1,
      NULL,
      0,
      1.148262,
      NULL,
      0.699396,
      1,
      NULL,
      1,
      0.550413,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.497731,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.252062,
      NULL,
      1,
      NULL,
      NULL,
      5.654469,
      11.181699,
      2.076600,
      NULL,
      2,
      0,
      32,
      3,
      3,
      4.595148,
      NULL,
      '34110',
      '',
      0.000347,
      NULL,
      '',
      '',
      2,
      NULL,
      '',
      '');
commit;
end;
/


