set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      '2103',
      NULL,
      0.106656,
      NULL,
      NULL,
      ' 9-21-1999',
      140.090924,
      NULL,
      4,
      NULL,
      0.843907,
      '10- 1-1997',
      1.815364,
      5.118129,
      289,
      40.945684,
      0.176533,
      ' 6- 5-1986',
      ' 9-26-1982',
      ' 8- 9-1999',
      NULL,
      3.476000,
      2.420021,
      1.926688,
      0,
      1.620194,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      14,
      0,
      3.798889,
      14,
      0.052983,
      2.001182,
      8.004501,
      1,
      NULL,
      NULL,
      1.458600,
      1.315673,
      0.027030,
      1,
      0,
      NULL,
      0,
      1.827177,
      1,
      4.631700,
      5.480637,
      0.086472,
      7.783911,
      1.582919,
      1.041679,
      1.972801,
      0,
      NULL,
      0,
      1,
      0.876675,
      0,
      0,
      1.814827,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.133544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.829592,
      3,
      0.746667,
      1.076820,
      2.105152,
      2.345556,
      2,
      2,
      0.124748,
      0.169565,
      0,
      NULL,
      0.619477,
      NULL,
      NULL,
      3.479385,
      2.545065,
      1.725910,
      1.472502,
      1,
      8.202301,
      NULL,
      5,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427239,
      0.000202,
      0.742205,
      6,
      NULL,
      0.166718,
      NULL,
      0,
      1,
      0.280472,
      NULL,
      7.945357,
      0.013246,
      5,
      1.535251,
      NULL,
      0.876241,
      0,
      2.954796,
      NULL,
      NULL,
      3,
      1.912669,
      0.053642,
      3,
      1,
      8.589021,
      6.299720,
      0,
      1,
      4.581234,
      0.379172,
      NULL,
      5,
      3.959271,
      NULL,
      3.993588,
      1,
      1,
      NULL,
      5,
      9,
      4.549172,
      5,
      NULL,
      NULL,
      7,
      2.737540,
      '10- 3-1983',
      883,
      NULL,
      199,
      3.119776,
      1,
      1.133298,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.163908,
      1.213209,
      NULL,
      NULL,
      1,
      0,
      0.653937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403156,
      1.384223,
      1.803226,
      1.618326,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649401,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1.466326,
      0,
      NULL,
      0.420220,
      2,
      2,
      NULL,
      1.544410,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.335078,
      NULL,
      NULL,
      NULL,
      2,
      3.499301,
      2,
      NULL,
      0,
      1,
      0.576008,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      1.404432,
      0,
      1.331012,
      0,
      NULL,
      0,
      1,
      0.269105,
      0,
      NULL,
      1,
      NULL,
      2,
      8.097161,
      7,
      8,
      0,
      5.990942,
      1,
      3,
      4.097343,
      NULL,
      2,
      1.309681,
      NULL,
      0.307285,
      2.845049,
      NULL,
      5,
      23,
      22,
      4.390297,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.439331,
      '13440',
      '',
      NULL,
      3.519910,
      17.788360,
      8,
      9,
      0,
      4,
      2,
      NULL,
      0.901581,
      1.391438,
      0.467949,
      2,
      1,
      NULL,
      NULL,
      0.451982,
      NULL,
      NULL,
      0.182962,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.217657,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      1.225877,
      1,
      NULL,
      NULL,
      0.281479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.184500,
      NULL,
      NULL,
      5.535068,
      7,
      NULL,
      1,
      0.044793,
      NULL,
      NULL,
      NULL,
      0.641387,
      NULL,
      NULL,
      NULL,
      3.984031,
      3.802872,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774132,
      NULL,
      1.845254,
      0.066568,
      NULL,
      0.345429,
      1.083172,
      NULL,
      1,
      2,
      0,
      3,
      3,
      0.067614,
      NULL,
      NULL,
      NULL,
      1.365080,
      NULL,
      NULL,
      0.191454,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.442852,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.008396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.038717,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585881,
      NULL,
      NULL,
      0.083235,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.113174,
      NULL,
      NULL,
      0.018053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.447985,
      NULL,
      NULL,
      2.235931,
      2.252467,
      2,
      0.064390,
      NULL,
      NULL,
      NULL,
      3.240728,
      5,
      NULL,
      NULL,
      3,
      1.880548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.572874,
      1.163054,
      NULL,
      NULL,
      5,
      7,
      NULL,
      0.802246,
      1.777702,
      3,
      0,
      1.042106,
      0,
      NULL,
      3.255583,
      NULL,
      1.737103,
      3,
      NULL,
      5,
      2.821880,
      4.475238,
      1.810308,
      NULL,
      NULL,
      NULL,
      1,
      4.267640,
      1.689728,
      0.072700,
      1.419566,
      1.824146,
      1.517103,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466487,
      NULL,
      NULL,
      0.925655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.785576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146874,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685600,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.632431,
      NULL,
      NULL,
      0.046126,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.291388,
      0,
      NULL,
      NULL,
      0,
      0.999754,
      NULL,
      NULL,
      0.210498,
      2.724387,
      NULL,
      NULL,
      0.446671,
      1,
      NULL,
      NULL,
      5.339939,
      1,
      NULL,
      NULL,
      1.858632,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      13,
      1.769298,
      NULL,
      NULL,
      1.660642,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.279698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.575118,
      1.775989,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1.779499,
      0.068289,
      0,
      1,
      1,
      NULL,
      0,
      1.232086,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.314599,
      3.937139,
      NULL,
      2.429841,
      3,
      0,
      2.602708,
      NULL,
      2.739940,
      NULL,
      0,
      1.719524,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1.115716,
      NULL,
      NULL,
      0,
      0.142955,
      NULL,
      2,
      3,
      3,
      0.812829,
      0.523408,
      2.555990,
      1.813687,
      3,
      0.526689,
      1.835722,
      1.572740,
      3.147795,
      1.444474,
      1.755579,
      0.505623,
      1,
      2.407520,
      0.167549,
      0,
      1,
      0.321625,
      3,
      1.322492,
      0.854552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.051175,
      NULL,
      0,
      11,
      NULL,
      3,
      0.771685,
      3.323135,
      33,
      42.454944,
      1,
      5.512375,
      0,
      '22440',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.016267,
      '20011',
      '',
      '');
commit;
end;
/


