set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      NULL,
      5,
      '3344220',
      3.433980,
      NULL,
      1,
      2,
      '2110',
      4,
      1.786436,
      NULL,
      NULL,
      NULL,
      75.375593,
      5,
      NULL,
      3,
      0.333837,
      ' 3- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '11-16-1991',
      ' 1-23-1983',
      0.315011,
      0,
      2,
      0,
      1.963247,
      1.197748,
      2,
      NULL,
      1.323380,
      1118,
      8,
      5,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.545643,
      1.450886,
      0,
      NULL,
      0,
      1.224431,
      NULL,
      1,
      1,
      0,
      NULL,
      10.692779,
      6,
      NULL,
      3.853468,
      9.074599,
      0,
      NULL,
      NULL,
      3,
      3.204362,
      NULL,
      4,
      1.791949,
      0,
      1.107250,
      NULL,
      1.576948,
      1.905251,
      3,
      NULL,
      5,
      0.087794,
      NULL,
      NULL,
      1.081944,
      NULL,
      NULL,
      7.404461,
      1.513738,
      2.813981,
      1.083753,
      0,
      0.421043,
      0.757697,
      0.355945,
      1,
      3,
      0.133814,
      0,
      0.334867,
      NULL,
      1,
      1.304605,
      0,
      NULL,
      1,
      6,
      NULL,
      2.647446,
      6.709563,
      0,
      0,
      2.256757,
      NULL,
      NULL,
      NULL,
      0.934354,
      NULL,
      NULL,
      1.944071,
      3.787627,
      2,
      0.462636,
      4,
      1.991516,
      0.440527,
      1.842516,
      NULL,
      0.014781,
      NULL,
      0.219421,
      NULL,
      1.656958,
      0.088761,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0.997706,
      0,
      0.884456,
      3,
      2.948718,
      7,
      0.366165,
      7,
      1.976548,
      4.584590,
      0.130525,
      NULL,
      NULL,
      1.579532,
      3,
      NULL,
      6.234998,
      7.231743,
      0,
      1,
      9,
      3,
      NULL,
      NULL,
      0.772968,
      1,
      ' 6-28-1983',
      2174.464209,
      ' 0-12-1977',
      536,
      3.213365,
      1.177096,
      1.449356,
      0.765868,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043659,
      1.906803,
      10,
      0,
      6.085158,
      0.458882,
      9.876081,
      1.786197,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      NULL,
      1.765970,
      NULL,
      NULL,
      NULL,
      1.234744,
      3.049264,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.834102,
      NULL,
      NULL,
      1.659237,
      0,
      0,
      5931.002155,
      0,
      1.015700,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3.554387,
      3.144224,
      3,
      0.823410,
      NULL,
      0.771506,
      1,
      2.362314,
      1,
      1.750450,
      2.483066,
      0,
      NULL,
      0,
      4.065805,
      1.430474,
      0.331082,
      1.107830,
      NULL,
      1.316430,
      1.679500,
      1.883185,
      0.744355,
      0.119188,
      0.014833,
      0.598285,
      1.411071,
      5.105797,
      8,
      0.572321,
      NULL,
      4.244108,
      4,
      4,
      NULL,
      1.096679,
      2.540267,
      1.722690,
      3.977201,
      11.776634,
      NULL,
      3,
      42,
      NULL,
      46.250192,
      10.914733,
      1.089654,
      3.520772,
      0,
      '12223',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      2,
      '43432',
      '',
      '',
      1.914263,
      NULL,
      NULL,
      NULL,
      0.074133,
      46,
      8.744216,
      47,
      10,
      NULL,
      3,
      1.255655,
      1.691652,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.804341,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.112782,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.627881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588928,
      NULL,
      NULL,
      1.494960,
      2.042714,
      4.699761,
      0.180846,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.451412,
      0,
      1,
      1.135493,
      NULL,
      3.734185,
      2.826475,
      0,
      NULL,
      1.945826,
      2,
      NULL,
      0.090431,
      0,
      1,
      3,
      2.158304,
      1,
      3.667095,
      2.737565,
      1,
      0,
      1.679597,
      1.015859,
      NULL,
      0.092194,
      NULL,
      NULL,
      0.305760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.751706,
      1.818192,
      1.263343,
      1.344812,
      1.301251,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      0,
      0,
      NULL,
      2.584093,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      3,
      3.862683,
      1,
      0,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.526725,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.754755,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.565336,
      NULL,
      NULL,
      0.900177,
      NULL,
      NULL,
      0.206123,
      NULL,
      NULL,
      3.110853,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.463306,
      1,
      3,
      0,
      0.273542,
      3,
      2,
      2.274477,
      1,
      8,
      1.077769,
      5,
      0,
      0.675844,
      1.561822,
      0,
      1,
      1,
      1,
      0.108789,
      0.652004,
      NULL,
      1.038739,
      2,
      9,
      1.564401,
      NULL,
      5.561867,
      3,
      NULL,
      1.967658,
      7,
      8,
      NULL,
      NULL,
      1.454639,
      0.507730,
      1.515263,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449739,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.521879,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      0.308830,
      0.334813,
      1.815575,
      1.238860,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.948262,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.314714,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.335085,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.329433,
      307.322505,
      60883.752849,
      1.404344,
      32,
      1264,
      NULL,
      NULL,
      NULL,
      2.248704,
      178,
      11477,
      1,
      NULL,
      NULL,
      NULL,
      15.591339,
      5629,
      0.628518,
      NULL,
      NULL,
      44.994369,
      NULL,
      0.849015,
      0.550050,
      NULL,
      1,
      1.440715,
      0.308564,
      0,
      1,
      1.849693,
      0.572200,
      NULL,
      0,
      1.339249,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.297799,
      1,
      4.011657,
      5,
      2.153342,
      2.051339,
      1.673494,
      3.514170,
      0,
      1.121049,
      1.858868,
      NULL,
      1.712507,
      3,
      NULL,
      3.789129,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2.109785,
      NULL,
      0.956096,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704752,
      3.932156,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995507,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      13.906907,
      NULL,
      NULL,
      1,
      0.514553,
      12,
      2,
      5,
      4.755130,
      1,
      '11043',
      '',
      '',
      1.453248,
      '',
      '',
      NULL,
      3,
      '21013',
      '',
      NULL);
commit;
end;
/


