set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7713617';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0414113',
      1.422248,
      0.842866,
      1,
      1,
      '2042',
      2.913717,
      0.865978,
      NULL,
      NULL,
      ' 2- 5-2001',
      9.044023,
      NULL,
      0.641727,
      0,
      0,
      ' 8- 3-1976',
      22,
      1,
      269,
      89,
      1,
      NULL,
      ' 4- 0-1986',
      NULL,
      3.081424,
      NULL,
      0,
      1,
      1.391928,
      1.040864,
      2.925675,
      NULL,
      1.974939,
      NULL,
      2.614071,
      6.558023,
      0,
      73.388587,
      34,
      NULL,
      0.089285,
      0,
      NULL,
      4,
      1,
      0.206123,
      NULL,
      0.092436,
      1.190397,
      NULL,
      1,
      1,
      0.192988,
      1,
      29,
      9.332950,
      5,
      5.389088,
      2.250078,
      3.691050,
      1,
      1,
      NULL,
      1,
      0,
      4,
      NULL,
      NULL,
      0.799954,
      1,
      1.282758,
      NULL,
      0.477687,
      3.092537,
      2.394064,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640358,
      NULL,
      NULL,
      5.733891,
      1,
      1,
      1.759462,
      NULL,
      0.560263,
      NULL,
      NULL,
      0.970253,
      2,
      NULL,
      0.482997,
      NULL,
      1,
      3.440103,
      2.841599,
      0.941483,
      0,
      1.515242,
      0,
      1,
      1,
      2.469256,
      1,
      4,
      0.925841,
      1.958579,
      NULL,
      NULL,
      1.491666,
      NULL,
      NULL,
      1,
      1.348696,
      0,
      1.623189,
      0,
      NULL,
      0.363675,
      1,
      1,
      NULL,
      1,
      0.476076,
      NULL,
      1,
      1.492237,
      1.495689,
      NULL,
      0.934283,
      1.175824,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0.060541,
      NULL,
      0.778208,
      0,
      1.278489,
      0,
      1.860637,
      2,
      0,
      1.474859,
      0,
      7.273216,
      5,
      NULL,
      4,
      NULL,
      2.093140,
      10.536710,
      1.844869,
      NULL,
      NULL,
      1.597475,
      2.123274,
      '10-12-1998',
      1926,
      NULL,
      262.390612,
      NULL,
      NULL,
      1,
      6.130854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.327210,
      NULL,
      1,
      0.778079,
      0,
      1.729645,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690596,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.401858,
      2.562019,
      0.772488,
      NULL,
      0.673683,
      0,
      1.106730,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.801765,
      1.717834,
      0,
      1.968294,
      1,
      2,
      656,
      0.043570,
      1.159026,
      NULL,
      NULL,
      NULL,
      3.877517,
      0.378178,
      1,
      NULL,
      NULL,
      3.810196,
      0.431408,
      5.709619,
      2.583151,
      NULL,
      0.773369,
      4.110315,
      0,
      NULL,
      7,
      2.914932,
      NULL,
      127,
      86.328326,
      178,
      41.399236,
      177,
      0,
      0.543394,
      1.153323,
      1.828528,
      0.495436,
      0,
      NULL,
      8,
      3,
      1.457251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.621048,
      NULL,
      27,
      NULL,
      61,
      0.027642,
      0.219069,
      0,
      '32120',
      '',
      NULL,
      0.021969,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.584839,
      9,
      346,
      43,
      1,
      48,
      1.420793,
      23.899521,
      1.866815,
      0.694930,
      2.713961,
      0.513889,
      NULL,
      3.273941,
      1,
      0,
      NULL,
      NULL,
      1.490318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228074,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.282644,
      2.508996,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.312076,
      1,
      1.504828,
      0.920576,
      NULL,
      NULL,
      3.712047,
      NULL,
      1,
      0.033890,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.025081,
      0.616531,
      0.153642,
      3,
      NULL,
      1.572152,
      0.210953,
      NULL,
      0,
      NULL,
      NULL,
      1.094760,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8.213402,
      NULL,
      6,
      1.639871,
      1.228790,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.036814,
      1.987144,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.790913,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.964908,
      NULL,
      NULL,
      1.391135,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.739771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108177,
      NULL,
      NULL,
      1.430988,
      NULL,
      NULL,
      3,
      0,
      5.826322,
      3.590342,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.921871,
      0.091740,
      2,
      1,
      NULL,
      7,
      NULL,
      3,
      0.125228,
      0.691099,
      3,
      3,
      NULL,
      0.750135,
      0.568463,
      0.877978,
      0.991143,
      3.098601,
      1,
      1,
      1,
      7,
      2,
      8.945714,
      2.933201,
      0.566817,
      0.125499,
      NULL,
      0,
      0.074627,
      0.331333,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527459,
      NULL,
      NULL,
      4.109342,
      NULL,
      NULL,
      1.982162,
      0,
      NULL,
      0.036543,
      1.210020,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.977735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222505,
      NULL,
      NULL,
      NULL,
      0.361985,
      NULL,
      NULL,
      NULL,
      3.721031,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.486878,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134135,
      NULL,
      NULL,
      1,
      0.295980,
      NULL,
      NULL,
      0.649076,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.500817,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.187725,
      NULL,
      NULL,
      11333.781957,
      NULL,
      0,
      1,
      0,
      0.815976,
      0,
      1.211714,
      0,
      NULL,
      1,
      0,
      0.721438,
      1,
      NULL,
      1,
      1.912999,
      0,
      0.802232,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      4.755534,
      NULL,
      NULL,
      5,
      2,
      1,
      1.004735,
      10,
      10,
      NULL,
      7,
      8.963057,
      NULL,
      15.663214,
      11.377461,
      NULL,
      9.350466,
      NULL,
      NULL,
      18.051651,
      17,
      NULL,
      8,
      11.489251,
      NULL,
      6,
      NULL,
      NULL,
      17,
      7.684799,
      NULL,
      0.056539,
      1.392784,
      NULL,
      1,
      13.094435,
      NULL,
      13.299338,
      12,
      NULL,
      0,
      1.488839,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584116,
      NULL,
      0,
      NULL,
      1.709047,
      NULL,
      NULL,
      10.324165,
      3.671228,
      0,
      0.168566,
      3,
      23,
      10.832214,
      7.132061,
      0.952585,
      0,
      '44203',
      NULL,
      '',
      0.733010,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


