set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7713617';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '40',
      0.440521,
      8,
      '2443223',
      2,
      1.193456,
      2,
      2,
      '3301',
      2,
      0.920319,
      NULL,
      NULL,
      ' 9-21-1981',
      153,
      6.698144,
      NULL,
      3,
      0,
      ' 2-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1997',
      NULL,
      0.295228,
      1,
      NULL,
      0,
      1.148216,
      NULL,
      0,
      1.618334,
      1.334662,
      59.826123,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.309256,
      0.373891,
      1.397445,
      0.285265,
      0.875355,
      0.757058,
      0,
      1,
      184.984241,
      10.553739,
      NULL,
      1.047924,
      1.213796,
      5,
      1,
      5,
      0,
      1.396111,
      7,
      1,
      1,
      8,
      1.394222,
      NULL,
      NULL,
      6,
      0,
      NULL,
      2.082769,
      3,
      0,
      NULL,
      NULL,
      0.967798,
      NULL,
      NULL,
      11,
      7.232788,
      3,
      1,
      1,
      0.608584,
      0,
      3.685129,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      3,
      0.598266,
      NULL,
      1,
      8,
      0,
      3.039540,
      4.179631,
      0,
      NULL,
      4,
      0.311001,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.835003,
      0.657010,
      0.540752,
      NULL,
      NULL,
      1,
      0,
      0.217050,
      0.059661,
      1,
      0.036954,
      0.999783,
      0.613930,
      1,
      1.978502,
      2.039542,
      0.969827,
      0,
      1,
      NULL,
      1.938878,
      1.830969,
      1.295293,
      1,
      0.097601,
      1.873480,
      1.242739,
      NULL,
      0.686724,
      0.695344,
      2,
      2,
      0.496371,
      3.600171,
      1.826395,
      8,
      6,
      1.352415,
      8,
      3.449811,
      2.101142,
      8,
      1,
      6,
      0,
      3.879410,
      7,
      1.064524,
      ' 9- 1-1996',
      1683,
      '11-26-1994',
      610.970216,
      2.507294,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353106,
      NULL,
      1,
      0.364854,
      NULL,
      NULL,
      0.888144,
      1.080087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355408,
      NULL,
      2,
      0.427411,
      0.435326,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.221839,
      0.887003,
      3.503544,
      3,
      NULL,
      2.082975,
      NULL,
      NULL,
      1,
      0,
      0.131782,
      5.563267,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401999,
      2,
      0.320876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.833100,
      NULL,
      0,
      1.987968,
      0,
      0,
      0,
      8128,
      0.497782,
      0,
      NULL,
      NULL,
      NULL,
      0.216228,
      1,
      1.379769,
      2.717844,
      1,
      NULL,
      5.971646,
      NULL,
      NULL,
      2.117266,
      2,
      5.481380,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.382468,
      NULL,
      0.942267,
      1,
      NULL,
      2,
      0.865617,
      NULL,
      1,
      0,
      0.673983,
      0,
      1,
      NULL,
      1,
      5.921081,
      NULL,
      1.523083,
      0,
      9,
      4.425534,
      NULL,
      3,
      1,
      2.441631,
      3,
      1,
      22.623483,
      0.097534,
      NULL,
      16.549003,
      NULL,
      62,
      58,
      NULL,
      1,
      2.947421,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.864682,
      '',
      '',
      '',
      1.571899,
      NULL,
      180,
      NULL,
      1.684530,
      6.492139,
      3,
      31.562733,
      11.333383,
      0.598291,
      1,
      1,
      NULL,
      0,
      0.907737,
      0.408866,
      NULL,
      NULL,
      2,
      0.183477,
      2,
      1,
      NULL,
      NULL,
      3.045850,
      0,
      0.752742,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.718995,
      NULL,
      1,
      3,
      1,
      0,
      0.582130,
      0,
      0,
      2,
      1.499082,
      0,
      3,
      1.735054,
      5,
      1.488829,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.133627,
      1,
      NULL,
      0,
      2,
      NULL,
      2.082163,
      3,
      1,
      1,
      0,
      1.147883,
      0.147636,
      0,
      1,
      NULL,
      1,
      2,
      2,
      0,
      0.450656,
      1.554301,
      0.024839,
      3.671202,
      1,
      1.375162,
      NULL,
      0,
      NULL,
      2.909443,
      0,
      NULL,
      8.057048,
      2,
      2,
      0.575107,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.816088,
      NULL,
      NULL,
      2,
      2.747899,
      NULL,
      0,
      NULL,
      NULL,
      6.974436,
      1,
      4,
      0,
      NULL,
      NULL,
      1.250988,
      NULL,
      NULL,
      0.529586,
      NULL,
      NULL,
      1.410971,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.279628,
      NULL,
      NULL,
      1.675265,
      NULL,
      NULL,
      1.660597,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.401768,
      2.544813,
      3.072314,
      3.544850,
      NULL,
      NULL,
      2.080207,
      NULL,
      1,
      2,
      0,
      3,
      NULL,
      3,
      NULL,
      9.200600,
      NULL,
      0.859113,
      2,
      2,
      2.079269,
      3,
      0,
      NULL,
      1.192966,
      2.730284,
      2.081483,
      0,
      0.318362,
      3,
      9,
      8.282106,
      4.615804,
      7,
      2.771326,
      NULL,
      2,
      NULL,
      9,
      1,
      0,
      0,
      1.018154,
      1.011031,
      2.308907,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618983,
      NULL,
      NULL,
      1.728759,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.501528,
      NULL,
      NULL,
      3.196310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586323,
      0,
      1,
      0.294607,
      1,
      0.818602,
      0,
      NULL,
      NULL,
      2.035312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.059333,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.294138,
      NULL,
      NULL,
      NULL,
      0.990496,
      NULL,
      NULL,
      NULL,
      3.892083,
      NULL,
      NULL,
      NULL,
      0.408208,
      NULL,
      NULL,
      NULL,
      1.622509,
      NULL,
      NULL,
      NULL,
      5.211969,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9,
      NULL,
      NULL,
      155,
      309,
      0.530790,
      132,
      16,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.066188,
      NULL,
      NULL,
      1.604533,
      NULL,
      NULL,
      NULL,
      56.987304,
      1,
      NULL,
      53,
      0.361653,
      1.178130,
      0.273234,
      NULL,
      1,
      1.665073,
      0.828858,
      1.178737,
      0,
      0.017538,
      1.625704,
      0.499768,
      1.084218,
      1.149708,
      NULL,
      NULL,
      0.271782,
      0.532327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.237545,
      NULL,
      NULL,
      4.648641,
      0,
      0.131053,
      10.604181,
      1.835637,
      2,
      0.100266,
      0.851168,
      0.824025,
      NULL,
      NULL,
      1.384251,
      NULL,
      0.144810,
      2.496796,
      NULL,
      0.398324,
      0.102756,
      NULL,
      1,
      1,
      NULL,
      1,
      0.684493,
      NULL,
      1.979633,
      3,
      NULL,
      NULL,
      1.457301,
      NULL,
      NULL,
      2,
      NULL,
      1.263386,
      2,
      NULL,
      1,
      0.364854,
      NULL,
      3.558993,
      NULL,
      1.895178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.384583,
      NULL,
      1,
      NULL,
      4.706261,
      NULL,
      2.133789,
      0.323344,
      0.128194,
      0,
      68.510386,
      14.373829,
      4,
      4.201500,
      NULL,
      '33003',
      '',
      '',
      0.132450,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


