set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.168713,
      2.814255,
      1,
      2,
      0,
      3,
      2,
      0,
      NULL,
      '32444102',
      72,
      66,
      NULL,
      1.173197,
      1.648568,
      6,
      0,
      NULL,
      1.619174,
      0.230771,
      NULL,
      NULL,
      ' 8- 2-1982',
      52,
      34.783371,
      NULL,
      NULL,
      2.326173,
      ' 8- 4-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 0-1984',
      0.161468,
      1.665333,
      1.816172,
      1,
      0.215749,
      1.458913,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.093773,
      NULL,
      1,
      NULL,
      NULL,
      0.380915,
      NULL,
      1,
      1.303797,
      1,
      0.476606,
      NULL,
      1,
      3.197785,
      3,
      0,
      2.833748,
      6,
      0.239098,
      0,
      1,
      1.383994,
      NULL,
      7,
      1,
      0.297308,
      1,
      0.237892,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.282781,
      NULL,
      NULL,
      1.484138,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.083408,
      0,
      NULL,
      0,
      1,
      0.488367,
      1,
      3,
      3,
      3,
      1.986196,
      1.037994,
      NULL,
      0.050634,
      0,
      1.852323,
      0,
      2.581620,
      3.647074,
      2,
      0,
      1.018741,
      1,
      1,
      NULL,
      NULL,
      0.848484,
      NULL,
      NULL,
      0,
      5,
      3,
      1.614474,
      0,
      0,
      0.185439,
      0.909094,
      0,
      0,
      1.960834,
      NULL,
      0.860543,
      NULL,
      NULL,
      0.552642,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1.301067,
      0.130152,
      1.645829,
      1,
      0,
      NULL,
      0,
      0.678667,
      0,
      1.641781,
      0.761018,
      1,
      1.443351,
      0,
      NULL,
      NULL,
      7,
      2.748509,
      1,
      1,
      4,
      NULL,
      0,
      0,
      0.163668,
      ' 0- 0-1982',
      137.000193,
      ' 4- 6-1992',
      11,
      NULL,
      NULL,
      0.972536,
      3,
      1.341516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918742,
      1,
      0,
      1,
      1,
      3.231974,
      4,
      1.709307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536842,
      NULL,
      1.446866,
      NULL,
      NULL,
      NULL,
      5,
      0.228555,
      6,
      0.265021,
      3.167925,
      NULL,
      1.121080,
      NULL,
      NULL,
      NULL,
      0.176881,
      3,
      0.278743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.944144,
      0.757004,
      0,
      0.064489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1.929330,
      NULL,
      0.889694,
      1,
      NULL,
      3,
      0.793274,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      1.041642,
      1.662038,
      NULL,
      1,
      0.037951,
      NULL,
      NULL,
      NULL,
      1.271943,
      0.043731,
      NULL,
      NULL,
      1.436832,
      7,
      2.328407,
      3.239935,
      NULL,
      8,
      0,
      3.225891,
      2.639369,
      6.101517,
      2.526299,
      1.080816,
      0.699374,
      34.847355,
      3.089795,
      0.358666,
      72,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      '41100',
      '41222',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3.175343,
      8,
      22.263453,
      30.663894,
      0.439878,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.916507,
      2,
      1.954201,
      NULL,
      NULL,
      1.046547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.694250,
      2.267591,
      3,
      1.151652,
      NULL,
      NULL,
      0.745472,
      NULL,
      NULL,
      1.867354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668002,
      NULL,
      NULL,
      6,
      4,
      2,
      1.869554,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      0.111040,
      1.930676,
      3,
      0.042881,
      NULL,
      0.333996,
      2,
      2.564870,
      0.216882,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.586946,
      3.789733,
      0,
      0.601828,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242209,
      3.456814,
      1.381197,
      NULL,
      3.674596,
      0,
      0.524637,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.983459,
      NULL,
      NULL,
      2.317524,
      1,
      3,
      0.018077,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1.059247,
      2.188738,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896637,
      NULL,
      NULL,
      0.460177,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.008638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.377132,
      NULL,
      NULL,
      1.337314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.213193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.527591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.724290,
      NULL,
      1.099269,
      5.999312,
      0,
      1,
      NULL,
      0.676333,
      0,
      3.309983,
      NULL,
      NULL,
      0.008575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123415,
      NULL,
      NULL,
      1.097289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555352,
      NULL,
      NULL,
      1.233715,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934481,
      NULL,
      NULL,
      1.933487,
      1.121963,
      1.987742,
      1.956576,
      0,
      2.309968,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.102373,
      NULL,
      NULL,
      NULL,
      1.838661,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.580238,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.635104,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.229600,
      NULL,
      1,
      378.111375,
      9.525090,
      1.231825,
      1,
      3,
      0,
      0.211164,
      1,
      NULL,
      1.350517,
      3.907275,
      1.906770,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      3.620225,
      0,
      1.025659,
      NULL,
      0.252271,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      45,
      NULL,
      1.915953,
      NULL,
      30,
      NULL,
      0,
      1.123467,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.847203,
      NULL,
      0,
      NULL,
      1.773896,
      NULL,
      1,
      NULL,
      3.658679,
      NULL,
      0.278443,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1.151162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.445364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.809681,
      NULL,
      3.131500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.556322,
      1,
      2.820956,
      NULL,
      1.812969,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.172159,
      1.045929,
      12.142992,
      17.991440,
      1.246030,
      NULL,
      NULL,
      NULL,
      0.665566,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0,
      3,
      0.000116,
      1.691007,
      1.978073,
      NULL,
      0.459807,
      NULL,
      NULL,
      0.987377,
      2,
      NULL,
      3,
      2.534955,
      NULL,
      1,
      1.358975,
      NULL,
      0,
      0,
      NULL,
      1.500045,
      1.101834,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.549823,
      NULL,
      1.991961,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.064750,
      NULL,
      0.169100,
      1,
      NULL,
      NULL,
      9.842547,
      54.902308,
      NULL,
      3,
      5.366211,
      '40002',
      '00322',
      '23230',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


