set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2302100',
      1.549521,
      1.222645,
      0,
      0,
      NULL,
      1.833424,
      NULL,
      NULL,
      NULL,
      '11- 4-1999',
      3.821978,
      NULL,
      0.000863,
      NULL,
      0,
      ' 6-15-1997',
      NULL,
      2.108108,
      233,
      57,
      1.072722,
      ' 9-12-1997',
      ' 6- 8-2003',
      ' 2-24-1999',
      NULL,
      0.653088,
      2.880186,
      NULL,
      1.700648,
      3,
      2,
      NULL,
      0,
      15,
      9.253832,
      NULL,
      7,
      193.773841,
      137,
      16,
      24,
      0.715005,
      4,
      6,
      NULL,
      1,
      0,
      1,
      1.827424,
      1.097275,
      NULL,
      0,
      1.147480,
      NULL,
      0,
      2.484368,
      2,
      0,
      1.839442,
      6,
      1,
      1.565728,
      3,
      1.004255,
      1.321479,
      2,
      0,
      0.676365,
      0,
      0,
      0.268759,
      2,
      0,
      NULL,
      3,
      0.806829,
      0.990598,
      NULL,
      NULL,
      1.267523,
      NULL,
      NULL,
      7.263119,
      8.836652,
      1.836931,
      0,
      1,
      0.740080,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0.045387,
      1,
      3.030858,
      0.260496,
      1.726571,
      10.138352,
      NULL,
      2,
      0,
      1.260461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302570,
      6.553912,
      0.456268,
      0.768165,
      1.208131,
      NULL,
      0,
      1,
      0,
      0,
      0.311173,
      0,
      0,
      1,
      1,
      1.318424,
      0,
      NULL,
      1,
      NULL,
      0.547334,
      3,
      6.579675,
      NULL,
      1.566831,
      0,
      4.771759,
      6.221454,
      1.055447,
      3,
      0.168668,
      0,
      3,
      7.335150,
      1,
      2.540806,
      8.913435,
      4.033471,
      0.420438,
      9,
      2,
      2,
      8.902973,
      8,
      1.035130,
      0.549659,
      0,
      3,
      ' 0-26-1999',
      313.818651,
      ' 9-25-1993',
      NULL,
      3,
      1.117902,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064015,
      NULL,
      0.871686,
      0.971414,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0.888959,
      1.700979,
      1.731907,
      0,
      NULL,
      NULL,
      NULL,
      0.545693,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400185,
      1.555413,
      0.204961,
      NULL,
      1.192735,
      0,
      3,
      4,
      1.950527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9.939160,
      7.153762,
      6.803675,
      3,
      7,
      1,
      5.423379,
      1.349916,
      5,
      3.395471,
      0.442633,
      2.220655,
      NULL,
      0.034006,
      3,
      NULL,
      NULL,
      NULL,
      6.920368,
      1.955322,
      1.209265,
      3.792700,
      '30012',
      '32302',
      '14410',
      NULL,
      '',
      NULL,
      NULL,
      3,
      NULL,
      '',
      '',
      2,
      5,
      208.338973,
      24,
      2,
      13.667295,
      12,
      2.308127,
      1,
      2.381737,
      0.486548,
      0,
      1.420405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.454955,
      1.218571,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.017631,
      3,
      0.688080,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.232827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1.946927,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.544280,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.930890,
      NULL,
      3,
      1,
      1.288133,
      1,
      3.938098,
      2.334502,
      2,
      2,
      1.577210,
      NULL,
      1,
      0,
      0,
      1,
      2,
      0,
      0.972825,
      1.316099,
      14,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11.592698,
      8.068297,
      7.092972,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.894047,
      NULL,
      NULL,
      NULL,
      1.508255,
      NULL,
      NULL,
      NULL,
      0,
      3.911292,
      1,
      NULL,
      NULL,
      0.801908,
      NULL,
      NULL,
      6,
      NULL,
      5.125936,
      2,
      0.450857,
      3,
      1,
      NULL,
      NULL,
      6,
      NULL,
      6,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.786411,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.350142,
      NULL,
      NULL,
      1.290166,
      NULL,
      NULL,
      2,
      3.430242,
      NULL,
      3.219234,
      2,
      1,
      0.756823,
      1.884189,
      NULL,
      8.059427,
      6.976157,
      7.340881,
      3,
      NULL,
      NULL,
      2,
      3.959993,
      2.189786,
      NULL,
      2,
      0.525683,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      2.830205,
      NULL,
      3,
      NULL,
      NULL,
      3.908062,
      6.330075,
      8,
      0.385183,
      0.962811,
      0.547246,
      NULL,
      NULL,
      3.092835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640796,
      NULL,
      NULL,
      0.429419,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.270953,
      NULL,
      NULL,
      1.858938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078949,
      NULL,
      NULL,
      0.944619,
      0.844973,
      NULL,
      1.183259,
      1.019565,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302661,
      NULL,
      NULL,
      NULL,
      2.523332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.576182,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.711284,
      NULL,
      NULL,
      NULL,
      0.845176,
      NULL,
      79,
      1,
      801.723009,
      1452,
      1,
      NULL,
      NULL,
      1.559982,
      NULL,
      NULL,
      NULL,
      NULL,
      136.571742,
      3.409222,
      533,
      1478.253063,
      NULL,
      NULL,
      NULL,
      14083,
      1122.345275,
      1,
      2.731920,
      0,
      2.384476,
      NULL,
      0.975304,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1.272525,
      1,
      NULL,
      NULL,
      1.456743,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.594122,
      NULL,
      0,
      NULL,
      0.969277,
      NULL,
      NULL,
      NULL,
      0.811269,
      14.264638,
      26.294139,
      0.936840,
      NULL,
      NULL,
      NULL,
      0.025318,
      NULL,
      0.582287,
      NULL,
      1.716165,
      NULL,
      1.933785,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.657413,
      NULL,
      0.118219,
      NULL,
      0.407799,
      NULL,
      1.080987,
      NULL,
      NULL,
      NULL,
      1.490898,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605606,
      0.436291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567741,
      0.811203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.048974,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.611662,
      1,
      3.607332,
      NULL,
      0.869156,
      NULL,
      1.581718,
      NULL,
      474.791133,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      15.395348,
      39.282503,
      0,
      NULL,
      NULL,
      NULL,
      5,
      3.338450,
      5.888746,
      NULL,
      4.449110,
      5,
      3,
      3.712284,
      13,
      0.468209,
      NULL,
      1.779728,
      12.018969,
      5.899351,
      NULL,
      8,
      0.831287,
      NULL,
      6,
      19,
      NULL,
      12.081322,
      3.892413,
      NULL,
      19,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      4.282984,
      NULL,
      NULL,
      5,
      10,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      10.025312,
      NULL,
      12,
      12.046126,
      NULL,
      0.666024,
      0.402984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      8,
      3.655119,
      3.419376,
      NULL,
      5.413137,
      15.774542,
      0.080608,
      NULL,
      6.541230,
      '31304',
      '24310',
      '20434',
      0.447491,
      '',
      '',
      '',
      0.664323,
      '224',
      '',
      '');
commit;
end;
/


