set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '2442412',
      3,
      1.593267,
      NULL,
      0,
      '2202',
      0,
      NULL,
      NULL,
      NULL,
      ' 0-27-2002',
      NULL,
      NULL,
      4.826277,
      NULL,
      NULL,
      ' 2-11-1975',
      NULL,
      NULL,
      90.103081,
      NULL,
      2.557212,
      '10- 6-1984',
      ' 9- 8-1982',
      ' 7-21-1985',
      2,
      3,
      NULL,
      1,
      1,
      1.811453,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      12,
      5,
      5.941327,
      21.986978,
      3,
      2.950982,
      9,
      0.166518,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1.752233,
      1.846099,
      1,
      2.609465,
      5.265812,
      3.688537,
      2,
      9.562466,
      0.388903,
      1,
      2,
      0,
      1,
      5,
      3.059821,
      3,
      0,
      6.957625,
      0,
      NULL,
      1.726191,
      2.803374,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.242814,
      NULL,
      NULL,
      NULL,
      3.563994,
      7.904452,
      1,
      1.055187,
      NULL,
      1,
      3,
      0.589085,
      NULL,
      1,
      1.642366,
      0.928657,
      3,
      NULL,
      0.830167,
      1,
      2,
      3.781114,
      10.270583,
      3.073704,
      1,
      0.130180,
      0,
      1,
      2.631987,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.948320,
      1,
      5.941942,
      5,
      3,
      0,
      2,
      2.436447,
      1,
      1.508155,
      0,
      5,
      1.745549,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.969802,
      4.489050,
      2.251517,
      3,
      5,
      4.440712,
      NULL,
      4,
      NULL,
      1.250690,
      4.922492,
      3.802723,
      NULL,
      5,
      0,
      7,
      8,
      2.302160,
      0.454539,
      9.953566,
      4.520424,
      NULL,
      2.227112,
      1.488288,
      NULL,
      NULL,
      NULL,
      14.183108,
      NULL,
      1,
      1,
      1.766004,
      0.323738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552691,
      1.207333,
      1,
      0.389456,
      NULL,
      NULL,
      1.801809,
      1.335787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      13.672626,
      NULL,
      1.691809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      5,
      7.293115,
      3,
      5,
      2.133478,
      1.480270,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.804392,
      1,
      1.307319,
      1.202779,
      1.224342,
      0.529111,
      0.961471,
      3.113348,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      3.596721,
      0.475995,
      3.285263,
      1,
      1,
      3,
      0,
      0,
      1.183228,
      2,
      0,
      3.766921,
      0.577547,
      1,
      0,
      NULL,
      0.634166,
      0.087708,
      1.726680,
      NULL,
      0,
      0,
      1,
      0.368320,
      0.315338,
      1,
      NULL,
      1,
      NULL,
      4,
      3.455041,
      4,
      5.011374,
      2.289079,
      2.185215,
      3.897596,
      2.742900,
      1,
      2,
      3.895169,
      NULL,
      3.491382,
      0,
      NULL,
      27.931690,
      16.135968,
      63,
      0,
      3,
      3,
      '00421',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.199741,
      '',
      '',
      '',
      3.666547,
      22.054522,
      9.895798,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.823312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.753027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.457621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506798,
      NULL,
      NULL,
      1.271141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.775526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466307,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.061893,
      NULL,
      NULL,
      1.757416,
      NULL,
      NULL,
      0.948088,
      NULL,
      NULL,
      0.083298,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.871664,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.806911,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      2.071593,
      1.855299,
      NULL,
      NULL,
      4.225364,
      4,
      1.184832,
      3.305109,
      3.797473,
      4.672970,
      2.748138,
      NULL,
      NULL,
      NULL,
      0,
      3.005731,
      NULL,
      1,
      NULL,
      3,
      0.189074,
      3,
      5,
      NULL,
      1.716060,
      0.463493,
      0,
      2.861609,
      NULL,
      3.274204,
      NULL,
      2,
      NULL,
      3,
      2.325270,
      3,
      3,
      2,
      4,
      NULL,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      1.418425,
      NULL,
      0,
      1,
      1.350751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306908,
      NULL,
      0.948949,
      0.605739,
      1.975793,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5.890331,
      4.080836,
      2.176459,
      0.571069,
      1.624067,
      1,
      NULL,
      NULL,
      0.858791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957153,
      NULL,
      NULL,
      1.071346,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      200.058999,
      1.997711,
      1,
      1.746648,
      NULL,
      0.340322,
      0,
      0,
      NULL,
      1,
      0,
      0.569988,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.928595,
      1,
      3.627018,
      0.076361,
      2,
      1.290090,
      4,
      0,
      NULL,
      1,
      1.519343,
      1.636153,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      1.187234,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.919092,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.272352,
      NULL,
      0,
      3,
      NULL,
      2.723587,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130900,
      NULL,
      1,
      NULL,
      0.655509,
      NULL,
      NULL,
      4,
      NULL,
      0.144384,
      NULL,
      NULL,
      97.835229,
      41.488778,
      1.709584,
      4,
      0.397196,
      '30012',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


