set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.828704,
      1,
      NULL,
      1.101788,
      2,
      NULL,
      3,
      0.548115,
      '130',
      '04431200',
      46,
      63,
      '4143322',
      NULL,
      1,
      2,
      3,
      '2433',
      0.936879,
      NULL,
      NULL,
      NULL,
      ' 8-16-1988',
      180,
      NULL,
      NULL,
      0.795014,
      NULL,
      ' 6-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      4.615297,
      NULL,
      NULL,
      ' 8-16-1977',
      0.539062,
      NULL,
      0,
      1,
      0,
      0.832994,
      NULL,
      0.558659,
      NULL,
      NULL,
      NULL,
      5.429397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.617174,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      0.219266,
      0.965002,
      0,
      0.235422,
      NULL,
      1.891987,
      0,
      0.067125,
      7.082100,
      1,
      NULL,
      0.943522,
      0.514847,
      1.120253,
      NULL,
      NULL,
      0.196608,
      NULL,
      NULL,
      0.545946,
      1,
      NULL,
      2,
      1.948152,
      0,
      2.979218,
      2,
      0,
      0,
      1.677285,
      0,
      1,
      0.489600,
      0.175369,
      1.302719,
      2.161933,
      0,
      NULL,
      0.938298,
      0,
      0,
      2.468533,
      1.783317,
      5.694760,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.409101,
      NULL,
      NULL,
      2,
      1.410303,
      1,
      0.519637,
      NULL,
      1.438112,
      1.890092,
      NULL,
      2,
      1,
      0.009362,
      0.175146,
      NULL,
      0,
      NULL,
      0,
      5.615671,
      NULL,
      0.172505,
      6.297743,
      0,
      6.103808,
      1.688683,
      5,
      6,
      6.198192,
      0.816066,
      NULL,
      0.948380,
      1,
      5,
      NULL,
      7,
      5.572685,
      0,
      NULL,
      6,
      4.974714,
      6,
      4,
      0.965395,
      1,
      0.804392,
      ' 2-21-1975',
      74.032166,
      ' 1-27-2003',
      NULL,
      0,
      NULL,
      0.155333,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.579995,
      1,
      NULL,
      1,
      1.223111,
      3.554473,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      16.188209,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      2,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1.423763,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.603259,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      3.676860,
      3,
      3,
      NULL,
      0.249074,
      2.113438,
      1,
      2.124509,
      2,
      NULL,
      0.494347,
      3,
      0,
      1.203700,
      0,
      3,
      0.862980,
      1,
      1,
      1.038292,
      NULL,
      0.624959,
      0.302377,
      0.645208,
      1,
      0,
      NULL,
      0,
      11,
      0,
      5,
      7.673367,
      7,
      0.443643,
      3.186085,
      0,
      NULL,
      3,
      2.909744,
      1,
      12.375829,
      NULL,
      0.948146,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947216,
      3.692629,
      NULL,
      '23042',
      '',
      '',
      0.466657,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      2,
      NULL,
      242,
      29.270318,
      1.711064,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.101694,
      1,
      1,
      0.600380,
      1,
      NULL,
      0,
      0,
      3,
      0,
      0.538020,
      NULL,
      NULL,
      1.726096,
      1,
      1,
      1.076202,
      3,
      NULL,
      0,
      0.149235,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.558981,
      5.255664,
      1.735188,
      1.487890,
      0.563989,
      0.430762,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.842815,
      0,
      0,
      NULL,
      1,
      3.419466,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2.588176,
      0.921266,
      0,
      2,
      0.127188,
      1.931135,
      3,
      1,
      0.878397,
      1.389173,
      1.737261,
      0.077476,
      2,
      0.995002,
      1.608377,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      8,
      1,
      1,
      1.394129,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418099,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1.889197,
      0,
      NULL,
      0,
      6.186914,
      NULL,
      0,
      3.818036,
      1,
      1.480508,
      1,
      NULL,
      NULL,
      4.911138,
      0,
      0.818475,
      1.077046,
      NULL,
      NULL,
      1.867264,
      NULL,
      NULL,
      0.800891,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      2.528031,
      1.163938,
      1.647012,
      1.555350,
      NULL,
      5,
      NULL,
      NULL,
      4.914109,
      5.831175,
      NULL,
      1.126834,
      1.962730,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3.823587,
      3.031266,
      2.376395,
      1.758725,
      8.195944,
      2,
      1,
      0,
      0.159462,
      NULL,
      1,
      3.936586,
      0.266199,
      1,
      0,
      0,
      3,
      NULL,
      0,
      2,
      0,
      NULL,
      3.715093,
      NULL,
      4,
      3.157790,
      3.497963,
      5.956296,
      NULL,
      0.806623,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      1.893701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015373,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479510,
      NULL,
      NULL,
      0.350063,
      NULL,
      NULL,
      3.444439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.632960,
      0.099990,
      1,
      0,
      NULL,
      2.468162,
      NULL,
      NULL,
      2,
      5.576701,
      NULL,
      NULL,
      2.017247,
      0,
      NULL,
      NULL,
      0,
      0.830026,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      1.726121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003501,
      0.758110,
      NULL,
      NULL,
      1.998459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559932,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.387374,
      2.934073,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0.056168,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.506718,
      0,
      NULL,
      NULL,
      9.911459,
      4,
      NULL,
      NULL,
      3,
      4,
      4.689200,
      5.351296,
      1,
      NULL,
      80,
      1.527582,
      NULL,
      NULL,
      1.013466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525866,
      NULL,
      NULL,
      134.222005,
      1.940561,
      0,
      NULL,
      NULL,
      1.825104,
      0,
      0.988511,
      1,
      0,
      0,
      0.175230,
      0.054066,
      0,
      NULL,
      0.737375,
      1,
      0.544706,
      1.209046,
      1.106303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.084305,
      1,
      0.732130,
      1.856251,
      2.077687,
      NULL,
      1.846240,
      2,
      4,
      1.482106,
      3.193189,
      1,
      0.402467,
      1,
      NULL,
      1.579436,
      1,
      0,
      1,
      NULL,
      1.358000,
      1,
      0.242419,
      0,
      1.090441,
      3,
      0,
      1.481642,
      0.998560,
      0,
      1,
      NULL,
      2.237880,
      1.910811,
      1.127443,
      0.516556,
      0,
      2.345382,
      NULL,
      0,
      NULL,
      0.315503,
      0,
      1,
      1,
      NULL,
      1.569947,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592402,
      1.847636,
      1.408506,
      NULL,
      1.186547,
      0.892314,
      0,
      4.954635,
      1.194301,
      1.460613,
      NULL,
      NULL,
      5.571094,
      119.176950,
      2.679200,
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


