set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      1.433345,
      1,
      0.818447,
      NULL,
      1,
      0,
      NULL,
      '232',
      '13344414',
      7.638966,
      37,
      '3432204',
      1,
      1,
      1,
      1,
      '1040',
      5,
      0.665747,
      NULL,
      NULL,
      ' 3-21-1992',
      151,
      NULL,
      NULL,
      3,
      0,
      ' 2-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1999',
      ' 9- 7-1990',
      ' 0-17-1976',
      3.653612,
      1,
      1,
      0.578695,
      1.713437,
      NULL,
      NULL,
      NULL,
      1.098313,
      NULL,
      3,
      11.780091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.564679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100251,
      3.510508,
      6,
      2,
      NULL,
      1,
      1,
      1.180585,
      1,
      1.938948,
      0,
      0.632666,
      NULL,
      2.778369,
      1.333035,
      3.467770,
      0,
      0,
      2,
      2.368633,
      0,
      0.674837,
      NULL,
      NULL,
      0.242562,
      1,
      0,
      5.519394,
      0.149439,
      1,
      0,
      1,
      1.677228,
      3,
      NULL,
      1,
      1,
      3.135127,
      NULL,
      2,
      1,
      2,
      1.747658,
      2,
      2,
      NULL,
      4,
      1.276965,
      NULL,
      5.384037,
      NULL,
      NULL,
      2.187799,
      0,
      NULL,
      NULL,
      0.343355,
      1.849555,
      1.280280,
      NULL,
      1,
      7,
      0,
      5,
      1.798214,
      NULL,
      1.101292,
      NULL,
      NULL,
      1,
      1.618351,
      1.563305,
      1.499740,
      0.692532,
      0.377605,
      NULL,
      1.841906,
      1.557152,
      NULL,
      0.864726,
      7,
      0.076139,
      2.461699,
      NULL,
      0.517820,
      0.673717,
      3.169054,
      NULL,
      3.372904,
      6,
      7.811051,
      0.599067,
      6.024142,
      1,
      6.188290,
      6,
      3,
      2,
      4,
      3,
      NULL,
      1,
      0.256783,
      NULL,
      1.214727,
      1,
      0.419552,
      '10- 0-1983',
      405.248880,
      NULL,
      359,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182716,
      1,
      1.140223,
      0.639397,
      0.358242,
      1.766389,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.417915,
      NULL,
      1.972734,
      1,
      0.859738,
      1.298564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1.988550,
      NULL,
      NULL,
      NULL,
      0.613256,
      1,
      0.231137,
      8,
      4,
      0,
      1,
      1.588324,
      3,
      0.616046,
      1.694194,
      NULL,
      1.403892,
      4,
      0.982602,
      3.396149,
      4.398291,
      NULL,
      0,
      '10-18-1995',
      0,
      1,
      0.192020,
      1,
      2,
      NULL,
      0.192611,
      NULL,
      1,
      0,
      1.063773,
      3.284717,
      NULL,
      1.554151,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.261090,
      2,
      NULL,
      1.444126,
      1.128396,
      2.677049,
      1.193848,
      0,
      0.714184,
      NULL,
      0,
      0,
      3,
      1.491103,
      NULL,
      5,
      0,
      1.131093,
      3,
      NULL,
      1.798711,
      1,
      1,
      1.567824,
      0.093465,
      0,
      0,
      NULL,
      1,
      3.201599,
      NULL,
      2.671347,
      0.232677,
      7,
      8.626447,
      1,
      5,
      0.530155,
      0,
      4,
      2,
      NULL,
      3.975361,
      7.924167,
      1.389367,
      NULL,
      30.032779,
      NULL,
      29.868383,
      7,
      2.199522,
      0.751248,
      1.701743,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '43423',
      '',
      '',
      NULL,
      NULL,
      235,
      34.554489,
      NULL,
      32,
      6,
      NULL,
      NULL,
      0.314669,
      3.630220,
      NULL,
      1.664971,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.800390,
      1.059106,
      0,
      0.125323,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0.691928,
      1,
      3,
      0.207820,
      1.760037,
      3,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      1.974940,
      0.688645,
      1,
      0,
      2.734930,
      0.440013,
      1.041960,
      1.111620,
      0.691376,
      1.888074,
      NULL,
      NULL,
      NULL,
      3.679040,
      1,
      0,
      1.670463,
      1.778571,
      NULL,
      0.830343,
      NULL,
      NULL,
      NULL,
      0.067129,
      2.021401,
      0,
      0.982527,
      0.150165,
      0,
      3,
      0,
      0,
      1.983100,
      2,
      3.773064,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      3,
      3,
      0.357497,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.017659,
      2,
      5.301932,
      3.797954,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      0.872333,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1,
      1.424532,
      1.584301,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725897,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.536509,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.681227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.523483,
      2,
      1.811229,
      3.442491,
      NULL,
      2,
      1,
      0,
      0,
      1,
      4.678010,
      NULL,
      NULL,
      NULL,
      3,
      3.768579,
      1.882814,
      NULL,
      1,
      0.855715,
      1,
      0,
      NULL,
      11.596379,
      NULL,
      9,
      1.904762,
      NULL,
      NULL,
      0.641322,
      NULL,
      3.232222,
      1,
      1,
      0,
      1.472531,
      1,
      1.351826,
      NULL,
      NULL,
      1.792730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.216349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.824558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.138789,
      1.935630,
      0,
      1.385272,
      0,
      3.477561,
      1.877388,
      NULL,
      7.230539,
      0.245868,
      NULL,
      NULL,
      3,
      43,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.175153,
      0.324433,
      NULL,
      NULL,
      2,
      0.576624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296454,
      1,
      NULL,
      NULL,
      1.036819,
      1.988210,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.263309,
      0,
      NULL,
      NULL,
      0.677556,
      0,
      NULL,
      NULL,
      2,
      0.735106,
      NULL,
      NULL,
      2.007190,
      3.435495,
      NULL,
      NULL,
      1.108618,
      1.516699,
      NULL,
      NULL,
      0.747148,
      0.299261,
      NULL,
      NULL,
      1,
      1.893904,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      1.393347,
      3,
      0,
      0.796083,
      2.276461,
      0,
      55.208136,
      9.920053,
      2,
      27.492876,
      0,
      1.495828,
      NULL,
      NULL,
      0,
      12,
      7,
      NULL,
      NULL,
      NULL,
      0.477394,
      NULL,
      NULL,
      1,
      NULL,
      0,
      213.752789,
      0,
      1.601435,
      0.062529,
      1,
      3,
      0,
      0,
      1,
      3,
      0.629785,
      3.711023,
      0,
      0.139311,
      0,
      0,
      0.906643,
      1,
      0,
      NULL,
      NULL,
      0.436702,
      NULL,
      3.193924,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      232,
      NULL,
      2,
      8,
      14,
      1.493928,
      2.379342,
      2.345836,
      NULL,
      0,
      NULL,
      1.383496,
      NULL,
      0.097824,
      NULL,
      1,
      NULL,
      0.254805,
      NULL,
      1,
      NULL,
      1.818805,
      NULL,
      1.463768,
      NULL,
      1,
      NULL,
      1.819081,
      NULL,
      1.778990,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.529095,
      0.477217,
      1.773696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.013414,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      3.006298,
      NULL,
      1.843310,
      NULL,
      1,
      NULL,
      0,
      0.923939,
      NULL,
      NULL,
      3,
      NULL,
      0.313028,
      NULL,
      NULL,
      NULL,
      1.760852,
      NULL,
      0,
      NULL,
      1.284939,
      NULL,
      0,
      1.787057,
      3.981289,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.727313,
      0,
      NULL,
      1,
      NULL,
      0.914778,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.022954,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2993.137864,
      NULL,
      2.302382,
      NULL,
      0.145917,
      NULL,
      NULL,
      0,
      0,
      29.381721,
      12.361495,
      0,
      3,
      0.780879,
      NULL,
      NULL,
      3,
      2,
      4.749646,
      0.738223,
      1,
      0,
      2,
      5.215001,
      3,
      2.140656,
      NULL,
      1.530591,
      NULL,
      NULL,
      NULL,
      1.073668,
      NULL,
      0.099041,
      1,
      NULL,
      1.868431,
      0,
      NULL,
      0.034122,
      1,
      NULL,
      NULL,
      1.624721,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.892407,
      0.237179,
      NULL,
      0,
      1,
      NULL,
      1,
      0.477847,
      0.469219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.423441,
      8,
      7,
      1,
      NULL,
      2,
      24.983631,
      75,
      NULL,
      0.517725,
      2,
      NULL,
      NULL,
      '',
      1.712755,
      '',
      NULL,
      '',
      NULL,
      '41444',
      '',
      NULL);
commit;
end;
/


