set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630675';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.324203,
      2,
      3.789095,
      2.161509,
      2,
      NULL,
      1,
      0,
      '332',
      '02244430',
      62,
      NULL,
      '0044033',
      3.962414,
      1.332383,
      1,
      2,
      '4230',
      5.401134,
      1.198967,
      NULL,
      NULL,
      ' 4-22-1998',
      37,
      21.233624,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.451265,
      ' 2- 0-2003',
      ' 6-16-2003',
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.743923,
      3,
      1.254680,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.055089,
      2.629306,
      NULL,
      1,
      0.512956,
      0,
      0,
      NULL,
      1.673205,
      1.324302,
      2,
      0.009565,
      NULL,
      1.158576,
      1,
      3.122395,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1.731718,
      0.436252,
      1,
      NULL,
      1.170226,
      1,
      NULL,
      0.263212,
      0,
      NULL,
      2.665606,
      3,
      NULL,
      3,
      0.314776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.387826,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414411,
      1,
      0.708182,
      1.132958,
      0,
      1.483797,
      NULL,
      NULL,
      0.815429,
      NULL,
      NULL,
      5,
      1,
      4.358916,
      0,
      3.426520,
      1.431064,
      NULL,
      0,
      NULL,
      0.929798,
      1,
      3.634605,
      1.501100,
      0.654451,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.326724,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      4.233275,
      0.825008,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      4,
      0.334336,
      3.131475,
      2,
      NULL,
      3.485224,
      2,
      3.896147,
      1.547087,
      2,
      ' 2-12-1999',
      5,
      ' 5-14-1984',
      0,
      NULL,
      NULL,
      2.644560,
      0.438509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.638676,
      0,
      0.732873,
      0.145735,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632276,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.517591,
      0.913663,
      NULL,
      0,
      1.334853,
      6.597322,
      NULL,
      1,
      0,
      2.641011,
      2.416429,
      NULL,
      1,
      0,
      0.591291,
      0.691230,
      0,
      0.955415,
      NULL,
      NULL,
      NULL,
      0,
      0.361327,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469404,
      NULL,
      0.063812,
      0.310813,
      1.436016,
      1,
      1,
      3,
      21,
      0.562125,
      1,
      NULL,
      NULL,
      NULL,
      2.782400,
      0,
      NULL,
      2,
      2.756052,
      2.893907,
      3,
      NULL,
      2,
      1,
      2,
      0,
      2.269218,
      0,
      NULL,
      1.510109,
      3.361864,
      2,
      1.282232,
      0.646896,
      NULL,
      NULL,
      0.740940,
      0.057221,
      NULL,
      0,
      1,
      1,
      0.684055,
      1.148962,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.043778,
      29.035049,
      NULL,
      NULL,
      36.925390,
      5.089983,
      3,
      NULL,
      '33311',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.316930,
      '',
      '',
      NULL,
      1,
      19.777038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1.658137,
      NULL,
      NULL,
      0.367898,
      1,
      0,
      0,
      NULL,
      NULL,
      1.880522,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      13.972738,
      3.157272,
      1,
      1.109587,
      1.429646,
      1.310288,
      1,
      NULL,
      0.420046,
      0.509566,
      2.328088,
      1,
      2.985697,
      1,
      1.756035,
      NULL,
      0,
      1.253127,
      0.458070,
      1.257986,
      1.292570,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.430908,
      NULL,
      0,
      0.058675,
      NULL,
      0,
      NULL,
      1.562158,
      NULL,
      0,
      NULL,
      0.690728,
      NULL,
      0.257984,
      NULL,
      NULL,
      NULL,
      1.275042,
      NULL,
      1,
      NULL,
      0.828898,
      NULL,
      1.353040,
      NULL,
      1.663670,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.662233,
      NULL,
      1,
      NULL,
      0.798154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.047146,
      0.589181,
      NULL,
      1.981469,
      NULL,
      111.176273,
      NULL,
      1,
      NULL,
      0.324365,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.776529,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123518,
      1.719003,
      NULL,
      1,
      NULL,
      3.346250,
      NULL,
      408.855512,
      NULL,
      1.317924,
      NULL,
      NULL,
      NULL,
      0.981487,
      1.794706,
      1,
      24.696259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0.851527,
      NULL,
      2.734572,
      2,
      NULL,
      1.841330,
      1,
      NULL,
      0.220445,
      NULL,
      0.844276,
      1.848756,
      NULL,
      1.706774,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      2.287948,
      NULL,
      0,
      0,
      NULL,
      0.696263,
      0,
      NULL,
      0,
      0,
      NULL,
      1.323016,
      0,
      NULL,
      0,
      1,
      NULL,
      1.686397,
      1,
      NULL,
      2.031285,
      1.084555,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.693904,
      NULL,
      0.767421,
      3,
      2.543941,
      1,
      NULL,
      NULL,
      NULL,
      16,
      1.335078,
      3,
      3,
      '21304',
      '34104',
      '43233',
      1.750596,
      '',
      '',
      NULL,
      0.302791,
      NULL,
      '',
      '');
commit;
end;
/


