set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2023444',
      0,
      0.569999,
      3,
      0,
      '2031',
      1.252018,
      NULL,
      3,
      41.219890,
      ' 0- 7-2001',
      52.324761,
      NULL,
      NULL,
      NULL,
      0.410413,
      '10- 4-2000',
      28,
      NULL,
      262,
      2.020860,
      1.198581,
      NULL,
      NULL,
      ' 2-21-1986',
      2,
      1,
      2,
      NULL,
      1,
      3.255008,
      3.939609,
      NULL,
      0.632963,
      45,
      NULL,
      10.563699,
      4.219327,
      1,
      5.699142,
      4,
      NULL,
      3,
      1.605381,
      NULL,
      1,
      0.097090,
      1,
      0.888028,
      1.357875,
      1,
      0.945280,
      0.058961,
      NULL,
      NULL,
      21.416231,
      7.266180,
      NULL,
      3.534013,
      2,
      1.488278,
      0.779658,
      1.739210,
      0,
      NULL,
      1.523326,
      4.628689,
      0,
      1,
      3,
      3.963147,
      NULL,
      NULL,
      3.300839,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.770805,
      0.267566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306787,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125450,
      0.983039,
      3,
      0,
      2,
      1,
      1.179695,
      0,
      NULL,
      0.472068,
      1.662801,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0.392165,
      0.146699,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.060064,
      2,
      3,
      3.437432,
      4.223617,
      1.964792,
      0,
      3,
      5,
      1.571188,
      NULL,
      8,
      6.573091,
      NULL,
      1,
      1,
      0,
      NULL,
      8,
      4,
      NULL,
      3,
      1.810357,
      ' 9-25-1993',
      109,
      ' 5-16-1990',
      26.512896,
      3.246231,
      1,
      1.801694,
      5,
      1.872791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267188,
      0,
      0.682062,
      0,
      1.545519,
      1,
      0.168930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242237,
      0,
      0,
      8,
      6.536913,
      1.181962,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6.702916,
      2,
      6,
      8,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.751598,
      2,
      0.617729,
      NULL,
      3.854525,
      6,
      NULL,
      638,
      ' 9- 0-1998',
      5.853152,
      2.841068,
      0.701714,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.098932,
      2,
      443,
      0.066419,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.414271,
      2,
      3,
      NULL,
      0,
      3.662153,
      NULL,
      1.705599,
      NULL,
      1.734197,
      3.189980,
      1,
      0,
      NULL,
      1.102324,
      1,
      1.412534,
      0.321708,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.552016,
      1,
      0,
      3,
      0,
      0,
      9,
      4.024344,
      11.913465,
      4,
      5.163104,
      1.016928,
      2,
      5.918107,
      2.702700,
      0.403338,
      3.484122,
      6.420996,
      0,
      1,
      NULL,
      31,
      30,
      NULL,
      2,
      1.379773,
      1,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      96,
      9,
      NULL,
      6.970976,
      11,
      NULL,
      NULL,
      0.151665,
      2.605741,
      1.239413,
      2,
      0,
      1.302511,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.307332,
      0,
      3,
      NULL,
      0.168297,
      0,
      0.756702,
      NULL,
      NULL,
      1.863337,
      0,
      1.425932,
      0.269153,
      NULL,
      NULL,
      2.351646,
      0.683187,
      0.112954,
      NULL,
      NULL,
      3,
      2,
      7,
      NULL,
      4,
      0.414316,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      10,
      1,
      2,
      1,
      1.827784,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.291310,
      1,
      NULL,
      3,
      3.543020,
      1,
      0,
      1,
      NULL,
      0.134239,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      2,
      1.042416,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279529,
      NULL,
      0.487373,
      NULL,
      0.423319,
      NULL,
      NULL,
      1.777188,
      0,
      1.817882,
      0.284604,
      1.163370,
      1.611056,
      0,
      3.016805,
      0.930312,
      0.850126,
      1,
      0.229158,
      3,
      1.198318,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026921,
      0,
      NULL,
      0.707918,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.150132,
      NULL,
      4,
      0.141717,
      0.656822,
      3,
      0,
      3.181139,
      1.496336,
      NULL,
      NULL,
      5.947120,
      0.840786,
      1.802166,
      8,
      3,
      2,
      NULL,
      7.112978,
      NULL,
      1.550672,
      0,
      3,
      3.698692,
      2,
      NULL,
      0,
      0,
      1,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.821891,
      NULL,
      0,
      NULL,
      NULL,
      1.891797,
      1.499545,
      0.143310,
      3,
      6,
      7,
      NULL,
      0,
      1.225155,
      NULL,
      2,
      0.732481,
      0.375138,
      1.024410,
      0.836686,
      0.120261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      1.413420,
      0.293814,
      1.680157,
      1.126991,
      0,
      NULL,
      1,
      NULL,
      14,
      NULL,
      4.577480,
      NULL,
      3.576504,
      NULL,
      2,
      NULL,
      1.816782,
      NULL,
      1.328945,
      NULL,
      NULL,
      NULL,
      0.150928,
      NULL,
      0.357759,
      NULL,
      NULL,
      NULL,
      2.309704,
      NULL,
      NULL,
      NULL,
      2.845236,
      NULL,
      2.848923,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.732182,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.597927,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.853197,
      NULL,
      1,
      NULL,
      2.799626,
      NULL,
      2.811303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.566399,
      NULL,
      8.360888,
      NULL,
      3.626653,
      NULL,
      4.544528,
      NULL,
      4.575327,
      NULL,
      3,
      NULL,
      5,
      NULL,
      1.044005,
      1,
      6.104417,
      7.423140,
      NULL,
      111.033641,
      37.506766,
      0,
      33.962876,
      0,
      1.342325,
      NULL,
      NULL,
      NULL,
      12,
      3,
      0,
      NULL,
      NULL,
      1.977569,
      NULL,
      NULL,
      0,
      NULL,
      1,
      117,
      NULL,
      1,
      0.838105,
      0,
      0,
      NULL,
      1.722811,
      1.666432,
      1.288759,
      1.202378,
      1,
      0,
      1.955096,
      0,
      0,
      NULL,
      1.745687,
      NULL,
      0.603613,
      NULL,
      NULL,
      NULL,
      1.779487,
      NULL,
      1.851104,
      NULL,
      1.646098,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3,
      9.736546,
      NULL,
      0,
      0.539206,
      2,
      6.779119,
      0,
      3.615194,
      2.144796,
      1,
      0,
      0,
      2.689988,
      2,
      1.085236,
      1.030050,
      1.603778,
      3.265427,
      NULL,
      NULL,
      1.700123,
      1,
      1.817441,
      0.240526,
      1.406939,
      1.629504,
      2,
      NULL,
      3,
      3.402849,
      2,
      0.177578,
      1,
      NULL,
      2.129812,
      3,
      0.565335,
      0.212518,
      1.477242,
      3,
      2,
      0,
      0.278286,
      2.884832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0.435553,
      0,
      2.699460,
      2,
      2,
      NULL,
      2.712448,
      0.438356,
      0,
      1.387499,
      3.334533,
      NULL,
      1,
      1,
      0.376263,
      3.347679,
      2.163511,
      2.781752,
      0,
      2,
      2,
      NULL,
      3,
      26,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1.410383,
      11,
      NULL,
      3.053937,
      NULL,
      1,
      2,
      13.658912,
      NULL,
      0,
      NULL,
      '22212',
      NULL,
      '',
      0.858861,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


