set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7323049';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '2414043',
      1,
      1.521829,
      3,
      2,
      '1341',
      0,
      0,
      NULL,
      NULL,
      ' 3- 6-1987',
      7,
      NULL,
      NULL,
      0.560970,
      0,
      NULL,
      24,
      1.429348,
      328.884939,
      89,
      3.800177,
      ' 5-11-1993',
      ' 8-17-1999',
      NULL,
      2.455416,
      0,
      0,
      0,
      1.542106,
      NULL,
      3,
      0,
      1.445787,
      118.141374,
      6.390786,
      18.380901,
      1,
      31,
      18.079445,
      NULL,
      13,
      5.602575,
      0,
      5.158730,
      1.610929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.881133,
      0,
      6.493352,
      NULL,
      0,
      6.802928,
      NULL,
      2.416058,
      2,
      NULL,
      6.462327,
      0,
      0.061992,
      1.670309,
      7,
      0.872090,
      5,
      1,
      1,
      1.969615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877115,
      3,
      1.494997,
      0.575690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367225,
      1,
      1.900782,
      0.446505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.762867,
      0,
      1,
      1.720183,
      1,
      0.490306,
      0.130827,
      NULL,
      0.186338,
      NULL,
      0.828014,
      1.760468,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0.223440,
      0,
      0.982001,
      NULL,
      0,
      2.280254,
      0.676080,
      0.115440,
      1.794058,
      4.043878,
      NULL,
      NULL,
      0,
      0,
      0.292720,
      4.875457,
      2.659373,
      0,
      1.510559,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.456948,
      ' 7-21-1977',
      622.606764,
      ' 2-17-2002',
      953.935276,
      NULL,
      NULL,
      NULL,
      3.639135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996337,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146888,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330841,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434266,
      1,
      1.782037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.260273,
      0.860792,
      0,
      1.771581,
      1.866431,
      NULL,
      31,
      NULL,
      1.150638,
      NULL,
      176,
      199.743822,
      1.663747,
      NULL,
      3,
      2.967553,
      2.448171,
      NULL,
      2.654064,
      NULL,
      1,
      3,
      3,
      1.593175,
      2,
      2.799112,
      1.270880,
      NULL,
      0.392817,
      1.022544,
      0,
      0.055982,
      1.019479,
      0.396774,
      0,
      1,
      0.178475,
      0,
      NULL,
      1.920446,
      1.291980,
      1,
      1,
      0.301316,
      0,
      NULL,
      NULL,
      2.132062,
      NULL,
      6.757011,
      4.293612,
      NULL,
      6,
      NULL,
      2.958542,
      3,
      13.527460,
      NULL,
      NULL,
      NULL,
      87,
      18.820529,
      4,
      0,
      NULL,
      NULL,
      '20314',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.049605,
      '',
      NULL,
      '',
      1.474006,
      15.484698,
      56,
      27,
      1,
      26,
      4,
      1,
      3,
      0,
      3.103882,
      0.963558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.379489,
      1,
      NULL,
      NULL,
      0.080379,
      NULL,
      2.695056,
      0.504461,
      1.947026,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.608597,
      NULL,
      0,
      NULL,
      NULL,
      3.076537,
      NULL,
      1.334752,
      0.465327,
      NULL,
      NULL,
      7,
      2.850179,
      5,
      1.124540,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655806,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174380,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1,
      0.451038,
      NULL,
      NULL,
      NULL,
      0.876240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.708499,
      1.287879,
      0.329640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.493064,
      NULL,
      NULL,
      1.278951,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.073594,
      NULL,
      NULL,
      0.793524,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      1.212169,
      1.510900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      2,
      2.656078,
      0.510236,
      5.781878,
      NULL,
      2,
      NULL,
      2,
      2.350507,
      NULL,
      1,
      1.792323,
      0.451007,
      2.728957,
      NULL,
      NULL,
      0.950720,
      2.207671,
      4.056841,
      NULL,
      3.361878,
      0.084715,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.824522,
      NULL,
      0.551195,
      NULL,
      NULL,
      NULL,
      0.805752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.926719,
      NULL,
      NULL,
      0.469138,
      NULL,
      NULL,
      0.314932,
      NULL,
      NULL,
      1.600639,
      NULL,
      NULL,
      0.027088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635973,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.114174,
      3,
      1.681519,
      NULL,
      NULL,
      2.643800,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.820746,
      NULL,
      NULL,
      NULL,
      0.107121,
      NULL,
      NULL,
      NULL,
      0.712966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.402360,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.371076,
      3,
      5,
      0.954967,
      1.775721,
      NULL,
      NULL,
      1.100447,
      NULL,
      4.728345,
      NULL,
      NULL,
      NULL,
      1.751558,
      NULL,
      NULL,
      0.521654,
      NULL,
      1.509797,
      750.090774,
      26.372052,
      1.660871,
      1,
      NULL,
      1,
      NULL,
      1.653387,
      1.150326,
      0.256210,
      0.734016,
      1.664250,
      NULL,
      1.070623,
      0,
      0,
      0.324143,
      1.669441,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.229779,
      NULL,
      2.547217,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.229249,
      45.463528,
      48.443909,
      0,
      0.392647,
      NULL,
      NULL,
      3.458138,
      NULL,
      0.660902,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.004079,
      NULL,
      0,
      NULL,
      1.703056,
      NULL,
      0.368166,
      NULL,
      0.099683,
      NULL,
      0.517094,
      NULL,
      1,
      NULL,
      1.480263,
      NULL,
      1,
      0.309714,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673322,
      1.455313,
      NULL,
      0.677508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364029,
      NULL,
      NULL,
      NULL,
      0.823594,
      NULL,
      1,
      1.747898,
      2.153963,
      NULL,
      1.073902,
      NULL,
      0.893160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598757,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680341,
      0,
      2.936302,
      NULL,
      0,
      NULL,
      0.612737,
      NULL,
      NULL,
      NULL,
      1,
      0.401678,
      2.261438,
      NULL,
      0.024973,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.186091,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.731479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261256,
      0,
      0.683316,
      1,
      0,
      1,
      NULL,
      4,
      8,
      0.400959,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      2.708822,
      NULL,
      1,
      2,
      NULL,
      1.239745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387613,
      NULL,
      2.679029,
      2.695261,
      NULL,
      0,
      1,
      NULL,
      0.877431,
      0.563693,
      NULL,
      0.495957,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.744363,
      NULL,
      1,
      NULL,
      1.840072,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.204287,
      NULL,
      3.020163,
      NULL,
      3.626964,
      NULL,
      55,
      0.438854,
      1.190671,
      0.440473,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.005771,
      3.768475,
      1,
      NULL,
      15.271817,
      19.045937,
      0.714480,
      0.836953,
      4.109034,
      '33413',
      '30234',
      '',
      0.876477,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


