set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9776020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1,
      NULL,
      1.261969,
      0.478890,
      0.448628,
      0.921888,
      2,
      NULL,
      '31444123',
      8.196588,
      38.004859,
      '0110120',
      2,
      1.906071,
      2,
      0,
      NULL,
      3.923150,
      0.687201,
      NULL,
      NULL,
      NULL,
      172,
      109.239534,
      NULL,
      0.756119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.953099,
      ' 5-28-1984',
      ' 6- 3-1975',
      ' 9- 7-1978',
      0.563337,
      3,
      1,
      1,
      1,
      1,
      1.642227,
      1.936009,
      1,
      399,
      12.932737,
      1.881610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981753,
      NULL,
      NULL,
      3.845817,
      NULL,
      0.871081,
      0.906409,
      0,
      3,
      NULL,
      5.494353,
      NULL,
      1.066131,
      0.064963,
      NULL,
      0.463015,
      4.007991,
      NULL,
      3.276704,
      0.975320,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.547678,
      6,
      2,
      0,
      1,
      1,
      2.586427,
      1.855657,
      0,
      0,
      3.935080,
      NULL,
      1.149917,
      3,
      0.512838,
      0,
      3,
      1,
      NULL,
      NULL,
      0.770175,
      4.379536,
      5.683182,
      1.316770,
      0.475981,
      1.332477,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.252483,
      1,
      2.191853,
      NULL,
      NULL,
      0,
      1,
      0.678481,
      0.412580,
      2.118096,
      0.794017,
      1,
      1,
      1,
      0,
      1,
      0.414093,
      0,
      0,
      NULL,
      0.395471,
      3,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0.579418,
      0,
      NULL,
      7.115622,
      NULL,
      NULL,
      1.462370,
      NULL,
      2.424100,
      6.438914,
      3.493147,
      3.599960,
      2,
      4,
      5.550352,
      1,
      1,
      7.768730,
      NULL,
      3.556354,
      '11- 2-1988',
      75,
      ' 3-29-1993',
      73,
      0.061086,
      0.877531,
      0,
      1.893085,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381020,
      1.845653,
      0.619398,
      0,
      1,
      2.634876,
      4,
      0.192365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.491329,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791662,
      NULL,
      NULL,
      3,
      4.514883,
      5.185594,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.076849,
      0.003819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.416667,
      1.539462,
      1,
      NULL,
      1,
      0.655180,
      1.715682,
      2.107017,
      92,
      3.211915,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      1.110061,
      3.223952,
      3.880888,
      1,
      2,
      NULL,
      0,
      5.880982,
      NULL,
      1.599223,
      1,
      NULL,
      NULL,
      1.106733,
      1,
      0,
      1,
      NULL,
      0,
      1.224142,
      0.578580,
      0.305600,
      4,
      0.163735,
      NULL,
      0,
      2.267747,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      2.590706,
      3.261338,
      63,
      0,
      0,
      24.881912,
      NULL,
      34.174834,
      63,
      1,
      NULL,
      3,
      '22243',
      NULL,
      '',
      0.012786,
      '',
      NULL,
      '',
      0.263732,
      '',
      NULL,
      '',
      2,
      1,
      64,
      54.713649,
      NULL,
      71,
      3,
      3,
      5,
      NULL,
      NULL,
      0.190829,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161676,
      2.870390,
      0.463541,
      NULL,
      NULL,
      0.614351,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.657966,
      2.983706,
      5,
      0.412142,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.885025,
      0.071536,
      0,
      NULL,
      1,
      2.980537,
      NULL,
      1.064975,
      NULL,
      3,
      NULL,
      1.246259,
      NULL,
      1,
      NULL,
      0.385011,
      3,
      1.572831,
      NULL,
      3.766890,
      2.570993,
      1,
      1.223150,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      7,
      7,
      1.475557,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.127012,
      NULL,
      NULL,
      0.395498,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3.716260,
      2,
      2,
      3.599547,
      3,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.536052,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.171091,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094164,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      5.318928,
      1.113026,
      1,
      NULL,
      NULL,
      1.048570,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.754809,
      NULL,
      7,
      7.603745,
      3.797399,
      3,
      0.539814,
      NULL,
      3.015662,
      2.041751,
      1,
      3,
      3,
      2.613131,
      NULL,
      3.128389,
      1,
      NULL,
      5.151040,
      0,
      2,
      3.234934,
      NULL,
      1,
      2,
      1.025653,
      0,
      0.785391,
      0,
      0.837269,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.247292,
      NULL,
      NULL,
      1.921016,
      NULL,
      NULL,
      2.954794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0.216004,
      1.130533,
      3,
      1,
      NULL,
      NULL,
      1.770329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138280,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.843470,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.347415,
      NULL,
      NULL,
      NULL,
      1.762414,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.592692,
      NULL,
      NULL,
      NULL,
      1.347783,
      21.888143,
      4,
      2,
      62.459236,
      15,
      0,
      NULL,
      NULL,
      0.997104,
      24,
      NULL,
      1.962460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1.780637,
      1.944865,
      1,
      NULL,
      1.581720,
      1.101290,
      0,
      0,
      NULL,
      0,
      1,
      1.104206,
      1,
      0.927386,
      0.088659,
      NULL,
      1.993678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036830,
      0,
      NULL,
      2.722001,
      3.602675,
      1.581148,
      1.919770,
      1.025491,
      8.455146,
      NULL,
      1,
      0.858377,
      1.932900,
      2.732687,
      NULL,
      0,
      2,
      NULL,
      0.159894,
      0,
      NULL,
      0.458372,
      0.826514,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.078766,
      3,
      NULL,
      0,
      2.748183,
      NULL,
      NULL,
      3.444831,
      NULL,
      1.567240,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351797,
      NULL,
      0,
      NULL,
      0.913754,
      NULL,
      NULL,
      7.918836,
      2,
      1.350878,
      NULL,
      NULL,
      27.167206,
      12,
      0.667727,
      NULL,
      5,
      '23442',
      '42343',
      '',
      0.752574,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


