set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      NULL,
      19.980721,
      45,
      NULL,
      NULL,
      0.379483,
      NULL,
      1,
      '4431',
      2.489555,
      1,
      NULL,
      NULL,
      ' 6-24-1992',
      69,
      59,
      NULL,
      1.794656,
      0.139586,
      ' 1- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      3.181102,
      ' 6-23-1994',
      ' 8- 3-1985',
      NULL,
      1.135979,
      3.885677,
      2,
      1.012893,
      1.892565,
      0,
      3.205281,
      0.548862,
      NULL,
      NULL,
      NULL,
      10,
      7.029968,
      NULL,
      NULL,
      NULL,
      NULL,
      6.411405,
      NULL,
      NULL,
      0.617086,
      2,
      1.968938,
      1,
      1.688290,
      1.857743,
      0,
      0,
      0.700394,
      1,
      1,
      1,
      0,
      2.274477,
      NULL,
      NULL,
      0,
      4,
      NULL,
      3.105483,
      1.908420,
      0.088224,
      0,
      1.456057,
      1.939771,
      NULL,
      0.473917,
      6.331051,
      3,
      2.487177,
      1,
      1,
      0.037209,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.816199,
      1.429477,
      1.577833,
      1.751936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.968882,
      1,
      0.915154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.567887,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.748059,
      1.080092,
      1,
      NULL,
      NULL,
      NULL,
      1.371678,
      0.483075,
      0,
      1.366366,
      1,
      NULL,
      1.923046,
      3.257766,
      5,
      0.710798,
      0,
      0.674393,
      0.285545,
      0,
      1.618764,
      1.709852,
      NULL,
      NULL,
      0.049778,
      0.918410,
      2,
      NULL,
      6,
      9,
      6.616812,
      NULL,
      8,
      3.281628,
      NULL,
      11.579862,
      2.048853,
      3.142246,
      NULL,
      2.060058,
      '10- 4-2002',
      NULL,
      ' 4-28-1982',
      19.445113,
      3,
      1.810238,
      0.878831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495122,
      0.347488,
      5,
      0.936984,
      1,
      0,
      NULL,
      1.809541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001582,
      7,
      0.914429,
      1,
      9,
      0.897399,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.791204,
      1.615364,
      1.012372,
      0,
      0,
      0,
      1,
      46,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.398057,
      0,
      NULL,
      3,
      2,
      1.253567,
      1.559259,
      3.949777,
      0.772663,
      2.508567,
      2.222401,
      NULL,
      0,
      2,
      3,
      NULL,
      1.697144,
      0,
      0.588418,
      1.286253,
      1,
      NULL,
      1,
      0.026325,
      0.825625,
      1.007098,
      0.416462,
      1,
      0.913542,
      0.088997,
      NULL,
      2,
      7.418093,
      7.905729,
      8.123900,
      2,
      NULL,
      3,
      6.278769,
      0.674641,
      1,
      NULL,
      24.326660,
      2,
      1.960931,
      NULL,
      NULL,
      35,
      57.153570,
      4,
      3.634512,
      4.650303,
      NULL,
      '21203',
      NULL,
      1,
      '00403',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      2.661498,
      26,
      1.377566,
      NULL,
      2.958992,
      NULL,
      0.537486,
      0.118052,
      2.709468,
      0,
      1.225203,
      0,
      1.732851,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192458,
      NULL,
      NULL,
      1.057325,
      NULL,
      NULL,
      1.596733,
      NULL,
      NULL,
      1.937242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.682035,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337428,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.732888,
      NULL,
      NULL,
      1.154808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.475827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.883092,
      3.000297,
      1.772848,
      0,
      1.703574,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.140406,
      0,
      NULL,
      NULL,
      3.061045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754392,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.136273,
      NULL,
      NULL,
      1.499624,
      NULL,
      NULL,
      1,
      2,
      1.385917,
      5,
      1.315278,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.575132,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5.593305,
      2,
      0.159398,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.921783,
      0,
      0.435096,
      2,
      0.128087,
      2.655589,
      0.128971,
      2.449389,
      3.994535,
      NULL,
      1.136128,
      2.497282,
      NULL,
      1.287722,
      1,
      1,
      0,
      0.410466,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.099127,
      3.738213,
      3,
      0.680056,
      1,
      0,
      8,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345612,
      NULL,
      NULL,
      NULL,
      1.464118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.323258,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.439214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.795252,
      NULL,
      NULL,
      NULL,
      0.456756,
      NULL,
      NULL,
      NULL,
      2.488549,
      NULL,
      NULL,
      NULL,
      5.148100,
      NULL,
      NULL,
      NULL,
      1.915054,
      NULL,
      1.103996,
      NULL,
      NULL,
      NULL,
      3.606741,
      0,
      1.187760,
      1.197540,
      2.648786,
      0,
      1.693531,
      NULL,
      NULL,
      1.016185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946159,
      NULL,
      NULL,
      0,
      NULL,
      1.651111,
      289,
      2.803287,
      NULL,
      0.387416,
      0.558892,
      NULL,
      0,
      0,
      0,
      0.454865,
      1,
      NULL,
      1.749564,
      0.309593,
      0,
      1.938960,
      NULL,
      NULL,
      1.445860,
      3,
      NULL,
      NULL,
      NULL,
      1.946609,
      NULL,
      0,
      NULL,
      1.601468,
      NULL,
      2.418302,
      NULL,
      17,
      NULL,
      1.360902,
      NULL,
      NULL,
      0.974538,
      0.869363,
      NULL,
      NULL,
      0,
      NULL,
      1.227837,
      NULL,
      0.918082,
      NULL,
      0.916513,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.583344,
      NULL,
      0,
      NULL,
      0.623632,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.051649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814801,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.639827,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.162230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783485,
      1,
      1,
      3,
      5.131950,
      1,
      NULL,
      NULL,
      NULL,
      4,
      4.115158,
      0,
      NULL,
      5.839734,
      4,
      NULL,
      3.141034,
      9,
      1,
      1.171401,
      0.698666,
      1.083583,
      1,
      NULL,
      NULL,
      1,
      1.032703,
      0,
      NULL,
      0.414475,
      0,
      0,
      1,
      1.441715,
      NULL,
      2.707047,
      0,
      2,
      NULL,
      0,
      NULL,
      0.381802,
      1.270684,
      1,
      0,
      1,
      1.026037,
      1,
      2.699463,
      NULL,
      3,
      1.380072,
      0.910529,
      0.737617,
      2.758148,
      0,
      1.757903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057547,
      1.992728,
      1.522605,
      0.450245,
      NULL,
      NULL,
      6.105874,
      7,
      5.844197,
      2.939013,
      0.791461,
      1,
      80,
      80.042958,
      3.258346,
      0.194766,
      7.469002,
      '040',
      '34231',
      '40013',
      0,
      '10414',
      NULL,
      '',
      0.166726,
      '',
      '',
      '');
commit;
end;
/


