set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.303962,
      NULL,
      NULL,
      1,
      NULL,
      0.729481,
      1.600091,
      1.789007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830275,
      0,
      4,
      3,
      NULL,
      2,
      1.898634,
      NULL,
      NULL,
      NULL,
      52,
      22.797389,
      NULL,
      0.169245,
      2.481054,
      ' 0-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-15-1987',
      ' 2-14-1981',
      NULL,
      2.163912,
      2.681417,
      2,
      0,
      0,
      1,
      3.378413,
      1.275603,
      0,
      NULL,
      4,
      15,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.576625,
      NULL,
      0,
      NULL,
      0.396372,
      0,
      0.158251,
      0.979214,
      1.365224,
      NULL,
      0,
      0,
      1,
      2,
      2,
      2,
      3,
      11.741371,
      0.647246,
      0.099035,
      1.965009,
      NULL,
      1,
      5,
      NULL,
      0.667680,
      0,
      NULL,
      1,
      8,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.885171,
      0,
      NULL,
      NULL,
      1.458397,
      0,
      1,
      3,
      0,
      0.323646,
      NULL,
      1.445801,
      NULL,
      1,
      1,
      0.538448,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.573011,
      3,
      6,
      1.248452,
      NULL,
      1,
      2,
      0.235741,
      NULL,
      2.311479,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.247282,
      0,
      1.502609,
      1,
      1,
      5.037023,
      1,
      1,
      2.024575,
      0.888405,
      NULL,
      2.473555,
      1.793701,
      3,
      3,
      7.835649,
      5.398751,
      4.229980,
      3,
      4.353387,
      5,
      0.263906,
      0,
      1,
      0.623336,
      0,
      ' 2- 0-1983',
      NULL,
      ' 4-11-1993',
      NULL,
      0.870665,
      1.124016,
      0,
      7.509835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.498953,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619479,
      1,
      1.450070,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.216889,
      0,
      NULL,
      0.541710,
      1,
      NULL,
      NULL,
      6,
      1,
      0.483098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.507698,
      3,
      3.653635,
      1.825030,
      3,
      2,
      2.633688,
      1,
      1.296261,
      3.037557,
      3,
      3.285691,
      1,
      3,
      0.086575,
      1.082919,
      5.633325,
      0.167624,
      0,
      NULL,
      0,
      NULL,
      0.244809,
      0,
      1,
      0,
      0.160889,
      2.208351,
      0,
      7.869723,
      9,
      0.167493,
      6.559506,
      6.670316,
      NULL,
      0,
      1.244148,
      2.318264,
      3,
      2,
      NULL,
      NULL,
      0.489565,
      0.787825,
      21.347064,
      NULL,
      49,
      59.099387,
      NULL,
      5.441126,
      3.740188,
      '30444',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.087163,
      NULL,
      33.188435,
      30.486541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.126061,
      NULL,
      2,
      0.530397,
      NULL,
      NULL,
      1.732270,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.557506,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.120112,
      0.279838,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442202,
      NULL,
      NULL,
      0.967626,
      NULL,
      NULL,
      4.946755,
      NULL,
      2.676271,
      1.347814,
      0,
      NULL,
      NULL,
      NULL,
      1.234946,
      NULL,
      NULL,
      NULL,
      0.172701,
      NULL,
      NULL,
      1.495386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.241983,
      NULL,
      NULL,
      1.062530,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.569737,
      0.998649,
      1.372505,
      3,
      0,
      0.440299,
      NULL,
      NULL,
      NULL,
      1.750340,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609399,
      NULL,
      NULL,
      1.514115,
      NULL,
      NULL,
      0.526466,
      NULL,
      NULL,
      0.894175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.030026,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0.095090,
      NULL,
      NULL,
      1,
      0.589931,
      0.163516,
      NULL,
      0,
      NULL,
      0.668979,
      3.644942,
      1.726860,
      0,
      1.812873,
      3,
      1,
      1,
      3,
      1,
      3,
      3,
      1,
      3,
      5.427869,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.561509,
      1.434020,
      1,
      1.935600,
      NULL,
      0.245368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165194,
      0,
      1.260501,
      1,
      0,
      0.992847,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588450,
      NULL,
      NULL,
      NULL,
      3,
      1.344975,
      1.764367,
      NULL,
      NULL,
      NULL,
      1.982738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494080,
      NULL,
      NULL,
      0,
      NULL,
      1.662497,
      291,
      NULL,
      1.751984,
      1,
      1,
      NULL,
      0.989154,
      1.614072,
      1.261396,
      0,
      1.846079,
      NULL,
      0.730631,
      0,
      1,
      1,
      NULL,
      1,
      1.527481,
      1.863046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.361286,
      1,
      0.043759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368116,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.882088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081394,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.467693,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.019840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.239599,
      2,
      2.343187,
      NULL,
      0,
      3,
      2.836349,
      6,
      1,
      NULL,
      1.843874,
      1.851791,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.978473,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.707857,
      0.433401,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797989,
      0,
      NULL,
      1.632241,
      1.719649,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0.919991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491533,
      NULL,
      0.781445,
      NULL,
      0,
      NULL,
      4.068430,
      4.804260,
      0.184015,
      0.272258,
      NULL,
      NULL,
      60.256449,
      13.494835,
      3,
      5,
      0,
      '30041',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.767084,
      NULL,
      NULL,
      NULL);
commit;
end;
/


