set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44',
      '43',
      11.486354,
      NULL,
      '4203234',
      0.187466,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 0- 8-1999',
      21.317813,
      28,
      NULL,
      NULL,
      NULL,
      ' 2-25-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 7-18-1977',
      NULL,
      ' 4- 4-1984',
      NULL,
      0,
      2,
      1,
      0,
      0,
      1,
      0.646831,
      0.411551,
      4,
      3.417392,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.178927,
      5,
      0,
      0,
      1.418612,
      0.320470,
      0,
      1.496670,
      0.679562,
      NULL,
      2,
      0.547037,
      3,
      2,
      9.119295,
      NULL,
      0,
      0.667320,
      1,
      5.678787,
      NULL,
      6.992722,
      2.870071,
      1.315966,
      1.719127,
      1,
      0.547457,
      NULL,
      2.104130,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.601211,
      NULL,
      11.214823,
      3,
      0.145664,
      0,
      NULL,
      2,
      1.580760,
      2,
      NULL,
      1,
      1.998757,
      3,
      NULL,
      0.238785,
      3,
      NULL,
      3,
      3,
      1.869126,
      0.704604,
      4.547804,
      1,
      4,
      4,
      0.856374,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      5.911343,
      1,
      3.407061,
      0.869186,
      0.030331,
      1.368186,
      1,
      1.182344,
      0.495089,
      1,
      1,
      1,
      0,
      NULL,
      1.682998,
      0.255623,
      1,
      NULL,
      NULL,
      8.109672,
      NULL,
      3,
      7.716222,
      0.393677,
      NULL,
      5,
      8.847673,
      4,
      4.523809,
      5,
      7.716338,
      6,
      0.341579,
      6,
      9,
      NULL,
      NULL,
      8,
      7,
      3,
      NULL,
      3,
      NULL,
      4.627783,
      3.337423,
      0,
      NULL,
      NULL,
      ' 9- 1-1995',
      42.994604,
      1.160276,
      NULL,
      0.856867,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803188,
      0,
      0.037370,
      NULL,
      0.370256,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.711147,
      2.231723,
      1.933514,
      0,
      0.325434,
      1.222081,
      NULL,
      9,
      0,
      NULL,
      0.417578,
      NULL,
      NULL,
      NULL,
      0,
      3.549816,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.573552,
      1.658253,
      1.829670,
      0,
      1,
      0,
      0.121285,
      3,
      0,
      0,
      1.898325,
      NULL,
      NULL,
      NULL,
      2.994881,
      0,
      2,
      0.448471,
      0.223671,
      1.655503,
      NULL,
      3.193483,
      NULL,
      3,
      1.512398,
      2,
      1.689277,
      0.657922,
      2.264476,
      1,
      5,
      1.433535,
      1.548050,
      6.539574,
      1.428727,
      1,
      NULL,
      1,
      1,
      0.170307,
      1.956252,
      0.883473,
      0.019618,
      0.338796,
      1,
      NULL,
      5.846849,
      0.140027,
      NULL,
      0,
      5.161697,
      3,
      4,
      1,
      1.658916,
      0.793744,
      NULL,
      3.462436,
      32.573716,
      3.995278,
      2.236716,
      4.152095,
      NULL,
      53,
      17,
      4.748184,
      3.527170,
      1.894343,
      '20334',
      '',
      NULL,
      0.520995,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.004575,
      2,
      35,
      NULL,
      0.354057,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.755103,
      2.031085,
      0.808293,
      NULL,
      NULL,
      0.968652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.968259,
      1,
      0,
      1,
      2.074295,
      3.448026,
      0.662041,
      1.529037,
      3,
      0.639943,
      0.840363,
      NULL,
      NULL,
      1.703853,
      3,
      0,
      1,
      NULL,
      2.389878,
      8.735523,
      5.650474,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.868938,
      NULL,
      NULL,
      NULL,
      3,
      1.659910,
      0.894718,
      0.456796,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      0,
      1,
      1.627925,
      2.915740,
      0.923194,
      3,
      2.445048,
      NULL,
      1,
      0,
      0.159581,
      1,
      3,
      3,
      NULL,
      3.820552,
      1.421232,
      2.832706,
      0,
      NULL,
      NULL,
      NULL,
      1.918853,
      2.780584,
      9.036358,
      5,
      4.087408,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.993409,
      0,
      1,
      1,
      NULL,
      NULL,
      4,
      3,
      1.121309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234872,
      NULL,
      NULL,
      0.372904,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.721636,
      NULL,
      NULL,
      0.230530,
      NULL,
      NULL,
      1.686400,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5.138040,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.709870,
      NULL,
      3.050554,
      1.739448,
      3.523945,
      3,
      9,
      6.934125,
      NULL,
      2,
      0,
      NULL,
      2,
      0,
      1.238794,
      NULL,
      NULL,
      0,
      NULL,
      2.959814,
      9,
      7,
      3.919383,
      3.802510,
      4,
      0,
      2,
      2,
      7.231859,
      NULL,
      0,
      1.857423,
      0.509675,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.057373,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.854943,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583867,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934960,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.000775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.903706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.540507,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.294572,
      0.879285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917705,
      NULL,
      NULL,
      1.171155,
      NULL,
      1,
      53.457461,
      1,
      NULL,
      1,
      NULL,
      0,
      1.012735,
      NULL,
      0,
      2.873751,
      0.787439,
      1.827042,
      1.367836,
      1.324248,
      0,
      NULL,
      1,
      0.156433,
      1.235303,
      0,
      NULL,
      0.460944,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.768479,
      NULL,
      3,
      NULL,
      91.521547,
      NULL,
      2.314501,
      27.263322,
      NULL,
      1.344518,
      3,
      0.995762,
      NULL,
      1.000124,
      NULL,
      0.764760,
      NULL,
      1,
      NULL,
      0.800471,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.769980,
      NULL,
      NULL,
      NULL,
      1.787091,
      NULL,
      1.506655,
      NULL,
      1.446738,
      NULL,
      1,
      0.813289,
      0,
      0.153711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121793,
      0.616679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.661180,
      NULL,
      1,
      NULL,
      0.526237,
      NULL,
      NULL,
      NULL,
      1.846964,
      NULL,
      1.715705,
      NULL,
      1.410120,
      NULL,
      NULL,
      1.817090,
      3.334573,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661127,
      NULL,
      0.443688,
      1.759988,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191608,
      0.716309,
      NULL,
      1.529962,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.730827,
      NULL,
      1,
      1.377511,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.194784,
      1,
      NULL,
      1.073002,
      2.352899,
      39,
      1.868861,
      0.470224,
      NULL,
      NULL,
      NULL,
      2,
      3.684966,
      3.789809,
      3,
      1.608011,
      3.492848,
      0,
      4.829364,
      0.231584,
      3,
      1,
      1,
      0,
      0.509410,
      NULL,
      1,
      2.219270,
      NULL,
      0.325870,
      3,
      NULL,
      0.326292,
      3.878380,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.213626,
      NULL,
      NULL,
      1.773113,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1.043572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874032,
      NULL,
      1,
      NULL,
      0.311151,
      NULL,
      0.094631,
      2,
      NULL,
      1.557861,
      NULL,
      NULL,
      NULL,
      107.388036,
      2,
      5.684232,
      1.406296,
      '44024',
      '11114',
      '11004',
      0.759008,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


