set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1114341',
      3,
      0,
      1,
      2,
      '2123',
      2,
      0,
      NULL,
      NULL,
      ' 6-20-1990',
      16,
      NULL,
      4,
      NULL,
      NULL,
      ' 6- 7-1989',
      11.892688,
      0,
      NULL,
      121.784851,
      1,
      ' 4-26-1989',
      ' 1- 9-1979',
      '10- 7-2001',
      1.097756,
      2.099734,
      0.675987,
      0.634329,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      21,
      27.254281,
      4.953773,
      16,
      NULL,
      1,
      4.790337,
      0.683400,
      1,
      1.953363,
      1.556058,
      1.377123,
      0.492824,
      0.466179,
      3,
      5,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.754735,
      0.697746,
      NULL,
      NULL,
      0.601893,
      3.955357,
      3.483728,
      3,
      2,
      0.880778,
      1.599518,
      4.346551,
      0,
      NULL,
      NULL,
      0.917859,
      0.066717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.186733,
      1,
      NULL,
      2,
      0.722578,
      1,
      1,
      0,
      2,
      2.947920,
      3,
      0.260915,
      0.053593,
      3,
      0,
      0,
      1,
      NULL,
      0.053723,
      1,
      NULL,
      1.655372,
      3,
      0,
      2.688635,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.910758,
      0,
      0,
      2,
      2.913699,
      2.906435,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.667239,
      1.208093,
      0.363695,
      1.391284,
      1.269168,
      0,
      NULL,
      1.626740,
      0,
      2.427522,
      0.588128,
      5,
      1,
      0.104732,
      0.666051,
      3,
      3,
      8.831320,
      4.754568,
      1,
      4.783260,
      6.361095,
      0,
      0,
      0,
      2,
      NULL,
      0,
      2.111049,
      7.812292,
      6,
      1,
      NULL,
      0,
      2.784546,
      NULL,
      NULL,
      ' 8-29-1975',
      1092.384978,
      0.922845,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334307,
      NULL,
      0.974708,
      0.074812,
      NULL,
      NULL,
      NULL,
      1.334747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080481,
      NULL,
      1332,
      1.383960,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774040,
      9,
      NULL,
      5,
      NULL,
      7.769445,
      NULL,
      NULL,
      NULL,
      0.915157,
      2,
      1.309721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.853605,
      1,
      NULL,
      0,
      1.878525,
      0,
      NULL,
      0,
      1.268088,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      2.634481,
      0.399430,
      2.888823,
      NULL,
      0.916498,
      3,
      1,
      0.514517,
      3.771493,
      3.881405,
      3,
      NULL,
      3,
      0.552145,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1.208639,
      0.874555,
      1.090143,
      2.554433,
      NULL,
      0,
      0.862634,
      3.932024,
      NULL,
      11,
      10.860919,
      7.011014,
      1.065265,
      3.469863,
      NULL,
      1.596794,
      1,
      NULL,
      48.154945,
      0,
      1.316599,
      NULL,
      NULL,
      24,
      NULL,
      1.169646,
      1.751868,
      6.049814,
      '11221',
      '30243',
      '01144',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      NULL,
      8.031012,
      55.231362,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      2.427890,
      0.241265,
      0,
      3.102572,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.111121,
      3,
      2.281569,
      1.623245,
      NULL,
      1,
      2.223593,
      3.163541,
      NULL,
      NULL,
      2.040459,
      1.390909,
      0.462612,
      0.730451,
      NULL,
      1,
      NULL,
      1,
      1.136224,
      1,
      0,
      4.756467,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.263906,
      0,
      2,
      3,
      1.527134,
      1.140676,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.502101,
      0,
      0,
      2,
      0,
      1.530389,
      NULL,
      0.383759,
      1,
      3,
      0.343440,
      1.381728,
      NULL,
      NULL,
      1,
      3,
      3.006328,
      1.275045,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      7,
      2.117560,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314829,
      NULL,
      0.201292,
      1.221671,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.531836,
      NULL,
      NULL,
      0.825063,
      NULL,
      NULL,
      0.468946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.583220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848575,
      NULL,
      NULL,
      1.169329,
      1.663900,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816416,
      0,
      NULL,
      1.994703,
      4,
      4.354617,
      5,
      1.427025,
      NULL,
      0,
      NULL,
      1.611417,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.928771,
      1,
      2,
      1,
      0,
      0.343164,
      3.642748,
      NULL,
      0,
      3,
      2,
      3,
      2.549050,
      1,
      2.357558,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      0.790029,
      NULL,
      0.254619,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.483349,
      NULL,
      NULL,
      1.137272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.105904,
      3,
      3,
      1.511519,
      1.873368,
      7,
      2,
      NULL,
      92,
      177,
      440,
      NULL,
      1.076652,
      1.591248,
      2,
      NULL,
      0.661840,
      2.955655,
      0.894325,
      NULL,
      0.939423,
      1,
      1.694444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.083450,
      NULL,
      NULL,
      2,
      NULL,
      0.136864,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.268604,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      0.053728,
      NULL,
      1.904418,
      NULL,
      0.776195,
      0,
      1,
      NULL,
      0.779986,
      2.263249,
      NULL,
      NULL,
      NULL,
      1.294590,
      2.763205,
      NULL,
      3.033290,
      3,
      0.306360,
      NULL,
      0,
      1,
      0.255011,
      NULL,
      17.847632,
      NULL,
      9,
      NULL,
      3.535664,
      0.876499,
      2.099759,
      3.043298,
      5.914812,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521245,
      NULL,
      NULL,
      1.686490,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1878,
      8.742458,
      NULL,
      1,
      0.560886,
      NULL,
      1.567108,
      2,
      1.547931,
      0,
      1.527424,
      2,
      NULL,
      1,
      1.459017,
      1.367409,
      0,
      1.374157,
      NULL,
      NULL,
      NULL,
      1.373792,
      NULL,
      NULL,
      NULL,
      1.117367,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.604283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.478411,
      1.038843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.274063,
      3.742105,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.917526,
      NULL,
      1,
      0.877513,
      2,
      1.301897,
      1.239481,
      1.832727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585020,
      1.672565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.976583,
      NULL,
      3,
      NULL,
      0,
      1.263145,
      NULL,
      12,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.436780,
      5.844552,
      0,
      6,
      3.930536,
      NULL,
      NULL,
      1.002247,
      12,
      0,
      0.521691,
      0.820162,
      NULL,
      2,
      NULL,
      1.946369,
      0.099531,
      NULL,
      2,
      0.804867,
      NULL,
      0.535250,
      0,
      NULL,
      3.148013,
      2.460295,
      NULL,
      1.491650,
      NULL,
      NULL,
      0.881815,
      0.671245,
      NULL,
      0,
      1,
      NULL,
      1.104088,
      NULL,
      NULL,
      2.364884,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150633,
      2,
      NULL,
      1.090762,
      NULL,
      3,
      NULL,
      3.803428,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.305229,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.343343,
      NULL,
      0,
      NULL,
      0.083209,
      NULL,
      1,
      NULL,
      0,
      3.398636,
      NULL,
      0.205773,
      NULL,
      1.624156,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.735993,
      1.058413,
      NULL,
      NULL,
      30.071757,
      92.433801,
      4.354313,
      0.784847,
      1.221548,
      '22324',
      '31403',
      '11400',
      1,
      '',
      '',
      '',
      0.342003,
      '',
      '',
      '');
commit;
end;
/


