set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517294';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2304322',
      2,
      1.269734,
      0,
      1,
      NULL,
      1,
      0.281964,
      NULL,
      NULL,
      ' 9- 5-1985',
      15.405151,
      NULL,
      1,
      1,
      3,
      ' 1-24-1974',
      30,
      NULL,
      152,
      1.775992,
      0,
      NULL,
      NULL,
      ' 1- 9-2001',
      1,
      NULL,
      0.194901,
      0.122420,
      1.594965,
      1,
      2,
      2.152648,
      NULL,
      NULL,
      NULL,
      7,
      2.289127,
      3,
      NULL,
      0.154919,
      19,
      1.949132,
      1,
      0.763445,
      0.874488,
      NULL,
      0.448520,
      0,
      0.648718,
      NULL,
      1,
      NULL,
      0.616435,
      3.595144,
      1.636900,
      4.116008,
      0,
      2.078289,
      NULL,
      3,
      1.939943,
      0,
      2.403691,
      1,
      1,
      4,
      0.595216,
      1.140987,
      0.224375,
      0.128782,
      0.365186,
      NULL,
      0,
      2,
      0,
      1.146688,
      0.602092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.790171,
      1.705923,
      1.738908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816211,
      1.267631,
      0,
      NULL,
      NULL,
      0.699446,
      0,
      3.248430,
      1.548590,
      1,
      0,
      1,
      1.370821,
      0.642756,
      1.145766,
      0.740146,
      0,
      NULL,
      0.341172,
      NULL,
      1,
      1.056001,
      4,
      3.658514,
      7,
      4.073556,
      0.239552,
      NULL,
      1.069009,
      NULL,
      7,
      5,
      1.409132,
      0.119842,
      3.237979,
      5,
      3.610316,
      4,
      NULL,
      NULL,
      6,
      NULL,
      3.580843,
      3,
      4,
      2.996937,
      ' 7-14-1984',
      25.984324,
      ' 1-29-1991',
      5.755741,
      1,
      1.467544,
      1.784818,
      0.274643,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.606718,
      4,
      0,
      0,
      0,
      0.897364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1,
      3.821191,
      7,
      NULL,
      0.238476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899807,
      0,
      1,
      1.998007,
      0.245952,
      1.794537,
      0.144364,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005224,
      0,
      1.937353,
      5.612908,
      3,
      1.241181,
      5.620800,
      3,
      3.567564,
      1,
      NULL,
      3.296944,
      2.939121,
      0.078703,
      3,
      1.103149,
      1.742559,
      NULL,
      NULL,
      NULL,
      1,
      0.696888,
      1.221868,
      0.827775,
      0,
      1.296621,
      1,
      1.696327,
      NULL,
      3.851105,
      0.518968,
      9.989470,
      0,
      NULL,
      0.900416,
      4.725379,
      2.168602,
      4.898516,
      3,
      4,
      3.340709,
      0.593958,
      2.753406,
      20,
      NULL,
      0,
      34.714834,
      NULL,
      NULL,
      NULL,
      4.582547,
      3.526754,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.283864,
      '',
      NULL,
      '',
      NULL,
      28,
      NULL,
      22.986600,
      1.936252,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.178423,
      NULL,
      NULL,
      0.211593,
      NULL,
      NULL,
      0.258391,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.615181,
      NULL,
      3,
      1.148799,
      NULL,
      NULL,
      0.815825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.831426,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      1.331718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161089,
      NULL,
      NULL,
      1.503587,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.542280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.183584,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.641460,
      NULL,
      0,
      NULL,
      NULL,
      4.817761,
      0.553986,
      5.989406,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.347055,
      NULL,
      NULL,
      3,
      0.938570,
      3.480007,
      3.660869,
      0,
      3,
      1.133305,
      1.852156,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225458,
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      2.917677,
      2.353725,
      NULL,
      4.977627,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      3.629022,
      1.086882,
      4.293378,
      3,
      1,
      NULL,
      2.832788,
      3,
      3,
      1,
      1.533287,
      0,
      0,
      NULL,
      3.909641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424997,
      NULL,
      NULL,
      1.343596,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.520649,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.682046,
      1,
      0.291806,
      0,
      2.278607,
      1.687922,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      33.000784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.869867,
      NULL,
      NULL,
      NULL,
      1.060947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.353396,
      NULL,
      NULL,
      NULL,
      0.450064,
      NULL,
      NULL,
      NULL,
      0.118306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685889,
      NULL,
      NULL,
      NULL,
      4.956131,
      NULL,
      NULL,
      NULL,
      1.036144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.206228,
      NULL,
      1.416366,
      58,
      2.943193,
      1,
      1.821721,
      1,
      0,
      0,
      0,
      1.812643,
      1,
      NULL,
      0,
      1.458659,
      0.860638,
      NULL,
      1,
      1,
      0.540658,
      0.272983,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938803,
      0.919828,
      0.244517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.513952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720951,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464973,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.899743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767966,
      1,
      NULL,
      0,
      NULL,
      1.283287,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      1.981216,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.541528,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527512,
      NULL,
      6,
      2.837172,
      3,
      0.628371,
      1.870337,
      8.491769,
      1.536174,
      3.255329,
      1.295202,
      1,
      0,
      NULL,
      0.747248,
      1.399844,
      NULL,
      0.342392,
      0,
      NULL,
      1.752925,
      2.294723,
      NULL,
      NULL,
      1,
      NULL,
      2.376546,
      0,
      NULL,
      NULL,
      2.987246,
      NULL,
      1.182759,
      1,
      NULL,
      NULL,
      0.354265,
      NULL,
      1,
      0.341507,
      NULL,
      0,
      1,
      NULL,
      2,
      1.660782,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      2.802499,
      0.781643,
      NULL,
      NULL,
      28,
      98.011633,
      1.308547,
      1.140576,
      3,
      '10312',
      '',
      '',
      0.444042,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


