set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      23.315949,
      7.791634,
      '2321000',
      NULL,
      1.085392,
      0,
      NULL,
      '1144',
      NULL,
      1,
      NULL,
      NULL,
      ' 9-15-1998',
      45,
      NULL,
      NULL,
      2.151168,
      NULL,
      ' 7-16-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      0.982335,
      '10-11-1978',
      NULL,
      ' 0-15-1975',
      NULL,
      NULL,
      3,
      0,
      1.617277,
      NULL,
      0.134415,
      0,
      0.877570,
      NULL,
      2.878382,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1.600708,
      NULL,
      0,
      1.690365,
      0.335221,
      1,
      NULL,
      0.537411,
      0,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      11.678336,
      NULL,
      NULL,
      1,
      0.969101,
      0,
      1,
      1,
      0.590028,
      0.214623,
      1.043131,
      NULL,
      1,
      1,
      0.616326,
      NULL,
      NULL,
      1.005615,
      NULL,
      NULL,
      2.371109,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      1,
      0.901454,
      1,
      NULL,
      0.309687,
      1,
      1.243479,
      3,
      0,
      NULL,
      0.314094,
      0.552026,
      1.960804,
      0,
      1,
      0,
      1.274327,
      1.208211,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.281116,
      2,
      6.241235,
      1.916516,
      1.696258,
      NULL,
      0,
      1,
      1,
      0.042862,
      1,
      1.597938,
      NULL,
      0.002383,
      NULL,
      0,
      1.614936,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.938239,
      2.431240,
      NULL,
      1.460758,
      NULL,
      7,
      9,
      0,
      NULL,
      11,
      NULL,
      10,
      NULL,
      8,
      NULL,
      11.999808,
      NULL,
      4,
      8,
      6,
      9.275047,
      3.038889,
      7,
      1,
      0,
      0.899453,
      '11-25-1982',
      140,
      NULL,
      14,
      1,
      0.889074,
      1,
      6.663792,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618612,
      0.437484,
      0,
      1,
      1.534779,
      0,
      0,
      1.321910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.242038,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      1.093996,
      3.315133,
      2,
      NULL,
      0,
      0,
      1.369290,
      NULL,
      NULL,
      NULL,
      NULL,
      2.037120,
      0,
      NULL,
      1.763943,
      7.120272,
      1.271475,
      NULL,
      NULL,
      NULL,
      0.648549,
      9,
      0.386042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.668644,
      1.856216,
      NULL,
      NULL,
      1.237955,
      NULL,
      0.885342,
      43.964743,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.386785,
      2,
      2.199698,
      1,
      NULL,
      3.089711,
      3,
      NULL,
      NULL,
      0.662006,
      NULL,
      0,
      0,
      NULL,
      3.494685,
      NULL,
      NULL,
      0.565462,
      0,
      1.438771,
      1.496476,
      1.672951,
      NULL,
      0.652009,
      1,
      0.742208,
      NULL,
      0.992664,
      0,
      1,
      3.837178,
      1,
      9.378642,
      4.912485,
      NULL,
      4.569909,
      3.061271,
      NULL,
      NULL,
      3.596569,
      1.411458,
      3.004346,
      NULL,
      1,
      64.687800,
      0.832084,
      NULL,
      19.875228,
      NULL,
      1,
      5,
      NULL,
      NULL,
      2.185395,
      '23243',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      10,
      13.143324,
      12.588253,
      NULL,
      35,
      3,
      4.074620,
      4.420671,
      2.259686,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.808029,
      NULL,
      NULL,
      2,
      0.115350,
      3.629128,
      NULL,
      NULL,
      NULL,
      0.814928,
      NULL,
      NULL,
      2.727552,
      2.010059,
      1,
      1,
      NULL,
      NULL,
      1.416870,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.161269,
      6.105576,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.355651,
      1,
      2.556853,
      NULL,
      2.282382,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554682,
      1,
      1,
      1,
      1.430749,
      3,
      NULL,
      0.257684,
      1,
      NULL,
      0.234351,
      0.136898,
      3.613809,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.357634,
      1.991003,
      1.178133,
      1,
      0,
      NULL,
      NULL,
      0.904713,
      1,
      NULL,
      3,
      2,
      0,
      0.907259,
      NULL,
      NULL,
      4,
      6.900428,
      4,
      0,
      NULL,
      NULL,
      0.701724,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.425336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427763,
      1.740671,
      0,
      0.647702,
      NULL,
      NULL,
      6.140816,
      4,
      5.106278,
      8,
      8,
      2,
      5.726667,
      2.790009,
      1.452557,
      0,
      1.007449,
      0,
      0.446826,
      2,
      3,
      1.078147,
      NULL,
      0,
      9.738390,
      NULL,
      0,
      2.185643,
      0.681548,
      1,
      0,
      2,
      3.724606,
      0,
      NULL,
      3.997331,
      2.016667,
      0.884528,
      0,
      3.220982,
      9.229618,
      5.562306,
      NULL,
      5.105866,
      4.390323,
      NULL,
      0,
      6,
      1,
      1,
      1.904935,
      1.991186,
      NULL,
      2.932460,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220908,
      NULL,
      NULL,
      0.446568,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.676162,
      NULL,
      NULL,
      1,
      0.602487,
      0,
      NULL,
      5.499960,
      0.812230,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      2.401290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.903580,
      NULL,
      NULL,
      0.700793,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.233746,
      0.368723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869983,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.561594,
      NULL,
      NULL,
      1,
      0.166633,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.353083,
      NULL,
      NULL,
      NULL,
      1.926106,
      0.266734,
      NULL,
      NULL,
      3.916250,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.215307,
      3,
      2.797992,
      NULL,
      17,
      693,
      3,
      6,
      637,
      1.420841,
      NULL,
      NULL,
      3,
      2,
      75.668826,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.323090,
      10,
      11850.505209,
      1,
      0.008329,
      1,
      1.656312,
      1.628028,
      0,
      NULL,
      1.521014,
      0,
      0,
      1,
      0.408676,
      0.252011,
      NULL,
      0.295131,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.383368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343112,
      1.653865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029084,
      0.844439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.028595,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.680126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      0.338245,
      7.574389,
      4,
      2,
      2.872466,
      1.621552,
      19,
      1.245105,
      3,
      1.488396,
      NULL,
      1,
      NULL,
      1.564197,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.541521,
      NULL,
      3,
      1.699755,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.232796,
      NULL,
      0.543317,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.643600,
      0.332731,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10.754997,
      1,
      0,
      1.065824,
      NULL,
      118,
      1,
      NULL,
      0.225960,
      '21114',
      '31220',
      '',
      1,
      NULL,
      '',
      '',
      0.199057,
      '',
      '',
      '');
commit;
end;
/


