set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '2411441',
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 8- 1-1993',
      57.024673,
      NULL,
      3,
      0,
      1.562679,
      NULL,
      61.761195,
      5.912851,
      NULL,
      108.415982,
      3,
      ' 9-13-1975',
      ' 9-28-1985',
      NULL,
      1,
      3,
      1.954072,
      1.010328,
      NULL,
      2.475813,
      3.382670,
      0,
      NULL,
      26.210319,
      2.297528,
      7,
      7.645771,
      6.480014,
      12,
      0,
      27,
      NULL,
      0.486179,
      6.232668,
      1.676940,
      3,
      NULL,
      0,
      NULL,
      1.972288,
      1,
      1.212689,
      1,
      1,
      0,
      1.412985,
      5.484196,
      3.879704,
      NULL,
      2,
      1.334690,
      4.219306,
      1,
      2,
      2.864386,
      9.634744,
      4.293834,
      0,
      1,
      1.840792,
      0,
      3.408812,
      0.245790,
      NULL,
      0,
      2.514597,
      1.750938,
      0.726714,
      2,
      1.540348,
      NULL,
      NULL,
      8.184702,
      3.077409,
      2.766695,
      NULL,
      0.779802,
      3.883850,
      NULL,
      0.003065,
      0.351069,
      2,
      0,
      0,
      NULL,
      2,
      1,
      0,
      2,
      0.110933,
      0,
      1,
      0.523450,
      7.627160,
      2,
      1.468918,
      0,
      1,
      2.033291,
      NULL,
      3.519785,
      0.373834,
      NULL,
      NULL,
      2,
      4,
      9,
      0,
      4.964876,
      2.572144,
      0.833634,
      1,
      3.980268,
      0.040803,
      2.255079,
      4,
      1,
      6,
      1.018590,
      0,
      NULL,
      1.228978,
      0.007559,
      NULL,
      NULL,
      0.891497,
      5,
      4.679867,
      1.762470,
      5,
      NULL,
      6,
      0.347648,
      5.258790,
      1,
      0,
      3.844313,
      6,
      NULL,
      NULL,
      6.945000,
      4,
      8.248164,
      NULL,
      4.338814,
      0.892990,
      NULL,
      4.685223,
      NULL,
      8.133143,
      0.340183,
      3,
      ' 5-13-1992',
      583,
      ' 5-24-1987',
      48,
      1,
      1.459022,
      0,
      2.575922,
      3.141301,
      NULL,
      4,
      1,
      0.553186,
      0,
      NULL,
      9.449914,
      8.537444,
      1,
      6,
      2.478691,
      0,
      0,
      2.655096,
      NULL,
      NULL,
      ' 5- 8-1999',
      1,
      ' 8- 3-2001',
      2.161547,
      1,
      1,
      1,
      NULL,
      NULL,
      1.190389,
      3,
      1.232487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.550222,
      6.240508,
      5,
      0,
      4,
      2,
      NULL,
      NULL,
      NULL,
      1.893556,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310582,
      2,
      1.733142,
      3.817917,
      3.512799,
      0,
      1,
      2,
      23.004298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      5,
      NULL,
      3.171762,
      3.153027,
      NULL,
      NULL,
      1,
      NULL,
      0.564976,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1.747879,
      1.376011,
      0,
      0,
      0.371157,
      0.409581,
      0.560809,
      0.480509,
      NULL,
      0.359807,
      1,
      1,
      NULL,
      0.263769,
      NULL,
      5.216111,
      4.942706,
      0,
      NULL,
      5,
      4.020184,
      3.713808,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      12,
      1,
      28.525565,
      4,
      1.398542,
      0,
      '41421',
      '',
      '',
      3.786811,
      '00210',
      '',
      NULL,
      0.027124,
      '',
      '',
      '',
      1,
      27,
      309.990740,
      7.834135,
      2,
      5.356050,
      11.251922,
      11,
      5.201700,
      0,
      NULL,
      0.035878,
      0.859198,
      NULL,
      NULL,
      3.571320,
      1.415193,
      0,
      0.870859,
      NULL,
      NULL,
      2.574786,
      0.770216,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.171791,
      0,
      NULL,
      1,
      1.231453,
      NULL,
      NULL,
      0.231782,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661477,
      0,
      1.033001,
      0,
      2,
      0,
      NULL,
      3,
      0.735739,
      NULL,
      0,
      2.759849,
      NULL,
      1,
      1,
      NULL,
      0.110281,
      NULL,
      1.446996,
      NULL,
      NULL,
      1.538539,
      2.363980,
      NULL,
      NULL,
      3.486378,
      0.775420,
      1,
      NULL,
      NULL,
      0,
      1,
      0.459235,
      1.034906,
      2.965010,
      3.285011,
      NULL,
      0,
      NULL,
      NULL,
      0.085797,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1.964115,
      0.697663,
      1.084257,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      0,
      2,
      1.073967,
      NULL,
      NULL,
      3,
      0.536384,
      0,
      3,
      1.498643,
      NULL,
      1,
      NULL,
      NULL,
      0.210631,
      0.260083,
      1.175628,
      1,
      0,
      1,
      0.419000,
      0,
      1,
      7,
      NULL,
      0,
      0.991062,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585995,
      0,
      0.992587,
      7,
      1.391925,
      0,
      2.206763,
      2.609796,
      1.655360,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.193087,
      1,
      1.268204,
      3.838480,
      1.196486,
      1,
      3,
      3,
      1.855916,
      4,
      4,
      1,
      2,
      0,
      1,
      0.309563,
      0,
      5,
      2.548298,
      2,
      1,
      0.179713,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      12.375870,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.491769,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.609234,
      NULL,
      NULL,
      0.266228,
      0.030219,
      NULL,
      1,
      1.339875,
      NULL,
      2.083913,
      2.388811,
      NULL,
      2,
      1.930503,
      NULL,
      NULL,
      2.436672,
      NULL,
      NULL,
      1.022191,
      1,
      0.863544,
      2,
      0.695051,
      NULL,
      NULL,
      5.824511,
      NULL,
      2.062858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.071638,
      NULL,
      1.439091,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.008766,
      3.401365,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2.756529,
      NULL,
      NULL,
      NULL,
      3.655344,
      NULL,
      1.412251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.640544,
      1.171083,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.599832,
      1.900387,
      3,
      NULL,
      1,
      1.854003,
      2.909619,
      NULL,
      3.042397,
      1.553384,
      1.403132,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.073073,
      1,
      13.640713,
      NULL,
      11.881426,
      0.715751,
      2.628085,
      NULL,
      3.550482,
      NULL,
      0,
      3,
      0.679332,
      128.748991,
      33,
      3,
      NULL,
      0,
      1.248366,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      10.414874,
      0,
      NULL,
      0.959389,
      1,
      NULL,
      NULL,
      105,
      NULL,
      NULL,
      NULL,
      0.784002,
      1.548881,
      NULL,
      1.369151,
      0.859645,
      0.978459,
      0,
      1.566212,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0.258979,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.733707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890497,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852817,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.630911,
      NULL,
      2.034045,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.041129,
      NULL,
      1,
      NULL,
      0.027610,
      1,
      1.295762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339336,
      1.378807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.530317,
      NULL,
      0.624204,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.510103,
      NULL,
      1,
      NULL,
      1.838837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.319534,
      NULL,
      NULL,
      1.482736,
      NULL,
      NULL,
      3.756691,
      NULL,
      0.784014,
      3.721126,
      3.757111,
      1.416803,
      NULL,
      1.814701,
      1,
      0,
      0,
      0.273587,
      1.542153,
      1.936679,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1.937909,
      1,
      1,
      1.216845,
      1,
      1,
      NULL,
      0.460186,
      1.939733,
      0,
      1,
      1.806771,
      1.024017,
      1,
      0.841064,
      0.130708,
      NULL,
      0,
      2,
      1,
      NULL,
      1.444780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.678954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.528073,
      0,
      NULL,
      NULL,
      NULL,
      3.663054,
      9.245419,
      NULL,
      0,
      NULL,
      NULL,
      70.092320,
      29,
      1.408816,
      0.658317,
      0,
      NULL,
      '',
      '',
      2,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


